/*
 * Decompiled with CFR 0.152.
 */
package org.exist.memtree;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.exist.memtree.MemTreeBuilder;
import org.exist.xquery.XQueryContext;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class SAXAdapter
implements ContentHandler,
LexicalHandler {
    private MemTreeBuilder builder;
    private HashMap namespaces = null;

    public SAXAdapter() {
        this.builder = new MemTreeBuilder();
    }

    public SAXAdapter(XQueryContext context) {
        this.builder = new MemTreeBuilder(context);
    }

    public Document getDocument() {
        return this.builder.getDocument();
    }

    public void endDocument() throws SAXException {
        this.builder.endDocument();
    }

    public void startDocument() throws SAXException {
        this.builder.startDocument();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.builder.characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.builder.processingInstruction(target, data);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.namespaces == null) {
            this.namespaces = new HashMap();
        }
        this.namespaces.put(prefix, uri);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.builder.endElement();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.builder.startElement(namespaceURI, localName, qName, atts);
        if (this.namespaces != null) {
            Iterator i = this.namespaces.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                this.builder.namespaceNode(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            if (!atts.getQName(i).startsWith("xmlns")) continue;
            String prefix = atts.getLocalName(i);
            String uri = atts.getValue(i);
            if (this.namespaces.containsKey(prefix)) continue;
            this.builder.namespaceNode(prefix, uri);
        }
        this.namespaces = null;
    }

    public void endCDATA() throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.builder.comment(ch, start, length);
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }
}

