/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections;

import org.exist.Indexer;
import org.exist.collections.CollectionConfiguration;
import org.exist.collections.triggers.DocumentTrigger;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.DocumentImpl;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.Txn;
import org.exist.util.serializer.DOMStreamer;
import org.exist.xmldb.XmldbURI;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class IndexInfo {
    private Indexer indexer;
    private DOMStreamer streamer;
    private DocumentTrigger trigger;
    private int event;
    private CollectionConfiguration collectionConfig;

    IndexInfo(Indexer indexer, CollectionConfiguration collectionConfig) {
        this.indexer = indexer;
        this.collectionConfig = collectionConfig;
    }

    public Indexer getIndexer() {
        return this.indexer;
    }

    int getEvent() {
        return this.event;
    }

    void setReader(XMLReader reader, EntityResolver entityResolver) throws SAXException {
        if (entityResolver != null) {
            reader.setEntityResolver(entityResolver);
        }
        LexicalHandler lexicalHandler = this.trigger == null ? this.indexer : this.trigger.getLexicalInputHandler();
        ContentHandler contentHandler = this.trigger == null ? this.indexer : this.trigger.getInputHandler();
        reader.setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
        reader.setContentHandler(contentHandler);
        reader.setErrorHandler(this.indexer);
    }

    void setDOMStreamer(DOMStreamer streamer) {
        this.streamer = streamer;
        if (this.trigger == null) {
            streamer.setContentHandler(this.indexer);
            streamer.setLexicalHandler(this.indexer);
        } else {
            streamer.setContentHandler(this.trigger.getInputHandler());
            streamer.setLexicalHandler(this.trigger.getLexicalInputHandler());
        }
    }

    public DOMStreamer getDOMStreamer() {
        return this.streamer;
    }

    public DocumentImpl getDocument() {
        return this.indexer.getDocument();
    }

    public CollectionConfiguration getCollectionConfig() {
        return this.collectionConfig;
    }

    void setTrigger(DocumentTrigger trigger, int event) {
        this.trigger = trigger;
        this.event = event;
    }

    DocumentTrigger getTrigger() {
        return this.trigger;
    }

    void prepareTrigger(DBBroker broker, Txn transaction, XmldbURI docUri, DocumentImpl doc) throws TriggerException {
        if (this.trigger == null) {
            return;
        }
        this.trigger.setOutputHandler(this.indexer);
        this.trigger.setLexicalOutputHandler(this.indexer);
        this.trigger.setValidating(true);
        this.trigger.prepare(this.event, broker, transaction, docUri, doc);
    }

    void postValidateTrigger() {
        if (this.trigger == null) {
            return;
        }
        this.trigger.setValidating(false);
    }

    void finishTrigger(DBBroker broker, Txn transaction, XmldbURI documentPath, DocumentImpl doc) {
        if (this.trigger == null) {
            return;
        }
        this.trigger.finish(this.event, broker, transaction, documentPath, doc);
    }
}

