/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.load.text;

import com.topologi.diffx.event.TextEvent;
import com.topologi.diffx.event.impl.IgnorableSpaceEvent;
import com.topologi.diffx.event.impl.WordEvent;
import com.topologi.diffx.event.lang.Repertory;
import com.topologi.diffx.load.text.TextTokeniser;
import java.util.NoSuchElementException;

public final class TextTokeniserIgnoreSpace
implements TextTokeniser {
    private static final byte TEXT = 0;
    private static final byte SPACE = 1;
    private final CharSequence seq;
    private transient int max = -1;
    private transient int marker = 0;
    private transient Repertory repertory = null;

    public TextTokeniserIgnoreSpace(CharSequence charSequence) throws NullPointerException {
        if (charSequence == null) {
            throw new NullPointerException("The string buffer cannot be null.");
        }
        this.seq = charSequence;
    }

    public int countTokens() {
        if (this.seq.length() == 0) {
            return 0;
        }
        if (this.max >= 0) {
            return this.max;
        }
        byte by = -1;
        int n = 0;
        for (int i = 0; i < this.seq.length(); ++i) {
            if (by == TextTokeniserIgnoreSpace.getType(this.seq.charAt(i))) continue;
            by = TextTokeniserIgnoreSpace.getType(this.seq.charAt(i));
            ++n;
        }
        this.max = n;
        return n;
    }

    public TextEvent nextToken() throws NoSuchElementException {
        if (this.marker == this.seq.length()) {
            throw new NoSuchElementException("All tokens have been returned.");
        }
        byte by = TextTokeniserIgnoreSpace.getType(this.seq.charAt(this.marker));
        for (int i = this.marker; i < this.seq.length(); ++i) {
            if (by == TextTokeniserIgnoreSpace.getType(this.seq.charAt(i))) continue;
            TextEvent textEvent = this.newToken(by, this.marker, i);
            this.marker = i;
            return textEvent;
        }
        TextEvent textEvent = this.newToken(by, this.marker, this.seq.length());
        this.marker = this.seq.length();
        return textEvent;
    }

    public void useRepertory(Repertory repertory) {
        this.repertory = repertory;
    }

    private static byte getType(char c) {
        return Character.isWhitespace(c) ? (byte)1 : 0;
    }

    private TextEvent newToken(byte by, int n, int n2) {
        switch (by) {
            case 0: {
                String string = ((Object)this.seq.subSequence(n, n2)).toString();
                if (this.repertory == null) {
                    return new WordEvent(string);
                }
                return this.repertory.update(string);
            }
            case 1: {
                return new IgnorableSpaceEvent(this.seq.subSequence(n, n2));
            }
        }
        throw new NoSuchElementException("Cannot create token of unknown type.");
    }
}

