/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.format;

import com.topologi.diffx.config.DiffXConfig;
import com.topologi.diffx.event.AttributeEvent;
import com.topologi.diffx.event.CloseElementEvent;
import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.event.OpenElementEvent;
import com.topologi.diffx.event.impl.CharEvent;
import com.topologi.diffx.event.impl.SpaceEvent;
import com.topologi.diffx.event.impl.WordEvent;
import com.topologi.diffx.format.XMLDiffXFormatter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public final class StrictXMLFormatter
implements XMLDiffXFormatter {
    private final PrintWriter xml;
    private String openDel = "<del>";
    private String closeDel = "</del>";
    private String openIns = "<ins>";
    private String closeIns = "</ins>";
    private DiffXConfig config = new DiffXConfig();
    private transient boolean declareNamespace = true;
    private transient boolean isInserting = false;
    private transient boolean isDeleting = false;
    private transient boolean isElementNude = false;
    private transient boolean writeXMLDeclaration = true;

    public StrictXMLFormatter() {
        this.xml = new PrintWriter(System.out);
        this.init();
    }

    public StrictXMLFormatter(Writer writer) {
        this.xml = new PrintWriter(writer);
        this.init();
    }

    private void init() {
        this.xml.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void format(DiffXEvent diffXEvent) throws IOException {
        if (diffXEvent instanceof OpenElementEvent) {
            if (this.isElementNude) {
                this.denudeElement();
            }
            if (this.isInserting) {
                this.closeIns();
            }
            if (this.isDeleting) {
                this.closeDel();
            }
            OpenElementEvent openElementEvent = (OpenElementEvent)diffXEvent;
            this.xml.print('<' + openElementEvent.getName());
            if (this.declareNamespace) {
                this.xml.print(" xmlns:dfx=\"http://www.topologi.org/2004/Diff-X\"");
                this.declareNamespace = false;
            }
            this.isElementNude = true;
        } else if (diffXEvent instanceof CloseElementEvent) {
            if (this.isElementNude) {
                this.denudeElement();
            }
            if (this.isInserting) {
                this.closeIns();
            }
            if (this.isDeleting) {
                this.closeDel();
            }
            this.xml.print(diffXEvent.toXML());
        } else if (diffXEvent instanceof AttributeEvent) {
            if (!this.isElementNude) throw new IllegalStateException("Cannot write an attribute once the element is closed");
            this.xml.print(diffXEvent.toXML());
        } else {
            if (this.isElementNude) {
                this.denudeElement();
            }
            if (this.isInserting) {
                this.closeIns();
            }
            if (this.isDeleting) {
                this.closeDel();
            }
            if (diffXEvent instanceof WordEvent || diffXEvent instanceof SpaceEvent) {
                this.xml.print(diffXEvent.toXML());
            } else if (diffXEvent instanceof CharEvent) {
                this.xml.print(((CharEvent)diffXEvent).c);
            }
        }
        this.xml.flush();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insert(DiffXEvent diffXEvent) throws IOException {
        if (diffXEvent instanceof OpenElementEvent) {
            if (this.isElementNude) {
                this.denudeElement();
            }
            if (this.isDeleting) {
                this.closeDel();
            }
            OpenElementEvent openElementEvent = (OpenElementEvent)diffXEvent;
            this.xml.print('<' + openElementEvent.getName());
            if (this.declareNamespace) {
                this.xml.print(" xmlns:dfx=\"http://www.allette.com.au/diffex\"");
            }
            this.xml.print(" dfx:insert=\"true\"");
            this.isElementNude = true;
        } else if (diffXEvent instanceof CloseElementEvent) {
            if (this.isElementNude) {
                this.denudeElement();
            }
            if (this.isDeleting) {
                this.closeDel();
            }
            this.xml.print("</");
            this.xml.print(((CloseElementEvent)diffXEvent).getName());
            this.xml.print('>');
        } else if (diffXEvent instanceof AttributeEvent) {
            if (!this.isElementNude) throw new IllegalStateException("Cannot insert an attribute once the element is closed");
            this.xml.print(" ");
            this.xml.print(((AttributeEvent)diffXEvent).getName());
            this.xml.print("=\"");
            this.xml.print(((AttributeEvent)diffXEvent).getValue());
            this.xml.print('\"');
        } else {
            if (this.isElementNude) {
                this.denudeElement();
            }
            if (this.isDeleting) {
                this.closeDel();
            }
            if (diffXEvent instanceof WordEvent) {
                if (!this.isInserting) {
                    this.openIns();
                }
                this.xml.print(diffXEvent.toXML());
            } else if (diffXEvent instanceof SpaceEvent) {
                this.xml.print(diffXEvent.toXML());
            } else if (diffXEvent instanceof CharEvent) {
                this.xml.print(((CharEvent)diffXEvent).c);
            }
        }
        this.xml.flush();
    }

    public void delete(DiffXEvent diffXEvent) throws IOException, IllegalStateException {
        if (this.isElementNude) {
            this.denudeElement();
        }
        if (this.isInserting) {
            this.closeIns();
        }
        if (diffXEvent instanceof OpenElementEvent) {
            OpenElementEvent openElementEvent = (OpenElementEvent)diffXEvent;
            this.xml.print('<' + openElementEvent.getName());
            if (this.declareNamespace) {
                this.xml.print(" xmlns:dfx=\"http://www.allette.com.au/diffex\"");
            }
            this.xml.print(" dfx:delete=\"true\"");
            this.xml.print('>');
        } else if (diffXEvent instanceof CloseElementEvent) {
            this.xml.print("</");
            this.xml.print(((CloseElementEvent)diffXEvent).getName());
            this.xml.print('>');
        } else if (diffXEvent instanceof WordEvent) {
            if (!this.isDeleting) {
                this.openDel();
            }
            this.xml.print(diffXEvent.toXML());
        } else if (diffXEvent instanceof SpaceEvent) {
            this.xml.print(diffXEvent.toXML());
        } else if (diffXEvent instanceof CharEvent) {
            this.xml.print(((CharEvent)diffXEvent).c);
        }
        this.xml.flush();
    }

    public void setInsertTags(String string, String string2) throws NullPointerException {
        if (string == null) {
            throw new NullPointerException("The start element for inserted text must have a value");
        }
        if (string2 == null) {
            throw new NullPointerException("The start element for inserted text must have a value");
        }
        this.openIns = string;
        this.closeIns = string2;
    }

    public void setDeleteTags(String string, String string2) throws NullPointerException {
        if (string == null) {
            throw new NullPointerException("The start element for deleted text must have a value");
        }
        if (string2 == null) {
            throw new NullPointerException("The start element for deleted text must have a value");
        }
        this.openDel = string;
        this.closeDel = string2;
    }

    public void setConfig(DiffXConfig diffXConfig) {
        this.config = diffXConfig;
    }

    public void setWriteXMLDeclaration(boolean bl) {
        this.writeXMLDeclaration = bl;
    }

    private void openIns() {
        this.xml.print(this.openIns);
        this.isInserting = true;
    }

    private void openDel() {
        this.xml.print(this.openDel);
        this.isDeleting = true;
    }

    private void closeIns() {
        this.xml.print(this.closeIns);
        this.isInserting = false;
    }

    private void closeDel() {
        this.xml.print(this.closeDel);
        this.isDeleting = false;
    }

    private void denudeElement() {
        this.xml.print(">");
        this.isElementNude = false;
    }
}

