/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.algorithm;

import com.topologi.diffx.event.CloseElementEvent;
import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.event.OpenElementEvent;

final class ElementState {
    private transient OpenElementEvent[] openElements;
    private transient char[] openChanges;
    private transient int size;

    public ElementState(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.openElements = new OpenElementEvent[n];
        this.openChanges = new char[n];
    }

    public ElementState() {
        this(12);
    }

    public void ensureCapacity(int n) {
        int n2 = this.openElements.length;
        if (n > n2) {
            OpenElementEvent[] openElementEventArray = this.openElements;
            char[] cArray = this.openChanges;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.openElements = new OpenElementEvent[n3];
            this.openChanges = new char[n3];
            System.arraycopy(openElementEventArray, 0, this.openElements, 0, this.size);
            System.arraycopy(cArray, 0, this.openChanges, 0, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(OpenElementEvent openElementEvent) {
        return this.indexOf(openElementEvent) >= 0;
    }

    public int indexOf(OpenElementEvent openElementEvent) {
        if (openElementEvent == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.openElements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!openElementEvent.equals(this.openElements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(OpenElementEvent openElementEvent) {
        if (openElementEvent == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.openElements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!openElementEvent.equals(this.openElements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public OpenElementEvent current() {
        if (!this.isEmpty()) {
            return this.openElements[this.size - 1];
        }
        return null;
    }

    public char currentChange() {
        if (!this.isEmpty()) {
            return this.openChanges[this.size - 1];
        }
        return ' ';
    }

    public boolean matchCurrent(DiffXEvent diffXEvent) {
        if (this.isEmpty()) {
            return false;
        }
        if (!(diffXEvent instanceof CloseElementEvent)) {
            return false;
        }
        return ((CloseElementEvent)diffXEvent).match(this.current());
    }

    public void insert(DiffXEvent diffXEvent) {
        if (diffXEvent instanceof OpenElementEvent) {
            this.push((OpenElementEvent)diffXEvent, '+');
        } else if (diffXEvent instanceof CloseElementEvent) {
            this.pop();
        }
    }

    public void format(DiffXEvent diffXEvent) {
        if (diffXEvent instanceof OpenElementEvent) {
            this.push((OpenElementEvent)diffXEvent, '=');
        } else if (diffXEvent instanceof CloseElementEvent) {
            this.pop();
        }
    }

    public void delete(DiffXEvent diffXEvent) {
        if (diffXEvent instanceof OpenElementEvent) {
            this.push((OpenElementEvent)diffXEvent, '-');
        } else if (diffXEvent instanceof CloseElementEvent) {
            this.pop();
        }
    }

    public boolean okFormat(DiffXEvent diffXEvent) {
        if (!(diffXEvent instanceof CloseElementEvent)) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        return ((CloseElementEvent)diffXEvent).match(this.current()) && this.openChanges[this.size - 1] == '=';
    }

    public boolean okInsert(DiffXEvent diffXEvent) {
        if (!(diffXEvent instanceof CloseElementEvent)) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        return ((CloseElementEvent)diffXEvent).match(this.current()) && this.openChanges[this.size - 1] == '+';
    }

    public boolean okDelete(DiffXEvent diffXEvent) {
        if (!(diffXEvent instanceof CloseElementEvent)) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        return ((CloseElementEvent)diffXEvent).match(this.current()) && this.openChanges[this.size - 1] == '-';
    }

    private void push(OpenElementEvent openElementEvent, char c) {
        this.ensureCapacity(this.size + 1);
        this.openElements[this.size] = openElementEvent;
        this.openChanges[this.size] = c;
        ++this.size;
    }

    public OpenElementEvent pop() {
        if (this.size > 0) {
            --this.size;
            return this.openElements[this.size];
        }
        return null;
    }

    public OpenElementEvent get(int n) throws IndexOutOfBoundsException {
        this.checkRange(n);
        return this.openElements[n];
    }

    private boolean add(OpenElementEvent openElementEvent) {
        this.ensureCapacity(this.size + 1);
        this.openElements[this.size++] = openElementEvent;
        return true;
    }

    public OpenElementEvent remove(int n) throws IndexOutOfBoundsException {
        this.checkRange(n);
        OpenElementEvent openElementEvent = this.openElements[n];
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.openElements, n + 1, this.openElements, n, n2);
        }
        this.openElements[--this.size] = null;
        return openElementEvent;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.openElements[i] = null;
        }
        this.size = 0;
    }

    private void checkRange(int n) throws IndexOutOfBoundsException {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
    }
}

