/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.algorithm;

import com.topologi.diffx.algorithm.DiffXAlgorithmBase;
import com.topologi.diffx.format.DiffXFormatter;
import com.topologi.diffx.sequence.EventSequence;
import java.io.IOException;

public final class DiffXKumarRangan
extends DiffXAlgorithmBase {
    private static final boolean DEBUG = false;
    private int[] R1;
    private int[] R2;
    private int[] LL;
    private int[] LL1;
    private int[] LL2;
    private int R;
    private int S;
    private int iSeq2 = 0;
    private int length = -1;
    private DiffXFormatter df = null;

    public DiffXKumarRangan(EventSequence eventSequence, EventSequence eventSequence2) {
        super(eventSequence, eventSequence2);
    }

    public int length() {
        if (this.length < 0) {
            this.length = this.calculateLength();
        }
        return this.length;
    }

    public void process(DiffXFormatter diffXFormatter) throws IOException {
        this.length = this.calculateLength();
        this.df = diffXFormatter;
        this.generateLCS(0, this.length1 - 1, 0, this.length2 - 1, this.length1, this.length2, this.length);
    }

    private void init() {
        this.R1 = new int[this.length2 + 1];
        this.R2 = new int[this.length2 + 1];
        this.LL = new int[this.length2 + 1];
        this.LL1 = new int[this.length2 + 1];
        this.LL2 = new int[this.length2 + 1];
        this.iSeq2 = 0;
    }

    private int calculateLength() {
        this.init();
        this.R = 0;
        this.S = this.length1 + 1;
        while (this.S > this.R) {
            --this.S;
            this.fillOne(0, this.length1 - 1, 0, this.length2 - 1, this.length1, this.length2, 1);
            DiffXKumarRangan.copyUpTo(this.R2, this.R1, this.R);
        }
        return this.S;
    }

    private void fillOne(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = 1;
        int n9 = this.S;
        boolean bl = false;
        this.R2[0] = n6 + 1;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n9 > 0 & !bl) {
            n10 = n8 > this.R ? 0 : this.R1[n8];
            for (n11 = this.R2[n8 - 1] - 1; n11 > n10 && !this.sequence1.getEvent((n9 - 1) * n7 + n).equals(this.sequence2.getEvent((n11 - 1) * n7 + n3)); --n11) {
            }
            n12 = Math.max(n11, n10);
            if (n12 == 0) {
                bl = true;
                continue;
            }
            this.R2[n8] = n12;
            --n9;
            ++n8;
        }
        this.R = n8 - 1;
    }

    private int[] calMid(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.LL = new int[n6 + 1];
        this.R = 0;
        this.S = n5;
        while (this.S >= n5 - n8) {
            this.fillOne(n, n2, n3, n4, n5, n6, n7);
            DiffXKumarRangan.copyUpTo(this.R2, this.R1, this.R);
            --this.S;
        }
        DiffXKumarRangan.copyUpTo(this.R1, this.LL, this.R);
        return this.LL;
    }

    private void generateLCS(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws IOException {
        if (n5 - n7 < 2) {
            this.getLCSMinimumWaste(n, n2, n3, n4, n5, n6, n7);
        } else {
            this.getLCSMoreWaste(n, n2, n3, n4, n5, n6, n7);
        }
    }

    private void getLCSMinimumWaste(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws IOException {
        int n8 = n5 - n7;
        this.LL = this.calMid(n, n2, n3, n4, n5, n6, 1, n8);
        int n9 = 0;
        while (n9 < n7 && this.sequence1.getEvent(n9 + n).equals(this.sequence2.getEvent(this.LL[n7 - n9] - 1 + n3))) {
            this.df.format(this.sequence1.getEvent(n9 + n));
            ++this.iSeq2;
            if (++n9 >= n7) continue;
            this.writeDeleted(this.LL[n7 - n9] - 1 + n3);
        }
        if (n9 < n5) {
            this.df.insert(this.sequence1.getEvent(n9 + n));
        }
        if (n9 < n7) {
            this.writeDeleted(this.LL[n7 - n9] - 1 + n3);
        }
        ++n9;
        while (n9 < n5) {
            this.df.format(this.sequence1.getEvent(n9 + n));
            ++this.iSeq2;
            this.writeDeleted(this.LL[n5 - n9] - 1 + n3);
            ++n9;
        }
        this.writeDeleted(this.LL[0] - 1 + n3);
    }

    private void getLCSMoreWaste(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws IOException {
        int n8;
        int n9;
        int n10 = (int)Math.ceil((float)(n5 - n7) / 2.0f);
        this.LL1 = this.calMid(n2, n, n4, n3, n5, n6, -1, n10);
        int n11 = this.R;
        for (n9 = 0; n9 <= n11; ++n9) {
            this.LL1[n9] = n6 + 1 - this.LL1[n9];
        }
        n9 = (int)Math.floor((float)(n5 - n7) / 2.0f);
        this.LL2 = this.calMid(n, n2, n3, n4, n5, n6, 1, n9);
        int n12 = this.R;
        for (n8 = Math.max(n11, n12); n8 > 0 && (n8 > n11 || n7 - n8 > n12 || this.LL1[n8] >= this.LL2[n7 - n8]); --n8) {
        }
        int n13 = n8 + n10;
        int n14 = this.LL1[n8];
        this.generateLCS(n, n + n13 - 1, n3, n3 + n14 - 1, n13 - 1 + 1, n14 - 1 + 1, n13 - n10);
        this.generateLCS(n + n13, n2, n3 + n14, n4, n2 - n + 1 - n13, n4 - n3 + 1 - n14, n5 - n13 - n9);
    }

    private void writeDeleted(int n) throws IOException {
        while (n > this.iSeq2) {
            this.df.delete(this.sequence2.getEvent(this.iSeq2++));
        }
    }

    private void printState(int n) {
        int n2;
        if ((n & 1) == 1) {
            System.err.println("  R=" + this.R);
        }
        if ((n & 0x10) == 16) {
            System.err.println("  S=" + this.S);
        }
        if ((n & 0x11) > 0) {
            System.err.println();
        }
        if ((n & 0x100) == 256) {
            System.err.print(" R1={");
            for (n2 = 0; n2 < this.R1.length; ++n2) {
                System.err.print(" " + this.R1[n2]);
            }
            System.err.println(" }");
        }
        if ((n & 0x1000) == 4096) {
            System.err.print(" R2={");
            for (n2 = 0; n2 < this.R2.length; ++n2) {
                System.err.print(" " + this.R2[n2]);
            }
            System.err.println(" }");
        }
        if ((n & 0x10000) == 65536) {
            System.err.print(" LL={");
            for (n2 = 0; n2 < this.LL.length; ++n2) {
                System.err.print(" " + this.LL[n2]);
            }
            System.err.println(" }");
        }
        if ((n & 0x100000) == 0x100000) {
            System.err.print(" LL1={");
            for (n2 = 0; n2 < this.LL1.length; ++n2) {
                System.err.print(" " + this.LL1[n2]);
            }
            System.err.println(" }");
        }
        if ((n & 0x1000000) == 0x1000000) {
            System.err.print(" LL2={");
            for (n2 = 0; n2 < this.LL2.length; ++n2) {
                System.err.print(" " + this.LL2[n2]);
            }
            System.err.println(" }");
        }
    }

    private static void copyUpTo(int[] nArray, int[] nArray2, int n) {
        for (int i = 0; i <= n; ++i) {
            nArray2[i] = nArray[i];
        }
    }
}

