/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx;

import com.topologi.diffx.DiffXException;
import com.topologi.diffx.algorithm.DiffXFitopsy;
import com.topologi.diffx.config.DiffXConfig;
import com.topologi.diffx.format.SmartXMLFormatter;
import com.topologi.diffx.load.DOMRecorder;
import com.topologi.diffx.load.SAXRecorder;
import com.topologi.diffx.sequence.EventSequence;
import com.topologi.diffx.sequence.SequenceSlicer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public final class Main {
    private Main() {
    }

    public static boolean equivalent(File file, File file2) throws DiffXException, IOException {
        SAXRecorder sAXRecorder = new SAXRecorder();
        EventSequence eventSequence = sAXRecorder.process(file);
        EventSequence eventSequence2 = sAXRecorder.process(file2);
        return eventSequence.equals(eventSequence2);
    }

    public static boolean equivalent(InputStream inputStream, InputStream inputStream2) throws DiffXException, IOException {
        SAXRecorder sAXRecorder = new SAXRecorder();
        EventSequence eventSequence = sAXRecorder.process(new InputSource(inputStream));
        EventSequence eventSequence2 = sAXRecorder.process(new InputSource(inputStream2));
        return eventSequence.equals(eventSequence2);
    }

    public static boolean equivalent(Reader reader, Reader reader2) throws DiffXException, IOException {
        SAXRecorder sAXRecorder = new SAXRecorder();
        EventSequence eventSequence = sAXRecorder.process(new InputSource(reader));
        EventSequence eventSequence2 = sAXRecorder.process(new InputSource(reader2));
        return eventSequence.equals(eventSequence2);
    }

    public static void diff(Node node, Node node2, Writer writer, DiffXConfig diffXConfig) throws DiffXException, IOException {
        DOMRecorder dOMRecorder = new DOMRecorder();
        if (diffXConfig != null) {
            dOMRecorder.setConfig(diffXConfig);
        }
        EventSequence eventSequence = dOMRecorder.process(node);
        EventSequence eventSequence2 = dOMRecorder.process(node2);
        Main.diff(eventSequence, eventSequence2, writer, diffXConfig);
    }

    public static void diff(Reader reader, Reader reader2, Writer writer, DiffXConfig diffXConfig) throws DiffXException, IOException {
        SAXRecorder sAXRecorder = new SAXRecorder();
        if (diffXConfig != null) {
            sAXRecorder.setConfig(diffXConfig);
        }
        EventSequence eventSequence = sAXRecorder.process(new InputSource(reader));
        EventSequence eventSequence2 = sAXRecorder.process(new InputSource(reader2));
        Main.diff(eventSequence, eventSequence2, writer, diffXConfig);
    }

    public static void diff(Reader reader, Reader reader2, Writer writer) throws DiffXException, IOException {
        SAXRecorder sAXRecorder = new SAXRecorder();
        EventSequence eventSequence = sAXRecorder.process(new InputSource(reader));
        EventSequence eventSequence2 = sAXRecorder.process(new InputSource(reader2));
        Main.diff(eventSequence, eventSequence2, writer, new DiffXConfig());
    }

    public static void diff(InputStream inputStream, InputStream inputStream2, OutputStream outputStream) throws DiffXException, IOException {
        SAXRecorder sAXRecorder = new SAXRecorder();
        EventSequence eventSequence = sAXRecorder.process(new InputSource(inputStream));
        EventSequence eventSequence2 = sAXRecorder.process(new InputSource(inputStream2));
        Main.diff(eventSequence, eventSequence2, (Writer)new OutputStreamWriter(outputStream), new DiffXConfig());
    }

    public static void diff(String string, String string2, OutputStream outputStream, DiffXConfig diffXConfig) throws DiffXException, IOException {
        SAXRecorder sAXRecorder = new SAXRecorder();
        sAXRecorder.setConfig(diffXConfig);
        EventSequence eventSequence = sAXRecorder.process(new InputSource(string));
        EventSequence eventSequence2 = sAXRecorder.process(new InputSource(string2));
        Main.diff(eventSequence, eventSequence2, (Writer)new OutputStreamWriter(outputStream), new DiffXConfig());
    }

    private static void diff(EventSequence eventSequence, EventSequence eventSequence2, Writer writer, DiffXConfig diffXConfig) throws DiffXException, IOException {
        SmartXMLFormatter smartXMLFormatter = new SmartXMLFormatter(writer);
        smartXMLFormatter.declarePrefixMapping(eventSequence.getPrefixMapping());
        smartXMLFormatter.declarePrefixMapping(eventSequence2.getPrefixMapping());
        if (diffXConfig != null) {
            smartXMLFormatter.setConfig(diffXConfig);
        }
        SequenceSlicer sequenceSlicer = new SequenceSlicer(eventSequence, eventSequence2);
        sequenceSlicer.slice();
        sequenceSlicer.formatStart(smartXMLFormatter);
        DiffXFitopsy diffXFitopsy = new DiffXFitopsy(eventSequence, eventSequence2);
        diffXFitopsy.process(smartXMLFormatter);
        sequenceSlicer.formatEnd(smartXMLFormatter);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            Main.usage();
        }
        try {
            File file = new File(stringArray[0]);
            File file2 = new File(stringArray[1]);
            Main.diff(new FileInputStream(file), new FileInputStream(file2), System.out);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void usage() {
        System.err.println("Compare the SAX events returned by two XML files.");
        System.err.println("usage:");
        System.err.println("  Main [xml_file] [xml_file]");
        System.err.println("where:");
        System.err.println("  xml_file = Path to an XML file");
        System.exit(1);
    }
}

