/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.xslt;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import net.sf.saxon.expr.XPathContext;
import org.cdlib.xtf.util.CharMap;
import org.cdlib.xtf.xslt.FileUtils;

public class CharUtils {
    private static HashMap<String, CharMap> accentMapCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CharMap getAccentMap(XPathContext context, String filePath) throws IOException {
        HashMap<String, CharMap> hashMap = accentMapCache;
        synchronized (hashMap) {
            String fullPath = FileUtils.resolvePath(context, filePath);
            File file = new File(fullPath);
            if (!file.canRead()) {
                throw new IOException("Error reading accent map file '" + fullPath + "'");
            }
            String key = String.valueOf(fullPath) + "|" + file.lastModified();
            if (accentMapCache.containsKey(key)) {
                return accentMapCache.get(key);
            }
            InputStream stream = new FileInputStream(file);
            if (fullPath.endsWith(".gz")) {
                stream = new GZIPInputStream(stream);
            }
            CharMap map = new CharMap(stream);
            accentMapCache.put(key, map);
            return map;
        }
    }

    public static String applyAccentMap(XPathContext context, String filePath, String str) throws IOException {
        CharMap accentMap = CharUtils.getAccentMap(context, filePath);
        StringBuilder buf = new StringBuilder();
        String[] stringArray = str.split("\\s");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (word.length() != 0) {
                String mappedWord = accentMap.mapWord(word);
                if (mappedWord != null) {
                    word = mappedWord;
                }
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append(word);
            }
            ++n2;
        }
        return buf.toString();
    }
}

