/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Timer;
import java.util.TimerTask;
import org.cdlib.xtf.util.Trace;

public class ProcessRunner {
    public static String runAndGrab(String[] argArray, String input, int timeout) throws InterruptedException, CommandFailedException, IOException {
        Charset charset = Charset.defaultCharset();
        ByteBuffer inBuf = charset.encode(input);
        inBuf.compact();
        byte[] inBytes = inBuf.array();
        byte[] outBytes = ProcessRunner.runAndGrab(argArray, inBytes, timeout);
        CharBuffer outBuf = charset.decode(ByteBuffer.wrap(outBytes));
        String output = outBuf.toString();
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] runAndGrab(String[] argArray, byte[] inputBytes, int timeout) throws InterruptedException, CommandFailedException, IOException {
        block74: {
            block73: {
                var6_3 = argArray;
                var5_5 = argArray.length;
                var4_7 = 0;
                while (var4_7 < var5_5) {
                    arg = var6_3[var4_7];
                    if (!ProcessRunner.$assertionsDisabled) {
                        if (arg == null) throw new AssertionError();
                        if (arg.length() <= 0) {
                            throw new AssertionError();
                        }
                    }
                    ++var4_7;
                }
                if (Trace.getOutputLevel() >= 8) {
                    buf = new StringBuilder();
                    buf.append("Running command: ");
                    var7_11 = argArray;
                    var6_4 = argArray.length;
                    var5_5 = 0;
                    while (var5_5 < var6_4) {
                        arg = var7_11[var5_5];
                        buf.append(String.valueOf(arg) + " ");
                        ++var5_5;
                    }
                    Trace.debug(buf.toString());
                }
                process = null;
                stdout = null;
                stdoutGrabber = null;
                stderr = null;
                stderrGrabber = null;
                stdin = null;
                stdinStuffer = null;
                timer = null;
                interrupter = null;
                exception = false;
                try {
                    try {
                        process = Runtime.getRuntime().exec(argArray);
                        stdin = process.getOutputStream();
                        stdinStuffer = new InputStuffer(stdin, inputBytes);
                        stdinStuffer.start();
                        stdout = process.getInputStream();
                        stdoutGrabber = new OutputGrabber(stdout);
                        stderr = process.getErrorStream();
                        stderrGrabber = new OutputGrabber(stderr);
                        stdoutGrabber.start();
                        stderrGrabber.start();
                        if (timeout > 0) {
                            interrupter = new Interrupter(Thread.currentThread());
                            timer = new Timer();
                            timer.schedule((TimerTask)interrupter, timeout);
                        }
                        process.waitFor();
                    }
                    catch (IOException e) {
                        exception = true;
                        throw e;
                    }
                    catch (InterruptedException e) {
                        exception = true;
                        throw e;
                    }
                }
                catch (Throwable var14_24) {
                    if (interrupter != null) {
                        var15_25 = interrupter;
                        synchronized (var15_25) {
                            timer.cancel();
                            interrupter.mainThread = null;
                            Thread.interrupted();
                        }
                    }
                    if (exception == false) throw var14_24;
                    if (stdinStuffer != null) {
                        stdinStuffer.interrupt();
                    }
                    if (stdoutGrabber != null) {
                        stdoutGrabber.interrupt();
                    }
                    if (stderrGrabber != null) {
                        stderrGrabber.interrupt();
                    }
                    if (process != null) {
                        process.destroy();
                    }
                    if (stdin != null) {
                        try {
                            stdin.close();
                        }
                        catch (IOException var15_26) {
                            // empty catch block
                        }
                    }
                    if (stdout != null) {
                        try {
                            stdout.close();
                        }
                        catch (IOException var15_27) {
                            // empty catch block
                        }
                    }
                    if (stderr == null) throw var14_24;
                    try {
                        stderr.close();
                        throw var14_24;
                    }
                    catch (IOException var15_28) {
                        // empty catch block
                    }
                    throw var14_24;
                }
                if (interrupter != null) {
                    var15_29 = interrupter;
                    synchronized (var15_29) {
                        timer.cancel();
                        interrupter.mainThread = null;
                        Thread.interrupted();
                    }
                }
                if (exception) {
                    if (stdinStuffer != null) {
                        stdinStuffer.interrupt();
                    }
                    if (stdoutGrabber != null) {
                        stdoutGrabber.interrupt();
                    }
                    if (stderrGrabber != null) {
                        stderrGrabber.interrupt();
                    }
                    if (process != null) {
                        process.destroy();
                    }
                    if (stdin != null) {
                        try {
                            stdin.close();
                        }
                        catch (IOException var15_30) {
                            // empty catch block
                        }
                    }
                    if (stdout != null) {
                        try {
                            stdout.close();
                        }
                        catch (IOException var15_31) {
                            // empty catch block
                        }
                    }
                    if (stderr != null) {
                        try {
                            stderr.close();
                        }
                        catch (IOException var15_32) {
                            // empty catch block
                        }
                    }
                }
                try {
                    if (stdinStuffer == null) break block73;
                    while (true) lbl-1000:
                    // 2 sources

                    {
                        e = stdinStuffer;
                        synchronized (e) {
                            if (stdinStuffer.done) {
                                break block73;
                            }
                            stdinStuffer.wait();
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    if (!ProcessRunner.$assertionsDisabled) {
                        throw new AssertionError((Object)"should not be interrupted at this stage");
                    }
                    break block74;
                }
                {
                    ** while (true)
                }
            }
            while (true) {
                e = stdoutGrabber;
                synchronized (e) {
                    if (stdoutGrabber.done) {
                        break;
                    }
                    stdoutGrabber.wait();
                }
            }
            while (true) {
                e = stderrGrabber;
                synchronized (e) {
                    if (stderrGrabber.done) {
                        break;
                    }
                    stderrGrabber.wait();
                }
            }
        }
        if (stdin != null) {
            try {
                stdin.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (stdout != null) {
            try {
                stdout.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (stderr != null) {
            try {
                stderr.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (process.exitValue() == 0) return stdoutGrabber.outBytes;
        errStr = new String(stderrGrabber.outBytes);
        throw new CommandFailedException("External command '" + argArray[0] + "' exited with status " + process.exitValue() + ". Output from stderr:\n" + errStr);
    }

    public static class CommandFailedException
    extends Exception {
        public CommandFailedException() {
        }

        public CommandFailedException(String s) {
            super(s);
        }
    }

    private static class InputStuffer
    extends Thread {
        private OutputStream outStream;
        private byte[] bytes;
        public Throwable error;
        public boolean done = false;

        public InputStuffer(OutputStream stream, byte[] bytes) throws UnsupportedEncodingException {
            this.outStream = stream;
            this.bytes = bytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block14: {
                try {
                    try {
                        this.outStream.write(this.bytes);
                        this.outStream.close();
                    }
                    catch (IOException e) {
                        this.error = e;
                        InputStuffer inputStuffer = this;
                        synchronized (inputStuffer) {
                            this.done = true;
                            this.notifyAll();
                            break block14;
                        }
                    }
                }
                catch (Throwable throwable) {
                    InputStuffer inputStuffer = this;
                    synchronized (inputStuffer) {
                        this.done = true;
                        this.notifyAll();
                    }
                    throw throwable;
                }
                InputStuffer inputStuffer = this;
                synchronized (inputStuffer) {
                    this.done = true;
                    this.notifyAll();
                }
            }
        }
    }

    private static class Interrupter
    extends TimerTask {
        public Thread mainThread;

        public Interrupter(Thread mainThread) {
            this.mainThread = mainThread;
        }

        public synchronized void run() {
            if (this.mainThread != null) {
                this.mainThread.interrupt();
            }
        }
    }

    private static class OutputGrabber
    extends Thread {
        private InputStream inStream;
        private ByteArrayOutputStream buffer = new ByteArrayOutputStream(100);
        public byte[] outBytes = new byte[0];
        public Throwable error;
        public boolean done = false;

        public OutputGrabber(InputStream stream) {
            this.inStream = stream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block17: {
                try {
                    try {
                        int got;
                        byte[] tmp = new byte[4096];
                        while ((got = this.inStream.read(tmp)) >= 0) {
                            this.buffer.write(tmp, 0, got);
                            if (Trace.getOutputLevel() < 8) continue;
                            try {
                                Trace.more(8, new String(tmp, 0, got));
                            }
                            catch (Throwable throwable) {}
                        }
                        this.outBytes = this.buffer.toByteArray();
                    }
                    catch (IOException e) {
                        this.error = e;
                        OutputGrabber outputGrabber = this;
                        synchronized (outputGrabber) {
                            this.done = true;
                            this.notifyAll();
                            break block17;
                        }
                    }
                }
                catch (Throwable throwable) {
                    OutputGrabber outputGrabber = this;
                    synchronized (outputGrabber) {
                        this.done = true;
                        this.notifyAll();
                    }
                    throw throwable;
                }
                OutputGrabber outputGrabber = this;
                synchronized (outputGrabber) {
                    this.done = true;
                    this.notifyAll();
                }
            }
        }
    }
}

