/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.cdlib.xtf.textEngine.IndexValidator;
import org.cdlib.xtf.textEngine.NativeFSDirectory;
import org.cdlib.xtf.textIndexer.IdxTreeCleaner;
import org.cdlib.xtf.textIndexer.IdxTreeCuller;
import org.cdlib.xtf.textIndexer.IdxTreeDictMaker;
import org.cdlib.xtf.textIndexer.IdxTreeOptimizer;
import org.cdlib.xtf.textIndexer.IndexInfo;
import org.cdlib.xtf.textIndexer.IndexSync;
import org.cdlib.xtf.textIndexer.IndexerConfig;
import org.cdlib.xtf.textIndexer.SrcTreeProcessor;
import org.cdlib.xtf.textIndexer.XMLConfigParser;
import org.cdlib.xtf.util.DirSync;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.util.SubDirFilter;
import org.cdlib.xtf.util.Trace;

public class TextIndexer {
    public static final String SHOW_VERSION = "3.1";
    public static final String CURRENT_VERSION = "3.1";
    public static final String REQUIRED_VERSION = "2.2b";

    public static void main(String[] args) {
        try {
            String ending;
            File idxRootDir;
            IndexerConfig cfgInfo = new IndexerConfig();
            XMLConfigParser cfgParser = new XMLConfigParser();
            IdxTreeCleaner indexCleaner = new IdxTreeCleaner();
            int startArg = 0;
            boolean showUsage = false;
            boolean firstIndex = true;
            long startTime = System.currentTimeMillis();
            Trace.info("TextIndexer v3.1");
            Trace.info("");
            Trace.tab();
            cfgInfo.xtfHomePath = System.getProperty("xtf.home");
            if (cfgInfo.xtfHomePath == null || cfgInfo.xtfHomePath.length() == 0) {
                Trace.error("Error: xtf.home property not found");
                System.exit(1);
            }
            cfgInfo.xtfHomePath = Path.normalizePath(cfgInfo.xtfHomePath);
            if (!new File(cfgInfo.xtfHomePath).isDirectory()) {
                Trace.error("Error: xtf.home directory \"" + cfgInfo.xtfHomePath + "\" does not exist or cannot be read.");
                System.exit(1);
            }
            File xtfHomeFile = new File(cfgInfo.xtfHomePath);
            while (true) {
                if (args.length < 2) {
                    showUsage = true;
                } else {
                    int ret = cfgInfo.readCmdLine(args, startArg);
                    if (ret == -1) {
                        if (startArg != 0) break;
                        showUsage = true;
                    } else {
                        if (!new File(cfgInfo.cfgFilePath).isAbsolute()) {
                            cfgInfo.cfgFilePath = Path.resolveRelOrAbs(cfgInfo.xtfHomePath, cfgInfo.cfgFilePath);
                        }
                        if (cfgParser.configure(cfgInfo) < 0) {
                            Trace.error("Error: index '" + cfgInfo.indexInfo.indexName + "' not found\n");
                            System.exit(1);
                        }
                        cfgInfo.mustClean = cfgInfo.clean;
                        Trace.setOutputLevel(cfgInfo.traceLevel);
                    }
                    startArg = ret;
                }
                if (showUsage) {
                    Trace.error("Usage: textIndexer {options} -index indexname");
                    Trace.error("Basic options:");
                    Trace.tab();
                    Trace.error("-config <configfile>                  Default: -config textIndexer.conf");
                    Trace.error("-incremental|-clean|-force            Default: -incremental");
                    Trace.error("-dir <subdir1> -dir <subdir2>...      Default: (all directories)");
                    Trace.error("-dirlist <fileOfSubdirs>              Default: (all directories)");
                    Trace.error("\n");
                    Trace.untab();
                    Trace.error("Advanced options:");
                    Trace.error("-nosync|-syncfrom <otherIndexDir>     Default: -nosync");
                    Trace.error("-optimize|-nooptimize                 Default: -optimize");
                    Trace.error("-trace errors|warnings|info|debug     Default: -trace info");
                    Trace.error("-buildlazy|-nobuildlazy               Default: -buildlazy");
                    Trace.error("-updatespell|-noupdatespell           Default: -updatespell");
                    Trace.error("-rotate|-norotate                     Default: -rotate");
                    Trace.error("-validate|-novalidate                 Default: -validate");
                    Trace.tab();
                    Trace.error("\n");
                    Trace.untab();
                    System.exit(1);
                }
                if (cfgInfo.indexInfo.rotate) {
                    cfgInfo.indexInfo.indexPath = cfgInfo.indexInfo.indexPath.replaceFirst("/$", "-new/");
                }
                File idxRoot = new File(Path.resolveRelOrAbs(xtfHomeFile, cfgInfo.indexInfo.indexPath));
                if (firstIndex) {
                    if (!cfgInfo.mustClean) {
                        Trace.info("");
                        Trace.info("Purging Incomplete Documents From Indexes:");
                        Trace.tab();
                        indexCleaner.processDir(idxRoot);
                        Trace.untab();
                        Trace.info("Done.");
                    }
                    Trace.info("");
                    Trace.info("Indexing New/Updated Documents:");
                    Trace.tab();
                    firstIndex = false;
                }
                Trace.info("Index: \"" + cfgInfo.indexInfo.indexName + "\"");
                if (Trace.getOutputLevel() == 8) {
                    Trace.more(" [ Chunk Size = " + cfgInfo.indexInfo.getChunkSize() + ", Overlap = " + cfgInfo.indexInfo.getChunkOvlp() + " ]");
                }
                Trace.tab();
                if (!cfgInfo.skipIndexing) {
                    TextIndexer.doIndexing(cfgInfo, xtfHomeFile);
                }
                Trace.untab();
                Trace.info("Done.");
            }
            Trace.untab();
            Trace.info("Done.");
            if (cfgInfo.optimize) {
                IdxTreeOptimizer optimizer = new IdxTreeOptimizer();
                Trace.info("");
                Trace.info("Optimizing Index:");
                Trace.tab();
                idxRootDir = new File(Path.resolveRelOrAbs(cfgInfo.xtfHomePath, cfgInfo.indexInfo.indexPath));
                optimizer.processDir(idxRootDir);
                Trace.untab();
                Trace.info("Done.");
            } else {
                Trace.info("");
                Trace.info("Skipping Optimization Pass.");
            }
            if (cfgInfo.updateSpellDict && cfgInfo.indexInfo.createSpellcheckDict) {
                IdxTreeDictMaker dictMaker = new IdxTreeDictMaker();
                Trace.info("");
                Trace.info("Updating Spellcheck Dictionary:");
                Trace.tab();
                idxRootDir = new File(Path.resolveRelOrAbs(cfgInfo.xtfHomePath, cfgInfo.indexInfo.indexPath));
                dictMaker.processDir(idxRootDir);
                Trace.untab();
                Trace.info("Done.");
            } else {
                Trace.info("");
                Trace.info("Skipping Spellcheck Dictionary Pass.");
            }
            if (cfgInfo.indexInfo.validationPath != null && cfgInfo.indexInfo.validationPath.length() > 0) {
                Trace.info("");
                if (cfgInfo.validate) {
                    TextIndexer.doValidation(cfgInfo);
                } else {
                    Trace.info("Skipping Index Validation.");
                }
            }
            if (cfgInfo.indexInfo.rotate) {
                if (cfgInfo.rotate) {
                    Trace.info("");
                    Trace.info("Performing Index Rotation:");
                    Trace.tab();
                    TextIndexer.doRotation(cfgInfo);
                    Trace.untab();
                    Trace.info("Done.");
                } else {
                    Trace.info("");
                    Trace.info("Skipping Index Rotation Pass.");
                }
            }
            Trace.untab();
            Trace.info("");
            long timeMsec = System.currentTimeMillis() - startTime;
            long timeSec = (timeMsec + 500L) / 1000L;
            long timeMin = timeSec / 60L;
            long timeHour = timeMin / 60L;
            Trace.info("Total time: ");
            if (timeHour > 0L) {
                ending = timeHour == 1L ? "" : "s";
                Trace.more(4, String.valueOf(timeHour) + " hour" + ending + ", ");
            }
            if (timeMin > 0L) {
                ending = timeMin % 60L == 1L ? "" : "s";
                Trace.more(4, String.valueOf(timeMin % 60L) + " minute" + ending + ", ");
            }
            ending = timeSec % 60L == 1L ? "" : "s";
            Trace.more(4, String.valueOf(timeSec % 60L) + " second" + ending + ".");
            Trace.info("Indexing complete.");
            Trace.info("");
        }
        catch (Throwable t) {
            Trace.clearTabs();
            Trace.error("*** Error: " + t.getClass());
            Trace.error("");
            t.printStackTrace(System.out);
            Trace.error("Indexing Process Aborted.");
            System.exit(1);
        }
    }

    private static void doIndexing(IndexerConfig cfgInfo, File xtfHomeFile) throws Exception {
        SrcTreeProcessor srcTreeProcessor = new SrcTreeProcessor();
        srcTreeProcessor.open(cfgInfo);
        String srcRoot = Path.resolveRelOrAbs(xtfHomeFile, cfgInfo.indexInfo.sourcePath);
        File srcRootFile = new File(srcRoot);
        String indexPath = Path.resolveRelOrAbs(cfgInfo.xtfHomePath, cfgInfo.indexInfo.indexPath);
        File indexFile = new File(indexPath);
        TextIndexer.writeScanDirs(indexFile, cfgInfo.indexInfo);
        SubDirFilter subDirFilter = TextIndexer.makeSubDirFilter(srcRootFile, cfgInfo);
        if (cfgInfo.indexInfo.cloneData) {
            Trace.info("Cloning Data Directories.");
            File cloneRootFile = new File(indexFile, "dataClone/" + cfgInfo.indexInfo.indexName);
            if (!cloneRootFile.exists() && !cloneRootFile.mkdirs()) {
                throw new IOException("Error creating clone directory '" + cloneRootFile + "'");
            }
            DirSync sync = new DirSync(subDirFilter);
            sync.syncDirs(srcRootFile, cloneRootFile);
            subDirFilter = TextIndexer.makeSubDirFilter(cloneRootFile, cfgInfo);
            srcRootFile = cloneRootFile;
            Trace.more(4, " Done.");
        }
        Trace.info("Scanning Data Directories...");
        srcTreeProcessor.processDir(srcRootFile, subDirFilter, true);
        Trace.more(4, " Done.");
        srcTreeProcessor.close();
        IdxTreeCuller culler = new IdxTreeCuller();
        Trace.info("Removing Missing Documents From Index:");
        Trace.tab();
        culler.cullIndex(new File(cfgInfo.xtfHomePath), cfgInfo.indexInfo, srcRootFile, subDirFilter);
        Trace.untab();
        Trace.info("Done.");
    }

    private static void writeScanDirs(File indexFile, IndexInfo idxInfo) throws IOException {
        File oldScanFile = new File(indexFile, "scanDirs.list");
        File newScanFile = new File(indexFile, "scanDirs.list.new");
        try {
            BufferedWriter scanWriter = new BufferedWriter(new FileWriter(newScanFile));
            if (oldScanFile.canRead()) {
                String line;
                BufferedReader scanReader = new BufferedReader(new FileReader(oldScanFile));
                while ((line = scanReader.readLine()) != null) {
                    scanWriter.write(String.valueOf(line) + "\n");
                }
                scanReader.close();
            }
            if (idxInfo.subDirs == null) {
                scanWriter.write(String.valueOf(idxInfo.indexName) + ":/\n");
            } else {
                for (String subdir : idxInfo.subDirs) {
                    scanWriter.write(String.valueOf(idxInfo.indexName) + ":" + subdir + "\n");
                }
            }
            scanWriter.close();
            newScanFile.renameTo(oldScanFile);
        }
        catch (IOException e) {
            newScanFile.delete();
            throw e;
        }
    }

    private static SubDirFilter makeSubDirFilter(File srcRootFile, IndexerConfig cfgInfo) {
        if (cfgInfo.indexInfo.subDirs == null) {
            return null;
        }
        SubDirFilter filter = new SubDirFilter();
        for (String subdir : cfgInfo.indexInfo.subDirs) {
            filter.add(new File(Path.normalizePath(String.valueOf(srcRootFile.toString()) + "/" + subdir)));
        }
        return filter;
    }

    private static void doRotation(IndexerConfig cfgInfo) throws IOException {
        String indexPath = cfgInfo.indexInfo.indexPath;
        assert (indexPath.endsWith("-new/"));
        String home = cfgInfo.xtfHomePath;
        File newIndex = new File(Path.resolveRelOrAbs(home, indexPath));
        File currentIndex = new File(Path.resolveRelOrAbs(home, indexPath.replaceFirst("-new/$", "/")));
        File pendingIndex = new File(Path.resolveRelOrAbs(home, indexPath.replaceFirst("-new/$", "-pending/")));
        File spareIndex = new File(Path.resolveRelOrAbs(home, indexPath.replaceFirst("-new/$", "-spare/")));
        if (currentIndex.exists() && IndexSync.newestTime(currentIndex).equals(IndexSync.newestTime(newIndex))) {
            Trace.info("Nothing has changed, so not rotating.");
            return;
        }
        if (pendingIndex.exists() && IndexSync.newestTime(pendingIndex).equals(IndexSync.newestTime(newIndex))) {
            Trace.info("Nothing has changed, so not rotating.");
            return;
        }
        if (pendingIndex.exists()) {
            Trace.info("A previous index is still pending, so not rotating.");
            return;
        }
        if (!spareIndex.exists()) {
            Trace.info("Creating spare index clone.");
            if (!spareIndex.mkdir()) {
                throw new IOException("Error creating spare index '" + spareIndex + "'");
            }
            new DirSync().syncDirs(newIndex, spareIndex);
            Trace.more(4, " Done.");
        } else {
            Trace.info("Bringing spare index clone up to date:");
            Trace.tab();
            new IndexSync().syncDirs(cfgInfo.indexInfo.indexName, newIndex, spareIndex);
            Trace.untab();
            Trace.info("Done.");
        }
        Trace.info("Rotating Indexes:  [pending]  <-  [new]  <-  [spare]");
        TextIndexer.renameOrElse(newIndex, pendingIndex);
        TextIndexer.renameOrElse(spareIndex, newIndex);
    }

    private static void doValidation(IndexerConfig cfgInfo) throws IOException {
        IndexReader reader;
        IndexValidator validator = new IndexValidator();
        String indexPath = Path.resolveRelOrAbs(cfgInfo.xtfHomePath, cfgInfo.indexInfo.indexPath);
        if (validator.validate(cfgInfo.xtfHomePath, indexPath, reader = IndexReader.open(NativeFSDirectory.getDirectory(Path.normalizePath(indexPath))))) {
            return;
        }
        Trace.untab();
        Trace.error("Indexing aborted.");
        Trace.error("");
        System.exit(1);
    }

    private static void renameOrElse(File from, File to) throws IOException {
        if (!from.renameTo(to)) {
            throw new IOException("Error renaming '" + from + "' to '" + to + "'");
        }
    }
}

