/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.cdlib.xtf.util.DirSync;
import org.cdlib.xtf.util.SubDirFilter;
import org.cdlib.xtf.util.Trace;

public class IndexSync {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S Z");

    public void syncDirs(String indexName, File srcDir, File dstDir) throws IOException {
        SubDirFilter filter = this.calcFilter(indexName, srcDir, dstDir);
        DirSync dirSync = new DirSync(filter);
        dirSync.syncDirs(srcDir, dstDir);
    }

    private SubDirFilter calcFilter(String indexName, File srcDir, File dstDir) throws IOException {
        SubDirFilter filter = new SubDirFilter();
        String srcTime = IndexSync.oldestTime(srcDir);
        String dstTime = IndexSync.oldestTime(dstDir);
        File srcScanFile = new File(srcDir, "scanDirs.list");
        File dstScanFile = new File(dstDir, "scanDirs.list");
        if (srcTime.equals(dstTime) && srcScanFile.canRead() && dstScanFile.canRead()) {
            String dstKey;
            File srcLazyDir = null;
            File srcCloneDir = null;
            File[] fileArray = srcDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    if (f.getName().equals("lazy")) {
                        srcLazyDir = f;
                    } else if (f.getName().equals("dataClone")) {
                        srcCloneDir = f;
                    } else {
                        filter.add(f);
                    }
                }
                ++n2;
            }
            BufferedReader srcScanReader = new BufferedReader(new FileReader(srcScanFile));
            BufferedReader dstScanReader = new BufferedReader(new FileReader(dstScanFile));
            boolean allMatch = true;
            while ((dstKey = dstScanReader.readLine()) != null) {
                String srcKey = srcScanReader.readLine();
                if (dstKey.equals(srcKey)) continue;
                allMatch = false;
            }
            if (allMatch) {
                String srcKey;
                while ((srcKey = srcScanReader.readLine()) != null) {
                    String scanDir = srcKey.replaceFirst(":", "/");
                    if (srcLazyDir != null) {
                        filter.add(new File(srcLazyDir, scanDir));
                    }
                    if (srcCloneDir == null) continue;
                    filter.add(new File(srcCloneDir, scanDir));
                }
            }
        }
        if (filter.isEmpty() || filter.size() > 500) {
            Trace.info("Syncing entire source directory.");
            filter.add(srcDir);
        } else {
            Trace.info("Syncing changed directories only.");
        }
        return filter;
    }

    public static String oldestTime(File dir) {
        long min = Long.MAX_VALUE;
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (!f.getName().equals("scanDirs.list") && f.lastModified() < min) {
                min = f.lastModified();
            }
            ++n2;
        }
        if (min == Long.MAX_VALUE) {
            min = dir.lastModified();
        }
        return dateFormat.format(new Date(min));
    }

    public static String newestTime(File dir) {
        long max = Long.MIN_VALUE;
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (!f.getName().equals("scanDirs.list") && f.lastModified() > max) {
                max = f.lastModified();
            }
            ++n2;
        }
        if (max == Long.MIN_VALUE) {
            max = dir.lastModified();
        }
        return dateFormat.format(new Date(max));
    }
}

