/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.apache.lucene.chunk.DocNumMap;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.cdlib.xtf.textEngine.XtfSearcher;
import org.cdlib.xtf.textIndexer.IndexInfo;
import org.cdlib.xtf.textIndexer.IndexerConfig;
import org.cdlib.xtf.textIndexer.XMLConfigParser;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.util.Trace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexDump {
    public static void main(String[] args) {
        try {
            IndexerConfig cfgInfo = new IndexerConfig();
            XMLConfigParser cfgParser = new XMLConfigParser();
            int startArg = 0;
            boolean showUsage = false;
            boolean termFreqMode = false;
            boolean allFieldsMode = false;
            boolean xmlMode = false;
            cfgInfo.xtfHomePath = System.getProperty("xtf.home");
            if (cfgInfo.xtfHomePath == null || cfgInfo.xtfHomePath.length() == 0) {
                Trace.error("Error: xtf.home property not found");
                return;
            }
            cfgInfo.xtfHomePath = Path.normalizePath(cfgInfo.xtfHomePath);
            if (!new File(cfgInfo.xtfHomePath).isDirectory()) {
                Trace.error("Error: xtf.home directory \"" + cfgInfo.xtfHomePath + "\" does not exist or cannot be read.");
                return;
            }
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)System.out, "UTF-8");
            while (true) {
                if (args.length < 3) {
                    showUsage = true;
                } else {
                    int ret = cfgInfo.readCmdLine(args, startArg);
                    if (ret == -1) {
                        if (startArg != 0) break;
                        showUsage = true;
                    } else {
                        if (!new File(cfgInfo.cfgFilePath).isAbsolute()) {
                            cfgInfo.cfgFilePath = Path.resolveRelOrAbs(cfgInfo.xtfHomePath, cfgInfo.cfgFilePath);
                        }
                        if (cfgParser.configure(cfgInfo) < 0) {
                            Trace.error("Error: index '" + cfgInfo.indexInfo.indexName + "' not found\n");
                            return;
                        }
                    }
                    startArg = ret;
                }
                Vector<String> fieldNames = new Vector<String>();
                while (startArg < args.length) {
                    if (args[startArg].equalsIgnoreCase("-termFreq")) {
                        ++startArg;
                        termFreqMode = true;
                        continue;
                    }
                    if (args[startArg].equalsIgnoreCase("-allFields")) {
                        ++startArg;
                        allFieldsMode = true;
                        continue;
                    }
                    if (args[startArg].equalsIgnoreCase("-xml")) {
                        ++startArg;
                        xmlMode = true;
                        continue;
                    }
                    if (args[startArg].equals("-field")) {
                        if (++startArg == args.length || args[startArg].startsWith("-")) {
                            showUsage = true;
                            continue;
                        }
                        if (args[startArg].equals("text") && !termFreqMode) {
                            Trace.error("Error: contents of the 'text' field cannot be dumped");
                            System.exit(1);
                        }
                        fieldNames.add(args[startArg]);
                        ++startArg;
                        continue;
                    }
                    showUsage = true;
                    break;
                }
                if (allFieldsMode && !fieldNames.isEmpty() || !allFieldsMode && fieldNames.isEmpty()) {
                    showUsage = true;
                }
                String[] fieldNameArray = fieldNames.toArray(new String[fieldNames.size()]);
                if (showUsage) {
                    Trace.error("  usage: ");
                    Trace.tab();
                    Trace.error("indexDump {-config <configfile>} -index <indexname> {-xml} {-termFreq} {-allFields|-field fieldName1 {-field fieldName2}*}... \n\n");
                    Trace.untab();
                    System.exit(1);
                }
                IndexInfo idxInfo = cfgInfo.indexInfo;
                String idxPath = Path.resolveRelOrAbs(cfgInfo.xtfHomePath, idxInfo.indexPath);
                XtfSearcher searcher = new XtfSearcher(idxPath, 30);
                IndexReader indexReader = searcher.indexReader();
                DocNumMap docNumMap = searcher.docNumMap();
                if (termFreqMode) {
                    IndexDump.dumpTermFreqs(indexReader, docNumMap, fieldNameArray, out);
                } else {
                    IndexDump.dumpFields(indexReader, fieldNameArray, xmlMode, allFieldsMode, out);
                }
                indexReader.close();
                ((Writer)out).flush();
            }
        }
        catch (Exception e) {
            Trace.error("*** Last Chance Exception: " + e.getClass());
            Trace.error("             With message: " + e.getMessage());
            Trace.error("");
            e.printStackTrace(System.out);
            System.exit(1);
        }
        catch (Throwable t) {
            Trace.error("*** Last Chance Exception: " + t.getClass());
            Trace.error("             With message: " + t);
            Trace.error("");
            t.printStackTrace(System.out);
            System.exit(1);
        }
        System.exit(0);
    }

    private static void dumpDelimitedRecord(ArrayList<Field> fieldData, Writer out) throws IOException {
        String prevName = null;
        for (Field f : fieldData) {
            if (prevName != null) {
                if (f.name().equals(prevName)) {
                    out.write(";");
                } else {
                    out.write("|");
                }
            }
            prevName = f.name();
            out.write(IndexDump.stripValue(f.stringValue(), true));
        }
        out.write("|\n");
    }

    private static void dumpXmlRecord(ArrayList<Field> fieldData, Writer out) throws IOException {
        out.write("  <document>\n");
        for (Field f : fieldData) {
            out.write("    <" + f.name() + ">");
            out.write(IndexDump.stripValue(f.stringValue(), false));
            out.write("</" + f.name() + ">\n");
        }
        out.write("  </document>\n");
    }

    private static void dumpFields(IndexReader indexReader, String[] fieldNames, boolean xmlMode, boolean allFieldsMode, Writer out) throws IOException {
        if (xmlMode) {
            out.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            out.write("<xtfIndexDocuments>\n");
        }
        Field[] emptyFields = new Field[fieldNames.length];
        int j = 0;
        while (j < fieldNames.length) {
            emptyFields[j] = new Field(fieldNames[j], "", Field.Store.YES, Field.Index.NO);
            ++j;
        }
        int maxDoc = indexReader.maxDoc();
        int i = 0;
        while (i < maxDoc) {
            Document doc;
            if (!indexReader.isDeleted(i) && (doc = indexReader.document(i)).getField("docInfo") != null) {
                ArrayList<Field> toPrint = new ArrayList<Field>();
                if (allFieldsMode) {
                    for (Field f : doc.getFields()) {
                        if (f.name().matches("^(docInfo|chunkCount|key|fileDate)$")) continue;
                        toPrint.add(f);
                    }
                } else {
                    int j2 = 0;
                    while (j2 < fieldNames.length) {
                        Field[] got = doc.getFields(fieldNames[j2]);
                        if (got != null) {
                            toPrint.addAll(Arrays.asList(got));
                        } else {
                            toPrint.add(emptyFields[j2]);
                        }
                        ++j2;
                    }
                }
                if (!toPrint.isEmpty()) {
                    if (xmlMode) {
                        IndexDump.dumpXmlRecord(toPrint, out);
                    } else {
                        IndexDump.dumpDelimitedRecord(toPrint, out);
                    }
                }
            }
            ++i;
        }
        if (xmlMode) {
            out.write("</xtfIndexDocuments>\n");
        }
    }

    private static void dumpTermFreqs(IndexReader indexReader, DocNumMap docNumMap, String[] fields, Writer out) throws IOException {
        TermDocs docs = indexReader.termDocs();
        int i = 0;
        while (i < fields.length) {
            TermEnum terms = indexReader.terms(new Term(fields[i], ""));
            while (terms.next()) {
                char c;
                Term t = terms.term();
                if (!t.field().equals(fields[i])) break;
                String text = t.text();
                if (text.indexOf("~") >= 0 || text.length() == 0 || (c = text.charAt(0)) == '\uebeb' || c == '\ue111' || c == '\ue112' || (c = text.charAt(text.length() - 1)) == '\uee1d' || c == '\ue111' || c == '\ue112') continue;
                int prevMainDoc = -1;
                int docFreq = 0;
                docs.seek(terms);
                int termFreq = 0;
                while (docs.next()) {
                    int mainDoc = docs.doc();
                    if (t.field().equals("text")) {
                        mainDoc = docNumMap.getDocNum(docs.doc());
                    }
                    if (mainDoc != prevMainDoc) {
                        ++docFreq;
                        prevMainDoc = mainDoc;
                    }
                    termFreq += docs.freq();
                }
                out.write(String.valueOf(fields[i]) + "|" + docFreq + "|" + termFreq + "|" + t.text() + "\n");
            }
            ++i;
        }
    }

    private static String stripValue(String str, boolean changeDelimiters) {
        char[] in = str.toCharArray();
        char[] out = new char[in.length * 2];
        int outLen = 0;
        int i = 0;
        while (i < in.length) {
            switch (in[i]) {
                case '\ue90d': 
                case '\uebeb': 
                case '\uee1d': {
                    break;
                }
                case '\uebbb': {
                    ++i;
                    while (i < in.length && in[i] != '\uebbb') {
                        ++i;
                    }
                    if (i < in.length) {
                        ++i;
                    }
                    out[outLen++] = 59;
                    break;
                }
                case ';': {
                    out[outLen++] = changeDelimiters ? 44 : in[i];
                    break;
                }
                case '|': {
                    out[outLen++] = changeDelimiters ? 46 : in[i];
                    break;
                }
                case '\n': {
                    if (changeDelimiters) {
                        out[outLen++] = 92;
                        out[outLen++] = 110;
                        break;
                    }
                    out[outLen++] = in[i];
                    break;
                }
                default: {
                    out[outLen++] = in[i];
                }
            }
            ++i;
        }
        return new String(out, 0, outLen);
    }
}

