/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Enumeration;

public class CrimsonBugWorkaround
extends SequenceInputStream {
    InputStream in;

    public CrimsonBugWorkaround(InputStream in) {
        super(new BlockEnum(in));
    }

    private static class BlockEnum
    implements Enumeration {
        static final int BLOCK_SIZE = 32768;
        InputStream in;
        byte[] inBuf = new byte[32768];
        int inBufLen;
        byte[] outBuf = new byte[65536];
        int outBufLen;
        boolean eof = false;
        byte prev = (byte)97;

        BlockEnum(InputStream in) {
            this.in = in;
        }

        public boolean hasMoreElements() {
            return !this.eof;
        }

        public Object nextElement() {
            try {
                this.inBufLen = 0;
                while (!this.eof && this.inBufLen < 32768) {
                    int nRead = this.in.read(this.inBuf, this.inBufLen, 32768 - this.inBufLen);
                    if (nRead < 0) {
                        this.eof = true;
                        break;
                    }
                    this.inBufLen += nRead;
                    assert (this.inBufLen <= 32768);
                }
                this.fixBuf();
                return new ByteArrayInputStream(this.outBuf, 0, this.outBufLen);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void fixBuf() {
            this.outBufLen = 0;
            int src = 0;
            while (src < this.inBufLen) {
                byte cur = this.inBuf[src];
                if (cur == 93 && this.prev == 62) {
                    this.outBuf[this.outBufLen++] = 32;
                }
                this.outBuf[this.outBufLen++] = cur;
                this.prev = cur;
                ++src;
            }
        }
    }
}

