/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine.facet;

import java.util.Arrays;
import org.apache.lucene.util.PriorityQueue;
import org.cdlib.xtf.textEngine.DocHit;
import org.cdlib.xtf.textEngine.DocHitImpl;
import org.cdlib.xtf.textEngine.facet.FacetSpec;
import org.cdlib.xtf.textEngine.facet.GroupData;
import org.cdlib.xtf.textEngine.facet.GroupSelector;
import org.cdlib.xtf.textEngine.facet.ResultFacet;
import org.cdlib.xtf.textEngine.facet.ResultGroup;

public class GroupCounts {
    private GroupData data;
    private FacetSpec spec;
    private HitQueueMaker hitQueueMaker;
    private boolean prepMode = false;
    private int[] count;
    private float[] score;
    private int[] mark;
    private int[] selection;
    private int[] startDoc;
    private int[] maxDocs;
    private PriorityQueue[] hitQueue;
    private int[] sortedChild;
    private int[] sortedSibling;
    private int curMark = 1000;
    private static final int SORT_BY_VALUE = 0;
    private static final int SORT_BY_REVERSE_VALUE = 1;
    private static final int SORT_BY_TOTAL_DOCS = 2;
    private static final int SORT_BY_MAX_DOC_SCORE = 3;

    public GroupCounts(GroupData groupData, FacetSpec spec, HitQueueMaker hitQueueMaker) {
        this.data = groupData;
        this.spec = spec;
        this.hitQueueMaker = hitQueueMaker;
        if (!this.data.isDynamic()) {
            this.count = new int[this.data.nGroups()];
            this.score = new float[this.data.nGroups()];
        }
        this.mark = new int[this.data.nGroups()];
        this.selection = new int[this.data.nGroups()];
        this.startDoc = new int[this.data.nGroups()];
        this.maxDocs = new int[this.data.nGroups()];
        this.hitQueue = new PriorityQueue[this.data.nGroups()];
        if (this.data.isDynamic()) {
            this.sortAndSelect();
        } else {
            this.conservativePrep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void conservativePrep() {
        try {
            GroupSelector sel;
            this.prepMode = true;
            GroupSelector groupSelector = sel = this.spec.groupSelector;
            synchronized (groupSelector) {
                sel.setCounts(this);
                sel.reset(true);
                sel.process(0);
                sel.flush();
            }
        }
        finally {
            this.prepMode = false;
        }
    }

    public final void selectGroup(int group) {
        if (this.prepMode) {
            return;
        }
        boolean first = true;
        while (group >= 0) {
            if (first) {
                this.selection[group] = 1;
            } else {
                if (this.selection[group] != 0) break;
                this.selection[group] = 2;
            }
            group = this.data.parent(group);
        }
    }

    public final void gatherDocs(int group, int startDoc, int maxDocs) {
        this.startDoc[group] = startDoc;
        this.maxDocs[group] = maxDocs;
    }

    public final boolean nondefaultSort() {
        return !this.spec.sortGroupsBy.equals("value");
    }

    public final boolean shouldInclude(int group) {
        return this.spec.includeEmptyGroups || !(this.data.isDynamic() ? this.data.nDocHits(group) == 0 : !this.prepMode && this.count[group] == 0);
    }

    public final int nGroups() {
        return this.data.nGroups();
    }

    public final int child(int group) {
        if (this.sortedChild != null) {
            return this.sortedChild[group];
        }
        return this.data.child(group);
    }

    public final int sibling(int group) {
        if (this.sortedSibling != null) {
            return this.sortedSibling[group];
        }
        return this.data.sibling(group);
    }

    public final int parent(int group) {
        return this.data.parent(group);
    }

    public final String name(int group) {
        return this.data.name(group);
    }

    public final boolean isSelected(int group) {
        return this.selection[group] == 1;
    }

    public final int nDocHits(int group) {
        if (this.data.isDynamic()) {
            return this.data.nDocHits(group);
        }
        return this.count[group];
    }

    public final float score(int group) {
        if (this.data.isDynamic()) {
            return this.data.score(group);
        }
        return this.score[group];
    }

    public void addDoc(DocHitMaker docHitMaker) {
        ++this.curMark;
        int doc = docHitMaker.getDocNum();
        float docScore = docHitMaker.getScore();
        int link = this.data.firstLink(doc);
        while (link >= 0) {
            int group = this.data.linkGroup(link);
            while (group >= 0) {
                if (this.mark[group] == this.curMark) break;
                if (!this.data.isDynamic()) {
                    int n = group;
                    this.count[n] = this.count[n] + 1;
                    this.score[group] = Math.max(this.score[group], docScore);
                }
                this.mark[group] = this.curMark;
                if (this.maxDocs[group] != 0) {
                    if (this.hitQueue[group] == null) {
                        this.hitQueue[group] = this.hitQueueMaker.makeQueue(this.startDoc[group] + this.maxDocs[group]);
                    }
                    docHitMaker.insertInto(this.hitQueue[group]);
                }
                group = this.data.parent(group);
            }
            link = this.data.nextLink(link);
        }
    }

    public ResultFacet getResult() {
        ResultFacet resultFacet = new ResultFacet();
        resultFacet.field = this.data.field();
        if (!this.data.isDynamic()) {
            this.sortAndSelect();
        }
        resultFacet.rootGroup = this.buildResultGroup(0);
        return resultFacet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortAndSelect() {
        GroupSelector sel;
        Arrays.fill(this.startDoc, 0);
        Arrays.fill(this.maxDocs, 0);
        this.sortGroups();
        GroupSelector groupSelector = sel = this.spec.groupSelector;
        synchronized (groupSelector) {
            sel.setCounts(this);
            sel.reset(false);
            sel.process(0);
            sel.flush();
        }
    }

    public ResultGroup buildResultGroup(int parent) {
        ResultGroup result = new ResultGroup();
        if (parent != 0) {
            result.value = this.data.name(parent);
        }
        result.totalDocs = this.nDocHits(parent);
        int nSelected = 0;
        int kid = this.child(parent);
        while (kid >= 0) {
            if (this.shouldInclude(kid)) {
                ++result.totalSubGroups;
                if (this.selection[kid] != 0) {
                    ++nSelected;
                }
            }
            kid = this.sibling(kid);
        }
        if (nSelected > 0) {
            result.subGroups = new ResultGroup[nSelected];
        }
        int rank = 0;
        int n = 0;
        int kid2 = this.child(parent);
        while (kid2 >= 0) {
            if (this.shouldInclude(kid2)) {
                if (this.selection[kid2] != 0) {
                    result.subGroups[n] = this.buildResultGroup(kid2);
                    result.subGroups[n].rank = rank;
                    ++n;
                }
                ++rank;
            }
            kid2 = this.sibling(kid2);
        }
        assert (n == nSelected) : "miscount";
        if (this.maxDocs[parent] != 0 && this.hitQueue[parent] != null) {
            this.buildDocHits(parent, result);
        }
        return result;
    }

    private void sortGroups() {
        int sortKind;
        if (this.spec.sortGroupsBy.equals("value")) {
            sortKind = 0;
        } else if (this.spec.sortGroupsBy.equals("reverseValue")) {
            sortKind = 1;
        } else if (this.spec.sortGroupsBy.equals("totalDocs")) {
            sortKind = 2;
        } else if (this.spec.sortGroupsBy.equals("maxDocScore")) {
            sortKind = 3;
        } else {
            throw new RuntimeException("Unknown option for sortGroupsBy: " + this.spec.sortGroupsBy);
        }
        if (!this.data.isDynamic() && sortKind == 0) {
            return;
        }
        int nBefore = this.countDescendants(0);
        this.sortedChild = new int[this.data.nGroups()];
        this.sortedSibling = new int[this.data.nGroups()];
        Arrays.fill(this.sortedChild, -1);
        Arrays.fill(this.sortedSibling, -1);
        this.sortChildren(0, sortKind);
        int nAfter = this.countDescendants(0);
        assert (nAfter == nBefore) : "mis-count on sort";
    }

    private int countDescendants(int group) {
        int count = 1;
        int kid = this.child(group);
        while (kid >= 0) {
            count += this.countDescendants(kid);
            kid = this.sibling(kid);
        }
        return count;
    }

    private void buildDocHits(int group, ResultGroup resultGroup) {
        PriorityQueue queue = this.hitQueue[group];
        int nFound = queue.size();
        DocHitImpl[] hitArray = new DocHitImpl[nFound];
        int i = 0;
        while (i < nFound) {
            int index = nFound - i - 1;
            hitArray[index] = (DocHitImpl)queue.pop();
            ++i;
        }
        int start = this.startDoc[group];
        int max = this.maxDocs[group];
        int nHits = Math.max(0, Math.min(nFound - start, max));
        resultGroup.docHits = new DocHit[nHits];
        resultGroup.totalDocs = this.nDocHits(group);
        resultGroup.startDoc = start;
        resultGroup.endDoc = start + nHits;
        int i2 = this.startDoc[group];
        while (i2 < nFound) {
            resultGroup.docHits[i2 - start] = hitArray[i2];
            ++i2;
        }
    }

    private void sortChildren(int parent, int sortKind) {
        int q;
        int first = this.data.child(parent);
        if (first < 0) {
            return;
        }
        int nChildrenBefore = 0;
        int p = first;
        while (p >= 0) {
            this.sortedSibling[p] = q = this.data.sibling(p);
            ++nChildrenBefore;
            p = q;
        }
        int insize = 1;
        while (true) {
            p = first;
            first = -1;
            int tail = -1;
            int nmerges = 0;
            while (p >= 0) {
                ++nmerges;
                q = p;
                int psize = 0;
                int i = 0;
                while (i < insize) {
                    ++psize;
                    if ((q = this.sortedSibling[q]) < 0) break;
                    ++i;
                }
                int qsize = insize;
                while (psize > 0 || qsize > 0 && q >= 0) {
                    int e;
                    if (psize == 0) {
                        e = q;
                        q = this.sortedSibling[q];
                        --qsize;
                    } else if (qsize == 0 || q < 0) {
                        e = p;
                        p = this.sortedSibling[p];
                        --psize;
                    } else if (this.compare(p, q, sortKind) <= 0) {
                        e = p;
                        p = this.sortedSibling[p];
                        --psize;
                    } else {
                        e = q;
                        q = this.sortedSibling[q];
                        --qsize;
                    }
                    if (tail >= 0) {
                        this.sortedSibling[tail] = e;
                    } else {
                        first = e;
                    }
                    tail = e;
                }
                p = q;
            }
            this.sortedSibling[tail] = -1;
            if (nmerges <= 1) break;
            insize *= 2;
        }
        this.sortedChild[parent] = first;
        p = first;
        while (p >= 0) {
            this.sortChildren(p, sortKind);
            p = this.sortedSibling[p];
        }
        int nChildrenAfter = 0;
        p = this.sortedChild[parent];
        while (p >= 0) {
            if (this.sortedSibling[p] >= 0) assert (this.compare(p, this.sortedSibling[p], sortKind) <= 0) : "error in merge sort";
            ++nChildrenAfter;
            p = this.sortedSibling[p];
        }
        assert (nChildrenAfter == nChildrenBefore);
    }

    private int compare(int g1, int g2, int sortKind) {
        switch (sortKind) {
            case 0: {
                int x = this.data.compare(g1, g2);
                if (x != 0) {
                    return x;
                }
                x = -GroupCounts.compare(this.score(g1), this.score(g2));
                if (x != 0) {
                    return x;
                }
                x = -GroupCounts.compare(this.nDocHits(g1), this.nDocHits(g2));
                if (x != 0) {
                    return x;
                }
                return 0;
            }
            case 1: {
                int x = -this.data.compare(g1, g2);
                if (x != 0) {
                    return x;
                }
                x = -GroupCounts.compare(this.score(g1), this.score(g2));
                if (x != 0) {
                    return x;
                }
                x = -GroupCounts.compare(this.nDocHits(g1), this.nDocHits(g2));
                if (x != 0) {
                    return x;
                }
                return 0;
            }
            case 2: {
                int x = -GroupCounts.compare(this.nDocHits(g1), this.nDocHits(g2));
                if (x != 0) {
                    return x;
                }
                x = this.data.compare(g1, g2);
                if (x != 0) {
                    return x;
                }
                x = -GroupCounts.compare(this.score(g1), this.score(g2));
                if (x != 0) {
                    return x;
                }
                return 0;
            }
            case 3: {
                int x = -GroupCounts.compare(this.score(g1), this.score(g2));
                if (x != 0) {
                    return x;
                }
                x = this.data.compare(g1, g2);
                if (x != 0) {
                    return x;
                }
                x = -GroupCounts.compare(this.nDocHits(g1), this.nDocHits(g2));
                if (x != 0) {
                    return x;
                }
                return 0;
            }
        }
        return 0;
    }

    private static int compare(int x, int y) {
        return x < y ? -1 : (x > y ? 1 : 0);
    }

    private static int compare(float x, float y) {
        return x < y ? -1 : (x > y ? 1 : 0);
    }

    public static interface DocHitMaker {
        public int getDocNum();

        public float getScore();

        public boolean insertInto(PriorityQueue var1);
    }

    public static interface HitQueueMaker {
        public PriorityQueue makeQueue(int var1);
    }
}

