/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.chunk.Chunk;
import org.apache.lucene.chunk.ChunkSource;
import org.apache.lucene.chunk.DocNumMap;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.cdlib.xtf.textEngine.XtfChunk;
import org.cdlib.xtf.util.Trace;

class XtfChunkSource
extends ChunkSource {
    private static final char bumpMarker = '\uebbb';
    private static final char nodeMarker = '\ue90d';

    XtfChunkSource(IndexReader reader, DocNumMap docNumMap, int mainDocNum, String field, Analyzer analyzer) {
        super(reader, docNumMap, mainDocNum, field, analyzer);
    }

    protected Chunk createChunkTokens(int chunkNum) {
        return new XtfChunk(this, chunkNum);
    }

    protected void loadText(int chunkNum, Chunk ct) throws IOException {
        XtfChunk chunk = (XtfChunk)ct;
        Document doc = this.reader.document(chunkNum);
        chunk.text = doc.get(this.field);
        try {
            chunk.startNodeNumber = Integer.parseInt(doc.get("node"));
            chunk.startWordOffset = Integer.parseInt(doc.get("wordOffset"));
            chunk.sectionType = doc.get("sectionType");
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
    }

    public Chunk loadChunk(int chunkNum) {
        assert (chunkNum >= this.firstChunk && chunkNum <= this.lastChunk);
        XtfChunk chunk = (XtfChunk)super.loadChunk(chunkNum);
        if (chunk.nodeNumbers != null) {
            return chunk;
        }
        chunk.nodeNumbers = new int[chunk.tokens.length];
        chunk.wordOffsets = new int[chunk.tokens.length];
        int nodeNumber = chunk.startNodeNumber;
        int wordOffset = chunk.startWordOffset;
        int totalWordOffset = chunk.minWordPos - 1;
        int tokenWordOffset = chunk.minWordPos - 1;
        int prevCharPos = 0;
        StringBuffer buf = new StringBuffer(chunk.text.length());
        int i = 0;
        while (i <= chunk.tokens.length) {
            int charPos = i < chunk.tokens.length ? chunk.tokens[i].startOffset() : chunk.text.length();
            String textBetween = chunk.text.substring(prevCharPos, charPos);
            if (i < chunk.tokens.length) {
                ++totalWordOffset;
                tokenWordOffset += chunk.tokens[i].getPositionIncrement();
            }
            int pos = 0;
            while (true) {
                int nodeMarkerPos = textBetween.indexOf(59661, pos);
                int bumpMarkerPos = textBetween.indexOf(60347, pos);
                if (nodeMarkerPos >= 0 && (bumpMarkerPos < 0 || nodeMarkerPos < bumpMarkerPos)) {
                    buf.append(textBetween.substring(pos, nodeMarkerPos));
                    ++pos;
                    ++nodeNumber;
                    wordOffset = 0;
                    pos = nodeMarkerPos + 1;
                    continue;
                }
                if (bumpMarkerPos < 0) break;
                buf.append(textBetween.substring(pos, bumpMarkerPos));
                int bumpEnd = textBetween.indexOf(60347, bumpMarkerPos + 1);
                assert (bumpEnd >= 0);
                String bumpText = textBetween.substring(bumpMarkerPos + 1, bumpEnd);
                try {
                    int bump = Integer.parseInt(bumpText);
                    totalWordOffset += bump;
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException(e);
                }
                pos = bumpEnd + 1;
            }
            if (i > 0) {
                buf.append(textBetween.substring(pos));
            }
            if (i == chunk.tokens.length) break;
            assert (totalWordOffset == tokenWordOffset);
            int startPos = buf.length();
            buf.append(chunk.text.substring(chunk.tokens[i].startOffset(), chunk.tokens[i].endOffset()));
            int endPos = buf.length();
            Token oldToken = chunk.tokens[i];
            chunk.tokens[i] = new Token(oldToken.termText(), startPos, endPos);
            chunk.tokens[i].setPositionIncrement(oldToken.getPositionIncrement());
            chunk.nodeNumbers[i] = nodeNumber;
            chunk.wordOffsets[i] = wordOffset++;
            chunk.maxWordPos = totalWordOffset;
            prevCharPos = oldToken.endOffset();
            ++i;
        }
        chunk.text = buf.toString();
        return chunk;
    }

    private void debugChunk(XtfChunk chunk) {
        StringBuffer buf1 = new StringBuffer();
        StringBuffer buf2 = new StringBuffer();
        String spaces = "                                                            ";
        Trace.debug("*** CHUNK " + chunk.chunkNum + " ***");
        if (chunk.tokens.length == 0) {
            Trace.debug("   [[chunk has no tokens]]");
            return;
        }
        buf1.append(spaces.substring(0, chunk.tokens[0].startOffset()));
        buf2.append(chunk.text.substring(0, chunk.tokens[0].startOffset()));
        int pos = chunk.minWordPos - 1;
        int i = 0;
        while (i < chunk.tokens.length) {
            String tokText;
            String num;
            int tokLen;
            int n = tokLen = i < chunk.tokens.length - 1 ? chunk.tokens[i + 1].startOffset() - chunk.tokens[i].startOffset() : chunk.text.length() - chunk.tokens[i].startOffset();
            if (buf1.length() + tokLen > 80) {
                Trace.debug(" " + buf1.toString());
                Trace.debug("\"" + buf2.toString() + "\"\n");
                buf1.setLength(0);
                buf2.setLength(0);
            }
            if ((num = String.valueOf(Integer.toString(pos += chunk.tokens[i].getPositionIncrement())) + " ").length() < tokLen) {
                num = String.valueOf(num) + spaces.substring(0, tokLen - num.length());
            }
            if ((tokText = chunk.text.substring(chunk.tokens[i].startOffset(), chunk.tokens[i].startOffset() + tokLen)).length() < num.length()) {
                tokText = String.valueOf(tokText) + spaces.substring(0, num.length() - tokText.length());
            }
            buf1.append(num);
            buf2.append(tokText);
            ++i;
        }
        Trace.debug(" " + buf1.toString());
        Trace.debug("\"" + buf2.toString() + "\"\n");
    }
}

