/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.chunk.DocNumMap;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.mark.ContextMarker;
import org.apache.lucene.mark.MarkCollector;
import org.apache.lucene.mark.MarkPos;
import org.apache.lucene.search.spans.FieldSpans;
import org.apache.lucene.search.spans.Span;
import org.cdlib.xtf.textEngine.BoundedMarkPos;
import org.cdlib.xtf.textEngine.BoundedWordIter;
import org.cdlib.xtf.textEngine.Snippet;
import org.cdlib.xtf.textEngine.XtfChunkMarkPos;
import org.cdlib.xtf.textEngine.XtfChunkedWordIter;
import org.cdlib.xtf.textIndexer.XTFTextAnalyzer;
import org.cdlib.xtf.util.CharMap;
import org.cdlib.xtf.util.WordMap;

public class SnippetMaker {
    public IndexReader reader;
    private Analyzer analyzer;
    private DocNumMap docNumMap;
    private int chunkSize;
    private int chunkOverlap;
    private Set stopSet;
    private WordMap pluralMap;
    private CharMap accentMap;
    private Set tokFields;
    private int maxContext;
    private int termMode;
    private Set<String> returnMetaFields;
    private static final Pattern ampPattern = Pattern.compile("&");
    private static final Pattern ltPattern = Pattern.compile("<");
    private static final Pattern gtPattern = Pattern.compile(">");

    public SnippetMaker(IndexReader reader, DocNumMap docNumMap, Set stopSet, WordMap pluralMap, CharMap accentMap, Set tokFields, int maxContext, int termMode, String returnMetaFields) {
        this.reader = reader;
        this.docNumMap = docNumMap;
        this.chunkSize = docNumMap.getChunkSize();
        this.chunkOverlap = docNumMap.getChunkOverlap();
        this.stopSet = stopSet;
        this.pluralMap = pluralMap;
        this.accentMap = accentMap;
        this.tokFields = tokFields;
        this.maxContext = maxContext;
        this.termMode = termMode;
        this.returnMetaFields = returnMetaFields != null ? new HashSet<String>(Arrays.asList(returnMetaFields.split("[, ]+"))) : null;
        this.analyzer = new XTFTextAnalyzer(null, pluralMap, accentMap);
    }

    public Set stopSet() {
        return this.stopSet;
    }

    public WordMap pluralMap() {
        return this.pluralMap;
    }

    public CharMap accentMap() {
        return this.accentMap;
    }

    public DocNumMap docNumMap() {
        return this.docNumMap;
    }

    public Set tokFields() {
        return this.tokFields;
    }

    public Set returnMetaFields() {
        return this.returnMetaFields;
    }

    public Snippet[] makeSnippets(FieldSpans fieldSpans, int mainDocNum, String fieldName, final boolean getText) {
        XtfChunkedWordIter wordIter = new XtfChunkedWordIter(this.reader, this.docNumMap, mainDocNum, fieldName, this.analyzer);
        int nSnippets = fieldSpans.getSpanCount(fieldName);
        final Snippet[] snippets = new Snippet[nSnippets];
        ContextMarker.markField(fieldSpans, fieldName, wordIter, getText ? this.maxContext : 0, getText ? this.termMode : 0, this.stopSet, new MarkCollector(){
            private Snippet curSnippet;
            private MarkPos prevPos = null;
            private StringBuffer buf;
            {
                this.buf = bl ? new StringBuffer() : null;
            }

            private void copyUpTo(MarkPos pos) {
                if (this.prevPos != null) {
                    this.buf.append(SnippetMaker.this.mapXMLChars(this.prevPos.getTextTo(pos)));
                }
                this.prevPos = pos;
            }

            public void beginField(MarkPos pos) {
            }

            public void beginContext(MarkPos pos, Span span) {
                if (getText) {
                    this.buf.setLength(0);
                }
                this.prevPos = pos;
            }

            public void term(MarkPos startPos, MarkPos endPos, String term) {
                if (getText) {
                    this.copyUpTo(startPos);
                    this.buf.append("<term>");
                    this.buf.append(startPos.getTextTo(endPos));
                    this.buf.append("</term>");
                }
                this.prevPos = endPos;
            }

            public void beginSpan(MarkPos pos, Span span) {
                if (getText) {
                    if (SnippetMaker.this.maxContext > 0) {
                        this.copyUpTo(pos);
                    } else {
                        this.prevPos = pos;
                    }
                    this.buf.append("<hit>");
                }
                this.curSnippet = snippets[span.rank] = new Snippet();
                XtfChunkMarkPos xp = (XtfChunkMarkPos)pos;
                this.curSnippet.startNode = xp.nodeNumber;
                this.curSnippet.startOffset = xp.wordOffset;
                this.curSnippet.sectionType = xp.sectionType;
                this.curSnippet.rank = span.rank;
                this.curSnippet.score = span.score;
            }

            public void endSpan(MarkPos pos) {
                if (getText) {
                    this.copyUpTo(pos);
                    this.buf.append("</hit>");
                }
                XtfChunkMarkPos xp = (XtfChunkMarkPos)pos;
                this.curSnippet.endNode = xp.nodeNumber;
                this.curSnippet.endOffset = xp.wordOffset;
            }

            public void endContext(MarkPos pos) {
                if (getText) {
                    this.copyUpTo(pos);
                    this.curSnippet.text = this.buf.toString();
                }
            }

            public void endField(MarkPos pos) {
            }
        });
        int i = 0;
        while (i < nSnippets) {
            assert (snippets[i] != null);
            ++i;
        }
        return snippets;
    }

    public String markField(Document doc, FieldSpans fieldSpans, String fieldName, String value) {
        try {
            final StringBuffer buf = new StringBuffer(value.length() * 2);
            TokenStream stream = this.analyzer.tokenStream(fieldName, new StringReader(value));
            stream = new StartEndStripper(stream);
            BoundedWordIter wordIter = new BoundedWordIter(value, stream, this.chunkOverlap);
            ContextMarker.markField(fieldSpans, fieldName, wordIter, this.maxContext, this.termMode, this.stopSet, new MarkCollector(){
                private MarkPos prevPos = null;
                private boolean inContext = false;
                private boolean inSpan = false;
                private int contextSize;
                private MarkPos contextStart;

                private void copyUpTo(MarkPos pos) {
                    if (this.prevPos != null) {
                        String toAdd = ((BoundedMarkPos)this.prevPos).getTextTo(pos, this.inContext || this.inSpan);
                        buf.append(toAdd);
                        if (this.inContext) {
                            this.contextSize += toAdd.length();
                        }
                    }
                    this.prevPos = pos;
                }

                public void beginField(MarkPos pos) {
                    this.prevPos = pos;
                }

                public void beginContext(MarkPos pos, Span span) {
                    this.copyUpTo(pos);
                    buf.append("<snippet rank=\"");
                    buf.append(Integer.toString(span.rank + 1));
                    buf.append("\" score=\"");
                    buf.append(Integer.toString((int)(span.score * 100.0f)));
                    buf.append("\">");
                    this.inContext = true;
                    this.contextSize = 0;
                    this.contextStart = pos;
                }

                public void term(MarkPos startPos, MarkPos endPos, String term) {
                    this.copyUpTo(startPos);
                    String toAdd = startPos.getTextTo(endPos);
                    buf.append("<term>");
                    buf.append(toAdd);
                    buf.append("</term>");
                    if (this.inContext) {
                        this.contextSize += toAdd.length();
                    }
                    this.prevPos = endPos;
                }

                public void beginSpan(MarkPos pos, Span span) {
                    this.copyUpTo(pos);
                    buf.append("<hit");
                    if (!this.inContext) {
                        buf.append(" rank=\"");
                        buf.append(Integer.toString(span.rank + 1));
                        buf.append("\" score=\"");
                        buf.append(Integer.toString((int)(span.score * 100.0f)));
                        buf.append("\"");
                    }
                    buf.append(">");
                    this.inSpan = true;
                }

                public void endSpan(MarkPos pos) {
                    this.copyUpTo(pos);
                    buf.append("</hit>");
                    this.inSpan = false;
                }

                public void endContext(MarkPos pos) {
                    this.copyUpTo(pos);
                    buf.append("</snippet>");
                    if (this.contextSize > SnippetMaker.this.maxContext) {
                        int n = this.contextStart.countTextTo(pos);
                    }
                    this.inContext = false;
                }

                public void endField(MarkPos pos) {
                    this.copyUpTo(pos);
                }
            });
            String strVal = buf.toString();
            return strVal;
        }
        catch (IOException e) {
            throw new RuntimeException("How could StringReader throw an exception?");
        }
        catch (BoundedMarkPos.UnmarkableException e) {
            return value;
        }
    }

    String mapXMLChars(String s) {
        if (s.indexOf(38) >= 0) {
            s = ampPattern.matcher(s).replaceAll("&amp;");
        }
        if (s.indexOf(60) >= 0) {
            s = ltPattern.matcher(s).replaceAll("&lt;");
        }
        if (s.indexOf(62) >= 0) {
            s = gtPattern.matcher(s).replaceAll("&gt;");
        }
        return s;
    }

    public class StartEndStripper
    extends TokenFilter {
        public StartEndStripper(TokenStream input) {
            super(input);
        }

        public Token next() throws IOException {
            boolean isEndToken;
            Token t = this.input.next();
            if (t == null) {
                return t;
            }
            String term = t.termText();
            boolean isStartToken = term.charAt(0) == '\uebeb';
            boolean bl = isEndToken = term.charAt(term.length() - 1) == '\uee1d';
            if (isStartToken || isEndToken) {
                Token nextTok = this.input.next();
                assert (term.indexOf(nextTok.termText()) >= 0);
                int start = t.startOffset();
                if (isStartToken) {
                    ++start;
                }
                int end = t.endOffset();
                if (isEndToken) {
                    --end;
                }
                Token newTok = new Token(nextTok.termText(), start, end, nextTok.type());
                newTok.setPositionIncrement(t.getPositionIncrement());
                return newTok;
            }
            return t;
        }
    }
}

