/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.TermQuery;
import org.cdlib.xtf.crossQuery.test.TestableCrossQuery;
import org.cdlib.xtf.dynaXML.test.TestableDynaXML;
import org.cdlib.xtf.util.EasyNode;
import org.cdlib.xtf.util.Trace;

public class IndexValidator {
    private TestableCrossQuery crossQuery;
    private TestableDynaXML dynaXML;
    private int nErrs;

    public boolean validate(String baseDir, String indexPath, IndexReader indexReader) throws IOException {
        block9: {
            try {
                this.crossQuery = new TestableCrossQuery(baseDir);
                this.crossQuery.overrideIndexDir(indexPath);
                this.dynaXML = new TestableDynaXML(baseDir);
                this.dynaXML.overrideIndexDir(indexPath);
            }
            catch (ServletException e) {
                throw new IOException(e.getMessage());
            }
            Hits match = new IndexSearcher(indexReader).search(new TermQuery(new Term("indexInfo", "1")));
            if (match.length() == 0) {
                throw new IOException("Index missing indexInfo doc");
            }
            assert (match.id(0) == 0) : "indexInfo chunk must be first in index";
            Document doc = match.doc(0);
            String validationName = doc.get("validation");
            if (validationName == null || validationName.length() == 0) {
                return true;
            }
            Trace.info(String.format("Validating Index:", new Object[0]));
            Trace.tab();
            File validationFile = new File(indexPath, validationName);
            EasyNode root = EasyNode.readXMLFile(validationFile);
            this.nErrs = 0;
            this.traverse(root, 0);
            if (this.nErrs <= 0) break block9;
            Trace.untab();
            Trace.error(String.format("Validation failed: %d error(s)", this.nErrs));
            return false;
        }
        try {
            Trace.untab();
            Trace.info("Done.");
            return true;
        }
        catch (NumberFormatException err) {
            Trace.untab();
            Trace.error("Validation failed: non-numeric attribute found in validation specification");
            return false;
        }
        catch (Exception err) {
            Trace.untab();
            Trace.error("Validation failed: " + err.getMessage());
            return false;
        }
    }

    private void traverse(EasyNode node, int level) throws ValidationError, ServletException, IOException {
        this.visit(node, level);
        for (EasyNode child : node.children()) {
            this.traverse(child, level + 1);
        }
    }

    private void visit(EasyNode node, int level) throws ValidationError, ServletException, IOException {
        if (level == 0) {
            return;
        }
        if (level == 1) {
            String lookFor = "index-validation";
            if (!node.name().equals(lookFor)) {
                throw new ValidationError("Root element of validation file must be '<index-validation>'", new Object[0]);
            }
            return;
        }
        if (level > 2 && !node.isText()) {
            throw new ValidationError("Element '%s' not recognized at level %s", node.name(), level);
        }
        int minHits = 0;
        for (String attrName : node.attrNames()) {
            if (attrName.equals("minHits")) {
                minHits = Integer.parseInt(node.attrValue(attrName));
                continue;
            }
            throw new ValidationError("Attribute '%s' not recognized on '%s' element", attrName, node.name());
        }
        String url = node.toString();
        int nHits = 0;
        int prevTraceLevel = Trace.getOutputLevel();
        if (node.name().equals("crossQuery")) {
            Trace.info("crossQuery: [%s] ...", url);
            Trace.setOutputLevel(2);
            this.crossQuery.service(url);
            nHits = this.crossQuery.nHits();
        } else if (node.name().equals("dynaXML")) {
            Trace.info("dynaXML:    [%s] ...", url);
            Trace.setOutputLevel(2);
            this.dynaXML.service(url);
            nHits = this.dynaXML.nHits();
        } else if (node.isText()) {
            return;
        }
        Trace.setOutputLevel(prevTraceLevel);
        if (minHits != 0 && nHits < minHits) {
            Trace.more(4, " Failed:");
            Trace.error("            Validation required at least %d hits, but query returned %d", minHits, nHits);
            ++this.nErrs;
        } else {
            Trace.more(4, " Done.");
        }
    }

    public static class ValidationError
    extends Exception {
        ValidationError(String msg, Object ... args) {
            super(String.format(msg, args));
        }
    }
}

