/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.saxonExt.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;
import org.cdlib.xtf.saxonExt.sql.SQLProperty;

public class SQLConnect
extends ExtensionInstruction {
    Expression database;
    Expression driver;
    Expression user;
    Expression password;
    static ThreadLocal threadConnections = new ThreadLocal();

    public static synchronized void closeThreadConnections() {
        ArrayList list = (ArrayList)threadConnections.get();
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                Connection c = (Connection)list.get(i);
                try {
                    c.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ++i;
            }
        }
        threadConnections.set(null);
    }

    private static synchronized void addThreadConnection(Connection c) {
        ArrayList<Connection> list = (ArrayList<Connection>)threadConnections.get();
        if (list == null) {
            list = new ArrayList<Connection>();
            threadConnections.set(list);
        }
        list.add(c);
    }

    public boolean mayContainSequenceConstructor() {
        return false;
    }

    public void prepareAttributes() throws XPathException {
        String dbAtt = this.attributeList.getValue("", "database");
        if (dbAtt == null) {
            this.reportAbsence("database");
            dbAtt = "";
        }
        this.database = this.makeAttributeValueTemplate(dbAtt);
        String dbDriver = this.attributeList.getValue("", "driver");
        if (dbDriver == null) {
            if (dbAtt.length() > 9 && dbAtt.substring(0, 9).equals("jdbc:odbc")) {
                dbDriver = "sun.jdbc.odbc.JdbcOdbcDriver";
            } else {
                this.reportAbsence("driver");
            }
        }
        this.driver = this.makeAttributeValueTemplate(dbDriver);
        String userAtt = this.attributeList.getValue("", "user");
        this.user = userAtt == null ? new StringLiteral(StringValue.EMPTY_STRING) : this.makeAttributeValueTemplate(userAtt);
        String pwdAtt = this.attributeList.getValue("", "password");
        this.password = pwdAtt == null ? new StringLiteral(StringValue.EMPTY_STRING) : this.makeAttributeValueTemplate(pwdAtt);
    }

    public void validate() throws XPathException {
        super.validate();
        this.database = this.typeCheck("database", this.database);
        this.driver = this.typeCheck("driver", this.driver);
        this.user = this.typeCheck("user", this.user);
        this.password = this.typeCheck("password", this.password);
    }

    public Expression compile(Executable exec) throws XPathException {
        return new ConnectInstruction(this.database, this.driver, this.user, this.password, this.getPropertyInstructions(exec));
    }

    public List getPropertyInstructions(Executable exec) throws XPathException {
        NodeInfo child;
        ArrayList<Expression> list = new ArrayList<Expression>(10);
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)kids.next()) != null) {
            if (!(child instanceof SQLProperty)) continue;
            list.add(((SQLProperty)child).compile(exec));
        }
        return list;
    }

    private static class ConnectInstruction
    extends SimpleExpression {
        public static final int DATABASE = 0;
        public static final int DRIVER = 1;
        public static final int USER = 2;
        public static final int PASSWORD = 3;
        public static final int FIRST_PROPERTY = 4;

        public ConnectInstruction(Expression database, Expression driver, Expression user, Expression password, List propertyInstructions) {
            Expression[] subs = new Expression[propertyInstructions.size() + 4];
            subs[0] = database;
            subs[1] = driver;
            subs[2] = user;
            subs[3] = password;
            int i = 0;
            while (i < propertyInstructions.size()) {
                subs[i + 4] = (Expression)propertyInstructions.get(i);
                ++i;
            }
            this.setArguments(subs);
        }

        public int getImplementationMethod() {
            return 1;
        }

        public int computeCardinality() {
            return 16384;
        }

        public String getExpressionType() {
            return "sql:connect";
        }

        public Item evaluateItem(XPathContext context) throws XPathException {
            Connection connection = null;
            String dbString = this.arguments[0].evaluateAsString(context);
            String dbDriverString = this.arguments[1].evaluateAsString(context);
            String userString = this.arguments[2].evaluateAsString(context);
            String pwdString = this.arguments[3].evaluateAsString(context);
            try {
                Properties props = new Properties();
                if (userString != null) {
                    props.put("user", userString);
                }
                if (pwdString != null) {
                    props.put("password", pwdString);
                }
                int c = 4;
                while (c < this.arguments.length) {
                    SQLProperty.PropertyInstruction inst = (SQLProperty.PropertyInstruction)this.arguments[c];
                    AtomicValue v = (AtomicValue)inst.getSelectValue(context);
                    String name = inst.getPropertyName();
                    String val = v.getStringValue();
                    props.put(name, val);
                    ++c;
                }
                Class.forName(dbDriverString);
                connection = DriverManager.getConnection(dbString, props);
                SQLConnect.addThreadConnection(connection);
            }
            catch (Exception ex) {
                this.dynamicError("JDBC Connection Failure: " + ex.getMessage(), "SXSQ0003", context);
            }
            return new ObjectValue(connection);
        }
    }
}

