/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.saxonExt.image;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.File;
import javax.imageio.ImageIO;
import net.sf.saxon.trans.DynamicError;
import org.cdlib.xtf.cache.GeneratingCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImageCache
extends GeneratingCache<String, BufferedImage> {
    private int outColorBase;

    ImageCache(int outColorBase) {
        super(20, 300);
        this.outColorBase = outColorBase;
    }

    @Override
    protected BufferedImage generate(String filename) throws Exception {
        System.setProperty("java.awt.headless", "true");
        BufferedImage bi = ImageIO.read(new File(filename));
        bi = this.remapPalette(bi);
        return bi;
    }

    private BufferedImage remapPalette(BufferedImage inImg) throws DynamicError {
        if (!(inImg.getColorModel() instanceof IndexColorModel)) {
            throw new RuntimeException("image.output can only handle index color (palette) images");
        }
        IndexColorModel inCm = (IndexColorModel)inImg.getColorModel();
        int nInColors = inCm.getMapSize();
        byte[][] inColors = new byte[3][nInColors];
        inCm.getReds(inColors[0]);
        inCm.getGreens(inColors[1]);
        inCm.getBlues(inColors[2]);
        int nOutColors = this.outColorBase * 4;
        byte[][] outColors = new byte[3][nOutColors];
        int i = 0;
        while (i < this.outColorBase) {
            byte redMapped;
            byte greyVal;
            outColors[0][i + this.outColorBase * 0] = greyVal = (byte)(i * 255 / (this.outColorBase - 1));
            outColors[1][i + this.outColorBase * 0] = greyVal;
            outColors[2][i + this.outColorBase * 0] = greyVal;
            outColors[0][i + this.outColorBase * 1] = greyVal;
            outColors[1][i + this.outColorBase * 1] = greyVal;
            outColors[2][i + this.outColorBase * 1] = 0;
            outColors[0][i + this.outColorBase * 2] = redMapped = (byte)Math.max(160, greyVal & 0xFF);
            outColors[1][i + this.outColorBase * 2] = greyVal;
            outColors[2][i + this.outColorBase * 2] = greyVal;
            outColors[0][i + this.outColorBase * 3] = redMapped;
            outColors[1][i + this.outColorBase * 3] = greyVal;
            outColors[2][i + this.outColorBase * 3] = 0;
            ++i;
        }
        byte[] mapping = new byte[nInColors];
        int i2 = 0;
        while (i2 < nInColors) {
            int sum = (inColors[0][i2] & 0xFF) + (inColors[1][i2] & 0xFF) + (inColors[2][i2] & 0xFF);
            mapping[i2] = (byte)(sum * (this.outColorBase - 1) / 765);
            ++i2;
        }
        WritableRaster inRast = inImg.getRaster();
        int w = inRast.getWidth();
        int h = inRast.getHeight();
        if (inRast.getTransferType() != 0) {
            throw new RuntimeException("Unrecognized transfer type");
        }
        if (inRast.getNumDataElements() != 1) {
            throw new RuntimeException("How could index color have more than one data element?");
        }
        byte[] inPixels = new byte[w * h];
        inRast.getDataElements(0, 0, w, h, inPixels);
        IndexColorModel outCm = new IndexColorModel(8, nOutColors, outColors[0], outColors[1], outColors[2]);
        BufferedImage outImg = new BufferedImage(w, h, 13, outCm);
        WritableRaster outRast = outImg.getRaster();
        if (outRast.getTransferType() != 0) {
            throw new RuntimeException("Unrecognized transfer type");
        }
        if (outRast.getNumDataElements() != 1) {
            throw new RuntimeException("How could index color have more than one data element?");
        }
        byte[] outPixels = new byte[w * h];
        int i3 = 0;
        while (i3 < w * h) {
            outPixels[i3] = mapping[inPixels[i3] & 0xFF];
            ++i3;
        }
        outRast.setDataElements(0, 0, w, h, outPixels);
        return outImg;
    }
}

