/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.saxonExt.exec;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;
import org.cdlib.xtf.saxonExt.exec.ArgElement;
import org.cdlib.xtf.saxonExt.exec.InputElement;
import org.cdlib.xtf.util.ProcessRunner;

class RunInstruction
extends SimpleExpression {
    protected Expression command;
    protected int timeout;
    protected int nArgs;
    protected InputElement.InputInstruction inputExpr;

    public RunInstruction(Expression command, int timeout, List args) {
        this.command = command;
        this.timeout = timeout;
        this.nArgs = args.size();
        if (args.size() > 0 && args.get(args.size() - 1) instanceof InputElement.InputInstruction) {
            this.inputExpr = (InputElement.InputInstruction)args.get(args.size() - 1);
            --this.nArgs;
        }
        Expression[] sub = new Expression[args.size()];
        int i = 0;
        while (i < args.size()) {
            sub[i] = (Expression)args.get(i);
            ++i;
        }
        this.setArguments(sub);
    }

    public int getImplementationMethod() {
        return 1;
    }

    public String getExpressionType() {
        return "exec:run";
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        String[] argArray = this.gatherArgs(context);
        byte[] outBytes = this.runAndGrab(context, argArray);
        byte[] lookFor = "<?xml".getBytes();
        int i = 0;
        while (i < lookFor.length) {
            if (i >= outBytes.length || outBytes[i] != lookFor[i]) break;
            ++i;
        }
        if (i < lookFor.length) {
            return new StringValue(new String(outBytes));
        }
        StreamSource src = new StreamSource(new ByteArrayInputStream(outBytes));
        NodeInfo doc = null;
        try {
            doc = TinyBuilder.build((Source)src, (Stripper)new AllElementStripper(), context.getController().getConfiguration());
        }
        catch (XPathException e) {
            this.dynamicError("Error parsing XML output from external command '" + this.command + "': " + e, "EXEC004", context);
        }
        return doc;
    }

    protected byte[] runAndGrab(XPathContext context, String[] argArray) throws XPathException, DynamicError {
        byte[] inputBytes = new byte[]{};
        if (this.inputExpr != null) {
            inputBytes = this.inputExpr.getStream(context);
        }
        byte[] outputBytes = null;
        try {
            outputBytes = ProcessRunner.runAndGrab(argArray, inputBytes, this.timeout);
        }
        catch (IOException e) {
            this.dynamicError("IO exception occurred processing external command '" + this.command + "': " + e, "EXEC005", context);
        }
        catch (InterruptedException e) {
            this.dynamicError("External command '" + this.command + "' exceeded timeout of " + new DecimalFormat().format((double)this.timeout / 1000.0) + " sec", "EXEC002", context);
        }
        catch (ProcessRunner.CommandFailedException e) {
            this.dynamicError(e.getMessage(), "EXEC003", context);
        }
        return outputBytes;
    }

    protected String[] gatherArgs(XPathContext context) throws XPathException {
        ArrayList<String> args = new ArrayList<String>(10);
        args.add(this.command.evaluateAsString(context));
        int c = 0;
        while (c < this.nArgs) {
            String strVal = ((ArgElement.ArgInstruction)this.arguments[c]).getSelectValue(context).getStringValue();
            args.add(strVal);
            ++c;
        }
        String[] argArray = args.toArray(new String[args.size()]);
        return argArray;
    }
}

