/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.lazyTree;

import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import org.cdlib.xtf.lazyTree.ChildEnumeration;
import org.cdlib.xtf.lazyTree.NodeImpl;
import org.cdlib.xtf.lazyTree.TextImpl;

public abstract class ParentNodeImpl
extends NodeImpl {
    int childNum;

    public final boolean hasChildNodes() {
        return this.childNum >= 0;
    }

    public final AxisIterator enumerateChildren(NodeTest test) {
        if (this.childNum < 0) {
            return EmptyIterator.getInstance();
        }
        return new ChildEnumeration(this, test);
    }

    public AxisIterator iterateAxis(byte axisNumber) {
        if (axisNumber == 3) {
            return this.enumerateChildren(null);
        }
        return super.iterateAxis(axisNumber, AnyNodeTest.getInstance());
    }

    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        if (axisNumber == 3) {
            return this.enumerateChildren(nodeTest);
        }
        return super.iterateAxis(axisNumber, nodeTest);
    }

    public NodeInfo getFirstChild() {
        return this.document.getNode(this.childNum);
    }

    public NodeInfo getLastChild() {
        NodeInfo last = this.getFirstChild();
        if (last != null) {
            NodeInfo next;
            while ((next = ((NodeImpl)last).getNextSibling()) != null) {
                last = next;
            }
        }
        return last;
    }

    public String getStringValue() {
        return this.getStringValueCS().toString();
    }

    public CharSequence getStringValueCS() {
        FastStringBuffer sb = null;
        NodeImpl next = (NodeImpl)this.getFirstChild();
        while (next != null) {
            if (next instanceof TextImpl) {
                if (sb == null) {
                    sb = new FastStringBuffer(1024);
                }
                sb.append(next.getStringValueCS());
            }
            next = next.getNextInDocument(this);
        }
        if (sb == null) {
            return "";
        }
        return sb.condense();
    }
}

