/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.crossQuery.test;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cdlib.xtf.crossQuery.CrossQuery;
import org.cdlib.xtf.crossQuery.QueryRoute;
import org.cdlib.xtf.servletBase.TextConfig;
import org.cdlib.xtf.test.FakeServletConfig;
import org.cdlib.xtf.test.FakeServletContext;
import org.cdlib.xtf.test.FakeServletRequest;
import org.cdlib.xtf.test.FakeServletResponse;
import org.cdlib.xtf.test.NullOutputStream;
import org.cdlib.xtf.textEngine.DefaultQueryProcessor;
import org.cdlib.xtf.textEngine.IndexWarmer;
import org.cdlib.xtf.textEngine.QueryProcessor;
import org.cdlib.xtf.textEngine.QueryRequest;
import org.cdlib.xtf.textEngine.QueryResult;
import org.cdlib.xtf.util.AttribList;

public class TestableCrossQuery
extends CrossQuery {
    private String baseDir;
    private String indexDirOverride;
    private IndexWarmer indexWarmer;
    private ThreadLocal<Integer> nHits = new ThreadLocal();

    public TestableCrossQuery(String baseDir) throws ServletException {
        this.baseDir = baseDir;
        FakeServletContext context = new FakeServletContext();
        FakeServletConfig config = new FakeServletConfig(context, baseDir, "crossQuery");
        super.init((ServletConfig)config);
    }

    public void overrideIndexDir(String dir) {
        this.indexDirOverride = dir;
    }

    public void setIndexWarmer(IndexWarmer warmer) {
        this.indexWarmer = warmer;
    }

    public int nHits() {
        return this.nHits.get();
    }

    protected void setupTrace(TextConfig config) {
    }

    protected QueryRequest runQueryParser(HttpServletRequest req, HttpServletResponse res, QueryRoute route, AttribList attribs) throws Exception {
        QueryRequest queryReq = super.runQueryParser(req, res, route, attribs);
        if (this.indexDirOverride != null) {
            queryReq.indexPath = this.indexDirOverride;
        }
        return queryReq;
    }

    public QueryProcessor createQueryProcessor() {
        DefaultQueryProcessor processor = new DefaultQueryProcessor();
        processor.setXtfHome(this.baseDir);
        if (this.indexWarmer == null) {
            this.indexWarmer = new IndexWarmer(this.baseDir, 0);
        }
        processor.setIndexWarmer(this.indexWarmer);
        return processor;
    }

    public void service(String url) throws ServletException, IOException {
        FakeServletRequest req = new FakeServletRequest(url);
        NullOutputStream out = new NullOutputStream();
        FakeServletResponse res = new FakeServletResponse(out);
        super.service(req, res);
    }

    protected void formatHits(String mainTagName, HttpServletRequest req, HttpServletResponse res, AttribList attribs, QueryRequest queryRequest, QueryResult queryResult, long startTime) throws Exception {
        this.nHits.set(queryResult.totalDocs);
        super.formatHits(mainTagName, req, res, attribs, queryRequest, queryResult, startTime);
    }

    protected void genErrorPage(HttpServletRequest req, HttpServletResponse res, Exception exc) {
        this.nHits.set(-1);
        throw new RuntimeException(exc);
    }
}

