/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.crossQuery;

import java.util.HashMap;
import net.sf.saxon.om.NodeInfo;
import org.cdlib.xtf.crossQuery.QueryRouteException;
import org.cdlib.xtf.util.EasyNode;
import org.cdlib.xtf.util.GeneralException;

public class QueryRoute {
    public String queryParserSheet;
    public String errorGenSheet;
    public HashMap tokenizerMap = new HashMap();
    public String routerInput = null;
    public String routerOutput = null;

    protected QueryRoute() {
    }

    public static QueryRoute createDefault(String queryParserSheet) {
        QueryRoute ret = new QueryRoute();
        ret.queryParserSheet = queryParserSheet;
        return ret;
    }

    public static QueryRoute parse(NodeInfo input) throws GeneralException {
        QueryRoute ret = new QueryRoute();
        EasyNode root = new EasyNode(input);
        String rootTag = root.name();
        if (rootTag.equals("") && root.nChildren() == 1) {
            root = root.child(0);
            rootTag = root.name();
        }
        if (!rootTag.equalsIgnoreCase("route")) {
            throw new QueryRouteException("Query router stylesheet must output a 'route' element");
        }
        int i = 0;
        while (i < root.nChildren()) {
            EasyNode el = root.child(i);
            if (el.isElement()) {
                String tagName = el.name();
                if (tagName.equalsIgnoreCase("queryParser")) {
                    ret.parseQueryParser(el);
                } else if (tagName.equalsIgnoreCase("errorGen")) {
                    ret.parseErrorGen(el);
                } else if (tagName.equalsIgnoreCase("tokenize")) {
                    ret.parseTokenizer(el);
                }
            }
            ++i;
        }
        if (ret.queryParserSheet == null || ret.queryParserSheet.length() == 0) {
            throw new QueryRouteException("Query router stylesheet must output a 'queryParser' element");
        }
        return ret;
    }

    private void parseQueryParser(EasyNode el) {
        int j = 0;
        while (j < el.nAttrs()) {
            if (!el.attrName(j).equalsIgnoreCase("path")) {
                throw new GeneralException("Query router attribute " + el.name() + "." + el.attrName(j) + " not recognized");
            }
            this.queryParserSheet = el.attrValue(j);
            ++j;
        }
    }

    private void parseErrorGen(EasyNode el) {
        int j = 0;
        while (j < el.nAttrs()) {
            if (!el.attrName(j).equalsIgnoreCase("path")) {
                throw new GeneralException("Query router attribute " + el.name() + "." + el.attrName(j) + " not recognized");
            }
            this.errorGenSheet = el.attrValue(j);
            ++j;
        }
    }

    private void parseTokenizer(EasyNode el) {
        String paramName = null;
        String tokenizer = null;
        int j = 0;
        while (j < el.nAttrs()) {
            if (el.attrName(j).equalsIgnoreCase("param")) {
                paramName = el.attrValue(j);
            } else if (el.attrName(j).equalsIgnoreCase("tokenizer")) {
                tokenizer = el.attrValue(j);
            } else {
                throw new GeneralException("Query router attribute " + el.name() + "." + el.attrName(j) + " not recognized");
            }
            ++j;
        }
        if (paramName == null || tokenizer == null) {
            throw new GeneralException(String.valueOf(el.name()) + " element requires 'param' and 'tokenizer' attributes to be specified");
        }
        this.tokenizerMap.put(paramName, tokenizer);
    }
}

