/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.cache;

import org.cdlib.xtf.cache.Cache;
import org.cdlib.xtf.cache.Dependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeneratingCache<K, V>
extends Cache<K, V> {
    private Cache.ListEntry curEntry;

    public GeneratingCache(int maxEntries, int maxTime) {
        super(maxEntries, maxTime);
    }

    public synchronized V find(K key) throws Exception {
        if (this.has(key)) {
            Cache.ListEntry entry = (Cache.ListEntry)this.keyMap.get(key);
            return entry.value;
        }
        this.curEntry = new Cache.ListEntry();
        this.curEntry.key = key;
        this.curEntry.value = this.generate(key);
        this.curEntry.lastUsedTime = this.curEntry.setTime = System.currentTimeMillis();
        this.ageList.addTail(this.curEntry);
        this.keyMap.put(key, this.curEntry);
        this.logAction("Generated", key, this.curEntry.value);
        Object value = this.curEntry.value;
        this.curEntry = null;
        this.cleanup();
        return value;
    }

    public void addDependency(Dependency d) {
        assert (this.curEntry != null) : "addDependency() may only be called from within generate()";
        this.curEntry.dependencies.add(d);
    }

    protected abstract V generate(K var1) throws Exception;
}

