/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.lucene.util.FileSorter;

public class FileSorterTest
extends TestCase {
    public void testSort() throws IOException {
        File tmpIn = File.createTempFile("FileSorterTest", ".in.tmp");
        File tmpOut = File.createTempFile("FileSorterTest", ".out.tmp");
        try {
            int i;
            int NLINES = 1000;
            int LINE_LENGTH = 50;
            String[] lines = new String[1000];
            BufferedWriter writer = new BufferedWriter(new FileWriter(tmpIn));
            try {
                StringBuffer buf = new StringBuffer();
                Random rand = new Random(1L);
                i = 0;
                while (i < 1000) {
                    buf.setLength(0);
                    int j = 0;
                    while (j < 50) {
                        buf.append((char)(rand.nextInt(96) + 32));
                        ++j;
                    }
                    lines[i] = buf.toString();
                    writer.write(lines[i]);
                    writer.write(10);
                    ++i;
                }
            }
            finally {
                writer.close();
            }
            FileSorter.sort(tmpIn, tmpOut, null, 15000);
            Object[] sortedLines = new String[1000];
            System.arraycopy(lines, 0, sortedLines, 0, 1000);
            Arrays.sort(sortedLines);
            BufferedReader reader = new BufferedReader(new FileReader(tmpOut));
            i = 0;
            while (i < 1000) {
                String line = reader.readLine();
                FileSorterTest.assertEquals((String)sortedLines[i], (String)line);
                ++i;
            }
        }
        finally {
            tmpIn.delete();
            tmpOut.delete();
        }
    }
}

