/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spelt;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.spelt.LuceneIndexToDictTest;
import org.apache.lucene.spelt.SpellReader;
import org.apache.lucene.spelt.SpellWriter;
import org.apache.lucene.spelt.SpellWritingAnalyzer;
import org.apache.lucene.store.RAMDirectory;

public class SpellWritingAnalyzerTest
extends LuceneIndexToDictTest {
    protected void setUp() throws Exception {
        this.createDictDir("LuceneIndexToDictTest");
        SpellWriter spellWriter = SpellWriter.open(this.dictDir);
        spellWriter.setStopwords(STOP_SET);
        spellWriter.setMinWordFreq(1);
        try {
            RAMDirectory luceneDir = new RAMDirectory();
            IndexWriter luceneWriter = new IndexWriter(luceneDir, (Analyzer)new SpellWritingAnalyzer(spellWriter));
            this.addParagraphDocs(luceneWriter);
            luceneWriter.close();
            spellWriter.flushQueuedWords();
            spellWriter.close();
            this.reader = SpellReader.open(this.dictDir);
            this.reader.setStopwords(STOP_SET);
        }
        finally {
            spellWriter.close();
        }
    }
}

