/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Vector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.limit.TermLimitException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.WildcardTermEnum;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.Spans;

public class SpanWildcardQuery
extends SpanTermQuery {
    private int termLimit;
    private static final int TERMS_TO_REPORT = 50;

    public SpanWildcardQuery(Term term) {
        this(term, Integer.MAX_VALUE);
    }

    public SpanWildcardQuery(Term term, int termLimit) {
        super(term);
        this.termLimit = termLimit;
    }

    public int getTermLimit() {
        return this.termLimit;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        StringBuffer termReport = new StringBuffer(100);
        WildcardTermEnum enumerator = new WildcardTermEnum(reader, this.getTerm());
        Vector<SpanTermQuery> termQueries = new Vector<SpanTermQuery>();
        try {
            int nTerms = 0;
            do {
                Term t;
                if ((t = enumerator.term()) == null || this.shouldSkipTerm(t)) continue;
                SpanTermQuery tq = new SpanTermQuery(t);
                tq.setBoost(this.getBoost() * enumerator.difference());
                termQueries.add(tq);
                if (nTerms < 50) {
                    termReport.append(t.text());
                    termReport.append(" ");
                }
                if (nTerms++ != this.termLimit) continue;
                throw new TermLimitException("Wildcard query on '" + this.getTerm().field() + "' matched too many terms (more than " + this.termLimit + "). First " + 50 + " matches: " + termReport.toString());
            } while (enumerator.next());
        }
        finally {
            enumerator.close();
        }
        SpanOrQuery orQuery = new SpanOrQuery(termQueries.toArray(new SpanQuery[0]));
        orQuery.setSpanRecording(this.getSpanRecording());
        return orQuery;
    }

    protected boolean shouldSkipTerm(Term t) {
        return false;
    }

    public Spans getSpans(IndexReader reader, Searcher searcher) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String toString(String field) {
        return "wild(" + super.toString(field) + ")";
    }
}

