/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.limit;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.limit.ExcessiveWorkException;
import org.apache.lucene.limit.LimTermDocs;
import org.apache.lucene.limit.LimTermPositions;
import org.apache.lucene.store.Directory;

public class LimIndexReader
extends IndexReader {
    private IndexReader wrapped;
    private int workLimit;
    private int workCount = 0;

    public LimIndexReader(IndexReader toWrap, int workLimit) {
        super(null);
        this.wrapped = toWrap;
        this.workLimit = workLimit;
    }

    protected void work(int amount) throws IOException {
        this.workCount += amount;
        if (this.workCount > this.workLimit) {
            throw new ExcessiveWorkException();
        }
    }

    public Document document(int n, FieldSelector fieldSelector) throws IOException {
        Document ret = this.wrapped.document(n, fieldSelector);
        this.work(ret.getFields().size());
        return ret;
    }

    public static long getCurrentVersion(File directory) throws IOException {
        return IndexReader.getCurrentVersion(directory);
    }

    public static long getCurrentVersion(String directory) throws IOException {
        return IndexReader.getCurrentVersion(directory);
    }

    public static long getCurrentVersion(Directory directory) throws IOException {
        return IndexReader.getCurrentVersion(directory);
    }

    public static boolean indexExists(File directory) {
        return IndexReader.indexExists(directory);
    }

    public static boolean indexExists(String directory) {
        return IndexReader.indexExists(directory);
    }

    public static boolean indexExists(Directory directory) throws IOException {
        return IndexReader.indexExists(directory);
    }

    public static boolean isLocked(String directory) throws IOException {
        return IndexReader.isLocked(directory);
    }

    public static boolean isLocked(Directory directory) throws IOException {
        return IndexReader.isLocked(directory);
    }

    public static IndexReader open(File path) throws IOException {
        assert (false) : "Method should never be called";
        throw new RuntimeException();
    }

    public static IndexReader open(String path) throws IOException {
        assert (false) : "Method should never be called";
        throw new RuntimeException();
    }

    public static IndexReader open(Directory directory) throws IOException {
        assert (false) : "Method should never be called";
        throw new RuntimeException();
    }

    public static void unlock(Directory directory) throws IOException {
        IndexReader.unlock(directory);
    }

    public Directory directory() {
        return this.wrapped.directory();
    }

    public int docFreq(Term t) throws IOException {
        return this.wrapped.docFreq(t);
    }

    public Document document(int n) throws IOException {
        return this.wrapped.document(n);
    }

    public boolean equals(Object obj) {
        return this.wrapped.equals(obj);
    }

    public TermFreqVector getTermFreqVector(int docNumber, String field) throws IOException {
        return this.wrapped.getTermFreqVector(docNumber, field);
    }

    public TermFreqVector[] getTermFreqVectors(int docNumber) throws IOException {
        return this.wrapped.getTermFreqVectors(docNumber);
    }

    public boolean hasDeletions() {
        return this.wrapped.hasDeletions();
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public boolean isDeleted(int n) {
        return this.wrapped.isDeleted(n);
    }

    public int maxDoc() {
        return this.wrapped.maxDoc();
    }

    public byte[] norms(String field) throws IOException {
        return this.wrapped.norms(field);
    }

    public void norms(String field, byte[] bytes, int offset) throws IOException {
        this.wrapped.norms(field, bytes, offset);
    }

    public int numDocs() {
        return this.wrapped.numDocs();
    }

    public void setNorm(int doc, String field, float value) throws IOException {
        this.wrapped.setNorm(doc, field, value);
    }

    public TermDocs termDocs() throws IOException {
        return new LimTermDocs(this, this.wrapped.termDocs());
    }

    public TermDocs termDocs(Term term) throws IOException {
        return new LimTermDocs(this, this.wrapped.termDocs(term));
    }

    public TermPositions termPositions() throws IOException {
        return new LimTermPositions(this, this.wrapped.termPositions());
    }

    public TermPositions termPositions(Term term) throws IOException {
        return new LimTermPositions(this, this.wrapped.termPositions(term));
    }

    public TermEnum terms() throws IOException {
        return this.wrapped.terms();
    }

    public TermEnum terms(Term t) throws IOException {
        return this.wrapped.terms(t);
    }

    public String toString() {
        return this.wrapped.toString();
    }

    protected void doClose() throws IOException {
        assert (false) : "method should never be called";
    }

    protected void doCommit() throws IOException {
        assert (false) : "method should never be called";
    }

    protected void doDelete(int docNum) throws IOException {
        assert (false) : "method should never be called";
    }

    protected void doSetNorm(int doc, String field, byte value) throws IOException {
        assert (false) : "method should never be called";
    }

    protected void doUndeleteAll() throws IOException {
        assert (false) : "method should never be called";
    }

    public Collection getFieldNames(IndexReader.FieldOption opt) {
        return this.wrapped.getFieldNames(opt);
    }

    public long getVersion() {
        return this.wrapped.getVersion();
    }

    public boolean hasNorms(String field) throws IOException {
        return this.wrapped.hasNorms(field);
    }

    public boolean isCurrent() throws IOException {
        return this.wrapped.isCurrent();
    }

    public boolean isOptimized() {
        return this.wrapped.isOptimized();
    }
}

