/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.xml.dom.traversal;

import org.apache.xindice.xml.dom.NodeImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public final class TreeWalkerImpl
implements TreeWalker,
NodeIterator {
    protected boolean valid = true;
    protected Node root;
    protected Node current;
    protected int whatToShow;
    protected NodeFilter filter;
    protected boolean expand;

    public TreeWalkerImpl(Node root, int whatToShow, NodeFilter filter, boolean entityReferenceExpansion) throws DOMException {
        this.root = root;
        this.current = root;
        this.whatToShow = whatToShow;
        this.filter = filter;
        this.expand = entityReferenceExpansion;
    }

    private int getShowType(Node node) {
        switch (node.getNodeType()) {
            case 2: {
                return 2;
            }
            case 4: {
                return 8;
            }
            case 8: {
                return 128;
            }
            case 11: {
                return 1024;
            }
            case 9: {
                return 256;
            }
            case 10: {
                return 512;
            }
            case 1: {
                return 1;
            }
            case 6: {
                return 32;
            }
            case 5: {
                return 16;
            }
            case 12: {
                return 2048;
            }
            case 7: {
                return 64;
            }
            case 3: {
                return 4;
            }
        }
        return 0;
    }

    private boolean acceptNode(Node node) {
        return (this.getShowType(node) & this.whatToShow) > 0 && (this.filter == null || this.filter.acceptNode(node) == 1);
    }

    public Node getRoot() {
        return this.root;
    }

    public int getWhatToShow() {
        return this.whatToShow;
    }

    public NodeFilter getFilter() {
        return this.filter;
    }

    public boolean getExpandEntityReferences() {
        return this.expand;
    }

    public void detach() {
        this.valid = false;
    }

    public Node getCurrentNode() {
        return this.current;
    }

    public void setCurrentNode(Node currentNode) throws DOMException {
        if (!this.valid) {
            throw NodeImpl.EX_INVALID_STATE;
        }
        if (currentNode == null) {
            throw new DOMException(9, "Current node can not be set to null.");
        }
        this.current = currentNode;
    }

    public Node parentNode() {
        Node node = this.current;
        while (node != null) {
            if (node == this.root) {
                return null;
            }
            if ((node = node.getParentNode()) == null) {
                return null;
            }
            if (!this.acceptNode(node)) continue;
            this.current = node;
            return this.current;
        }
        return null;
    }

    public Node firstChild() {
        Node node = this.current.getFirstChild();
        while (node != null) {
            if (this.acceptNode(node)) {
                this.current = node;
                return this.current;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public Node lastChild() {
        Node node = this.current.getLastChild();
        while (node != null) {
            if (this.acceptNode(node)) {
                this.current = node;
                return this.current;
            }
            node = node.getPreviousSibling();
        }
        return null;
    }

    public Node previousSibling() {
        Node node = this.current.getPreviousSibling();
        while (node != null) {
            if (this.acceptNode(node)) {
                this.current = node;
                return this.current;
            }
            node = node.getPreviousSibling();
        }
        return null;
    }

    public Node nextSibling() {
        Node node = this.current.getNextSibling();
        while (node != null) {
            if (this.acceptNode(node)) {
                this.current = node;
                return this.current;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public Node previousNode() {
        node = this.current;
        do {
            block3: {
                if ((tmp = node.getPreviousSibling()) != null) ** GOTO lbl9
                if (node == this.root) {
                    return null;
                }
                tmp = node.getParentNode();
                break block3;
lbl-1000:
                // 1 sources

                {
                    tmp = tmp.getLastChild();
lbl9:
                    // 2 sources

                    ** while (tmp.hasChildNodes())
                }
            }
            node = tmp;
            if (node != null) continue;
            return null;
        } while (!this.acceptNode(node));
        this.current = node;
        return this.current;
    }

    public Node nextNode() {
        Node node = this.current;
        block0: do {
            if (node.hasChildNodes()) {
                node = node.getFirstChild();
                continue;
            }
            do {
                Node old = node;
                if ((node = node.getNextSibling()) != null) continue block0;
                node = old;
            } while ((node = node.getParentNode()) != null && node != this.root);
            return null;
        } while (node == null || !this.acceptNode(node));
        this.current = node;
        return node;
    }
}

