/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.xindice.util.XindiceRuntimeException;

public class Value
implements Comparable {
    protected byte[] data;
    protected int pos;
    protected int len;
    private int hash;

    public Value(Value value) {
        this.data = value.data;
        this.pos = value.pos;
        this.len = value.len;
    }

    public Value(byte[] data) {
        this.data = data;
        this.pos = 0;
        this.len = data.length;
    }

    public Value(byte[] data, int pos, int len) {
        if (pos >= data.length || pos < 0 || pos + len > data.length) {
            throw new ArrayIndexOutOfBoundsException("Value cannot be created");
        }
        this.data = data;
        this.pos = pos;
        this.len = len;
    }

    public Value(String data) {
        try {
            this.data = data.getBytes("utf-8");
            this.pos = 0;
            this.len = this.data.length;
        }
        catch (UnsupportedEncodingException e) {
            throw new XindiceRuntimeException("Java doesn't support UTF-8 encoding", e);
        }
    }

    public final int getLength() {
        return this.len;
    }

    public final byte[] getData() {
        if (this.len != this.data.length) {
            byte[] b = new byte[this.len];
            System.arraycopy(this.data, this.pos, b, 0, this.len);
            return b;
        }
        return this.data;
    }

    public final Value getSubvalue(int start, int len) {
        return new Value(this.data, start, len);
    }

    public final byte byteAt(int index) {
        if (index < 0 || index >= this.len) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.data[this.pos + index];
    }

    public final boolean startsWith(Value value) {
        if (this.len < value.len) {
            return false;
        }
        byte[] ddata = value.data;
        int dpos = value.pos;
        int i = 0;
        while (i < value.len) {
            if (this.data[i + this.pos] != ddata[i + dpos]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final InputStream getInputStream() {
        return new ByteArrayInputStream(this.data, this.pos, this.len);
    }

    public final void streamTo(OutputStream out) throws IOException {
        out.write(this.data, this.pos, this.len);
    }

    public final void copyTo(byte[] tdata, int tpos) {
        System.arraycopy(this.data, this.pos, tdata, tpos, this.len);
    }

    public final void copyTo(byte[] tdata, int tpos, int len) {
        System.arraycopy(this.data, this.pos, tdata, tpos, len);
    }

    public final int compareTo(Value value) {
        byte[] ddata = value.data;
        int dpos = value.pos;
        int dlen = value.len;
        int stop = this.len > dlen ? dlen : this.len;
        int i = 0;
        while (i < stop) {
            byte b1 = this.data[this.pos + i];
            byte b2 = ddata[dpos + i];
            if (b1 != b2) {
                int s1 = b1 & 0xFF;
                int s2 = b2 & 0xFF;
                return s1 > s2 ? i + 1 : -(i + 1);
            }
            ++i;
        }
        if (this.len == dlen) {
            return 0;
        }
        return this.len > dlen ? stop + 1 : -(stop + 1);
    }

    public final int compareTo(Object obj) {
        if (obj instanceof Value) {
            return this.compareTo((Value)obj);
        }
        return this.compareTo(new Value(obj.toString()));
    }

    public boolean equals(Value value) {
        return this.len == value.len && this.compareTo(value) == 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Value) {
            return this.equals((Value)obj);
        }
        return obj != null && this.equals(new Value(obj.toString()));
    }

    public int hashCode() {
        if (this.hash == 0) {
            int tempHash = 0;
            int i = 0;
            while (i < this.len) {
                tempHash = 31 * tempHash + this.data[this.pos + i];
                ++i;
            }
            this.hash = Math.abs(tempHash);
        }
        return this.hash;
    }

    public final String toString() {
        try {
            return new String(this.data, this.pos, this.len, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new XindiceRuntimeException("Java doesn't seem to support UTF-8!", e);
        }
    }
}

