/*
 * Decompiled with CFR 0.152.
 */
package org.textmining.extraction.word.model;

import java.util.List;
import org.textmining.extraction.word.model.CHPX;
import org.textmining.extraction.word.model.PropertyNode;
import org.textmining.extraction.word.model.TextPiece;
import org.textmining.extraction.word.model.TextPieceTable;

public class NodeHelper {
    List _textPieces;
    int _lastTxtPiece;
    int _fcMin;

    public NodeHelper(TextPieceTable textPieceTable) {
        this._textPieces = textPieceTable.getTextPieces();
        this._fcMin = ((TextPiece)this._textPieces.get(0)).getPieceDescriptor().getFilePosition();
        this._lastTxtPiece = 0;
    }

    private boolean setCpRange(PropertyNode propertyNode) {
        int n = Math.max(propertyNode.getStart(), this._fcMin);
        int n2 = propertyNode.getEnd();
        while (this._lastTxtPiece < this._textPieces.size()) {
            TextPiece textPiece = (TextPiece)this._textPieces.get(this._lastTxtPiece);
            int n3 = textPiece.getFcStart();
            int n4 = textPiece.getFcEnd();
            if (n >= n3 && n < n4) {
                int n5 = textPiece.unicode() ? 2 : 1;
                int n6 = textPiece.getStart() + (n - n3) / n5;
                int n7 = n6 + (n2 - n) / n5;
                propertyNode.setStart(n6);
                propertyNode.setEnd(n7);
                return true;
            }
            ++this._lastTxtPiece;
        }
        return false;
    }

    public void addChpNodes(List list, byte[] byArray, int n, int n2) {
        CHPX cHPX = new CHPX(n, n2, byArray);
        if (this.setCpRange(cHPX)) {
            list.add(cHPX);
        }
    }

    public void sortNodes(List list, boolean bl) {
    }
}

