/*
 * Decompiled with CFR 0.152.
 */
package org.textmining.extraction.word.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.util.LittleEndian;
import org.textmining.extraction.word.model.CHPX;
import org.textmining.extraction.word.model.FormattedDiskPage;
import org.textmining.extraction.word.model.NodeHelper;
import org.textmining.extraction.word.model.PropertyNode;

public class CHPFormattedDiskPage
extends FormattedDiskPage {
    private static final int FC_SIZE = 4;
    private ArrayList _chpxList = new ArrayList();
    private ArrayList _overFlow;

    public CHPFormattedDiskPage() {
    }

    public CHPFormattedDiskPage(byte[] byArray, int n, int n2, NodeHelper nodeHelper) {
        super(byArray, n, nodeHelper);
        for (int i = 0; i < this._crun; ++i) {
            nodeHelper.addChpNodes(this._chpxList, this.getGrpprl(i), this.getStart(i), this.getEnd(i));
        }
    }

    public CHPX getCHPX(int n) {
        return (CHPX)this._chpxList.get(n);
    }

    public void fill(List list) {
        this._chpxList.addAll(list);
    }

    public void fill(ArrayList arrayList, int n) {
        this._chpxList = arrayList;
        this._currentIndex = n;
    }

    public int getEndIndex() {
        return this._currentIndex;
    }

    public ArrayList getOverflow() {
        return this._overFlow;
    }

    protected byte[] getGrpprl(int n) {
        int n2 = 2 * LittleEndian.getUnsignedByte((byte[])this._fkp, (int)(this._offset + ((this._crun + 1) * 4 + n)));
        if (n2 == 0) {
            return new byte[0];
        }
        int n3 = LittleEndian.getUnsignedByte((byte[])this._fkp, (int)(this._offset + n2));
        byte[] byArray = new byte[n3];
        System.arraycopy(this._fkp, this._offset + ++n2, byArray, 0, n3);
        return byArray;
    }

    public byte[] toByteArray(int n) {
        int n2;
        byte[] byArray = new byte[512];
        int n3 = this._chpxList.size();
        int n4 = 511;
        int n5 = 0;
        int n6 = 0;
        int n7 = 6;
        for (n2 = this._currentIndex; n2 < n3; ++n2) {
            int n8 = ((CHPX)this._chpxList.get(n2)).getGrpprl().length;
            if ((n7 += 6 + n8) > 511 + n2 % 2) {
                n7 -= 6 + n8;
                break;
            }
            if ((1 + n8) % 2 <= 0) continue;
            ++n7;
        }
        this._currentIndex = n2;
        byArray[511] = (byte)n2;
        n5 = 4 * n2 + 4;
        PropertyNode propertyNode = null;
        for (int i = 0; i < n2; ++i) {
            propertyNode = (CHPX)this._chpxList.get(i);
            byte[] byArray2 = ((CHPX)propertyNode).getGrpprl();
            LittleEndian.putInt((byte[])byArray, (int)n6, (int)(propertyNode.getStart() + n));
            n4 -= 1 + byArray2.length;
            n4 -= n4 % 2;
            byArray[n5] = (byte)(n4 / 2);
            byArray[n4] = (byte)byArray2.length;
            System.arraycopy(byArray2, 0, byArray, n4 + 1, byArray2.length);
            ++n5;
            n6 += 4;
        }
        LittleEndian.putInt((byte[])byArray, (int)n6, (int)(propertyNode.getEnd() + n));
        return byArray;
    }

    public int size() {
        return this._chpxList.size();
    }
}

