/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.dbxml;

import com.sleepycat.dbxml.HelperFunctions;
import com.sleepycat.dbxml.XmlEventReader;
import com.sleepycat.dbxml.XmlEventWriter;
import com.sleepycat.dbxml.XmlException;
import com.sleepycat.dbxml.XmlInputStream;
import com.sleepycat.dbxml.XmlInputStreamWrap;
import com.sleepycat.dbxml.XmlManager;
import com.sleepycat.dbxml.XmlMetaData;
import com.sleepycat.dbxml.XmlMetaDataIterator;
import com.sleepycat.dbxml.XmlResults;
import com.sleepycat.dbxml.XmlTransaction;
import com.sleepycat.dbxml.XmlValue;
import com.sleepycat.dbxml.dbxml_javaJNI;
import java.io.InputStream;
import java.util.Vector;

public class XmlDocument {
    protected Vector metaData;
    protected long docID;
    protected int cid;
    protected Content content;
    protected XmlManager manager;
    protected XmlTransaction txn;
    protected XmlResults results;
    private long eventWriter;
    public static final int NONE = 0;
    public static final int DBT = 1;
    public static final int INPUTSTREAM = 2;
    public static final int DOM = 4;
    public static final int READER = 8;
    public static final int VALIDATE = 1;
    public static final int DONT_VALIDATE = 2;
    public static final int WF_ONLY = 3;

    public XmlDocument() {
        this.metaData = new Vector();
        this.docID = 0L;
        this.cid = 0;
        this.content = new Content();
    }

    public XmlDocument(XmlDocument o) throws XmlException {
        this.docID = o.docID;
        this.cid = o.cid;
        this.metaData = new Vector(o.metaData);
        this.content = new Content(o.content);
    }

    public void delete() {
    }

    public void setContentAsEventReader(XmlEventReader reader) throws XmlException {
        this.content.setContentAsEventReader(reader);
    }

    public InputStream getContentAsInputStream() throws XmlException {
        return new XmlInputStreamWrap(this.getContentAsXmlInputStream());
    }

    public void setContentAsXmlInputStream(XmlInputStream adopted) throws XmlException {
        this.content.setContentAsXmlInputStream(adopted);
    }

    public boolean getMetaData(String uri, String name, XmlValue value) throws XmlException {
        for (int i = 0; i < this.metaData.size(); ++i) {
            XmlMetaData data = (XmlMetaData)this.metaData.get(i);
            if (!uri.matches(data.get_uri()) || !name.matches(data.get_name()) || data.get_removed()) continue;
            XmlValue.setValue(value, data.get_value());
            return true;
        }
        XmlValue returned = HelperFunctions.getMetaData(uri, name, this);
        if (!returned.isNull()) {
            XmlValue.setValue(value, returned);
            return true;
        }
        return false;
    }

    public void setName(String name) throws XmlException {
        String newName = name;
        if (newName == null) {
            newName = "";
        }
        XmlValue value = new XmlValue(newName);
        this.setMetaData("http://www.sleepycat.com/2002/dbxml", "name", value);
    }

    public String getName() throws XmlException {
        XmlValue value = new XmlValue();
        boolean exists = this.getMetaData("http://www.sleepycat.com/2002/dbxml", "name", value);
        if (exists) {
            return value.asString();
        }
        return "";
    }

    public void setContent(String content) throws XmlException {
        this.content.setContent(content);
    }

    public void setContent(byte[] content) throws XmlException {
        this.content.setContent(content);
    }

    public XmlInputStream getContentAsXmlInputStream() throws XmlException {
        if (this.content.isStream()) {
            XmlInputStream ins = this.content.getXmlInputStream();
            this.content.stream = null;
            this.content.type = 0;
            return ins;
        }
        if (!this.content.hasContent() && this.docID == 0L) {
            return null;
        }
        return HelperFunctions.getContentAsXmlInputStream(this);
    }

    public XmlEventReader getContentAsEventReader() throws XmlException {
        if (this.content.isReader()) {
            XmlEventReader xer = this.content.getEventReader();
            this.content.reader = null;
            this.content.type = 0;
            return xer;
        }
        if (!this.content.hasContent() && this.docID == 0L) {
            return null;
        }
        return HelperFunctions.getContentAsEventReader(this);
    }

    public void getContentAsEventWriter(XmlEventWriter writer) throws XmlException {
        try {
            HelperFunctions.getContentAsEventWriter(this, writer);
        }
        catch (XmlException e) {
            writer.release();
            throw e;
        }
        writer.release();
    }

    public void fetchAllData() throws XmlException {
        this.materializeMetaData();
        this.getContent();
    }

    public void setMetaData(String uri, String name, XmlValue value) throws XmlException {
        this.addMetaData(uri, name, value, true, false);
    }

    public void removeMetaData(String uri, String name) throws XmlException {
        XmlValue temp = new XmlValue("x");
        this.addMetaData(uri, name, temp, false, true);
    }

    public void setMetaData(String uri, String name, byte[] value) throws XmlException {
        XmlValue data = new XmlValue(40, value);
        this.addMetaData(uri, name, data, true, false);
    }

    public String getContentAsString() throws XmlException {
        if (this.content.isDBT()) {
            return this.content.getString();
        }
        if (!this.content.hasContent() && this.docID == 0L) {
            return "";
        }
        String results = HelperFunctions.getContentAsString(this);
        this.content.setContent(results);
        return results;
    }

    public byte[] getContent() throws XmlException {
        if (this.content.isDBT()) {
            return this.content.getDBT();
        }
        if (!this.content.hasContent() && this.docID == 0L) {
            byte[] empty = new byte[]{};
            return empty;
        }
        byte[] results = HelperFunctions.getContent(this);
        this.content.setContent(results);
        return results;
    }

    public byte[] getMetaData(String uri, String name) throws XmlException {
        XmlValue data = new XmlValue();
        if (this.getMetaData(uri, name, data)) {
            if (data.isBinary()) {
                return data.asBinary();
            }
            return data.asString().getBytes();
        }
        return null;
    }

    public XmlMetaDataIterator getMetaDataIterator() throws XmlException {
        this.materializeMetaData();
        return new XmlMetaDataIterator(this);
    }

    public boolean equals(XmlDocument other) throws XmlException {
        if (this.docID != 0L && this.docID == other.docID && this.cid == other.cid) {
            return true;
        }
        return this.docID == 0L && other.docID == 0L && this.content == this.content && this.metaData == other.metaData;
    }

    protected void addMetaData(String uri, String name, XmlValue value, boolean modified, boolean removed) throws XmlException {
        XmlMetaData data = null;
        for (int i = 0; i < this.metaData.size(); ++i) {
            data = (XmlMetaData)this.metaData.get(i);
            if (!uri.matches(data.get_uri()) || !name.matches(data.get_name())) continue;
            if (modified || removed) {
                data.set_modified(modified);
                data.set_removed(removed);
                data.set_value(value);
            }
            return;
        }
        data = new XmlMetaData(uri, name, value);
        if (modified || removed) {
            data.set_modified(modified);
            data.set_removed(removed);
        }
        this.metaData.add(data);
    }

    protected XmlMetaData getMetaData(int index) {
        if (index >= this.metaData.size()) {
            return null;
        }
        return (XmlMetaData)this.metaData.get(index);
    }

    protected void materializeMetaData() throws XmlException {
        if (this.docID != 0L) {
            dbxml_javaJNI.materializeMetaData(this);
        }
    }

    protected XmlDocument(long documentId, int containerId) {
        this.metaData = new Vector();
        this.docID = documentId;
        this.cid = containerId;
        this.content = new Content();
    }

    protected void finalize() throws XmlException {
        this.metaData.clear();
        this.content.clear();
    }

    protected void copy(XmlDocument o) throws XmlException {
        this.docID = o.docID;
        this.cid = o.cid;
        this.content.clear();
        this.content = new Content(o.content);
        this.metaData.clear();
        this.metaData = new Vector(o.metaData);
        this.results = o.results;
        this.manager = o.manager;
        this.txn = o.txn;
    }

    protected void copyID(XmlDocument o) throws XmlException {
        this.docID = o.docID;
        this.cid = o.cid;
        this.results = null;
        this.manager = null;
        this.txn = null;
        this.content.clear();
        this.metaData.clear();
    }

    protected void clearID() throws XmlException {
        this.docID = 0L;
        this.cid = 0;
    }

    protected void clearContent() throws XmlException {
        this.content.clear();
    }

    protected long getResultPtr() throws XmlException {
        return XmlResults.getCPtr(this.results);
    }

    protected long getManagerPtr() {
        return XmlManager.getCPtr(this.manager);
    }

    protected long getTransactionPtr() {
        return XmlTransaction.getCPtr(this.txn);
    }

    protected long getEventReaderPtr() throws XmlException {
        long ptr = XmlEventReader.getCPtr(this.content.getEventReader());
        this.content.reader.release();
        this.content.reader = null;
        this.content.type = 0;
        return ptr;
    }

    protected long getInputStreamPtr() throws XmlException {
        long ptr = XmlInputStream.getCPtr(this.content.getXmlInputStream());
        this.content.stream = null;
        this.content.type = 0;
        return ptr;
    }

    protected long getEventWriterPtr() {
        return this.eventWriter;
    }

    protected byte[] getDBT() {
        return this.content.dbt;
    }

    protected long getId() {
        return this.docID;
    }

    protected int getCid() {
        return this.cid;
    }

    protected int getType() {
        return this.content.type;
    }

    protected void setManager(XmlManager mgr) {
        this.manager = mgr;
    }

    protected void setTransaction(XmlTransaction transaction) {
        this.txn = transaction;
    }

    protected void setResults(XmlResults result) {
        this.results = result;
    }

    protected void setEventWriter(long writer) {
        this.eventWriter = writer;
    }

    class Content {
        public XmlEventReader reader;
        public XmlInputStream stream;
        public byte[] dbt;
        public int type;

        public Content() {
            this.type = 0;
        }

        public Content(Content c) {
            this.type = c.type;
            this.reader = c.reader;
            this.stream = c.stream;
            this.dbt = c.dbt;
        }

        protected void clear() throws XmlException {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            if (this.stream != null) {
                this.stream.delete();
                this.stream = null;
            }
            if (this.dbt != null) {
                this.dbt = null;
            }
            this.type = 0;
        }

        public boolean hasContent() {
            return this.type != 0;
        }

        public boolean isStream() {
            return this.type == 2;
        }

        public boolean isReader() {
            return this.type == 8;
        }

        public boolean isDBT() {
            return this.type == 1;
        }

        public void setContentAsEventReader(XmlEventReader rdr) throws XmlException {
            this.clear();
            this.type = 8;
            this.reader = rdr;
        }

        public void setContentAsXmlInputStream(XmlInputStream adopted) throws XmlException {
            this.clear();
            this.type = 2;
            this.stream = adopted;
        }

        public void setContent(String content) throws XmlException {
            this.clear();
            this.type = 1;
            this.dbt = content.getBytes();
        }

        public void setContent(byte[] content) throws XmlException {
            this.clear();
            this.type = 1;
            this.dbt = content;
        }

        public XmlEventReader getEventReader() {
            return this.reader;
        }

        public XmlInputStream getXmlInputStream() {
            return this.stream;
        }

        public byte[] getDBT() {
            return this.dbt;
        }

        public String getString() {
            return new String(this.dbt);
        }
    }
}

