/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.DefaultTabDataModel;
import org.netbeans.swing.tabcontrol.LocationInformer;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.TabDisplayerUI;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.netbeans.swing.tabcontrol.plaf.ToolbarTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.WinClassicEditorTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.WinClassicViewTabDisplayerUI;

public final class TabDisplayer
extends JComponent
implements MouseMotionListener {
    private boolean initialized = false;
    private TabDataModel model;
    private SingleSelectionModel sel = null;
    private boolean active;
    private final int type;
    public static final Object ORIENTATION_EAST = "east";
    public static final Object ORIENTATION_WEST = "west";
    public static final Object ORIENTATION_NORTH = "north";
    public static final Object ORIENTATION_SOUTH = "south";
    public static final Object ORIENTATION_CENTER = "center";
    private transient List actionListenerList;
    private LocationInformer locationInformer = null;

    public TabDisplayer() {
        this(new DefaultTabDataModel(), 0);
    }

    public TabDisplayer(TabDataModel tabDataModel, int n) {
        this(tabDataModel, n, null);
    }

    public TabDisplayer(TabDataModel tabDataModel, int n, LocationInformer locationInformer) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown UI type: " + n);
            }
        }
        this.model = tabDataModel;
        this.type = n;
        this.locationInformer = locationInformer;
        this.putClientProperty("orientation", ORIENTATION_NORTH);
        this.initialized = true;
        this.updateUI();
        this.setFocusable(false);
    }

    public final TabDisplayerUI getUI() {
        return (TabDisplayerUI)this.ui;
    }

    public final void updateUI() {
        if (!this.initialized) {
            return;
        }
        if (this.type == 3) {
            this.setUI(new ToolbarTabDisplayerUI(this));
            return;
        }
        ComponentUI componentUI = null;
        if (UIManager.get(this.getUIClassID()) != null) {
            try {
                componentUI = UIManager.getUI(this);
            }
            catch (Error error) {
                System.err.println("Could not load a UI for " + this.getUIClassID() + " - missing class?");
            }
        }
        if (componentUI == null) {
            componentUI = this.getType() == 0 ? WinClassicViewTabDisplayerUI.createUI(this) : WinClassicEditorTabDisplayerUI.createUI(this);
        }
        this.setUI((TabDisplayerUI)componentUI);
    }

    public String getUIClassID() {
        switch (this.getType()) {
            case 0: {
                return "ViewTabDisplayerUI";
            }
            case 1: {
                return "EditorTabDisplayerUI";
            }
            case 2: {
                return "SlidingTabDisplayerUI";
            }
            case 3: {
                return "ToolbarTabDisplayerUI";
            }
        }
        throw new IllegalArgumentException("Unknown UI type: " + this.getType());
    }

    public final int getType() {
        return this.type;
    }

    public final Dimension getPreferredSize() {
        return this.getUI().getPreferredSize(this);
    }

    public final Dimension getMinimumSize() {
        return this.getUI().getMinimumSize(this);
    }

    void setSelectionModel(SingleSelectionModel singleSelectionModel) {
        this.sel = singleSelectionModel;
    }

    public SingleSelectionModel getSelectionModel() {
        return this.sel;
    }

    public final TabDataModel getModel() {
        return this.model;
    }

    public final void setActive(boolean bl) {
        if (bl != this.active) {
            this.active = bl;
            this.firePropertyChange("active", !bl, bl);
        }
    }

    public final boolean isActive() {
        return this.active;
    }

    public final String getToolTipText(MouseEvent mouseEvent) {
        if (this.ui != null) {
            int n;
            Point point = mouseEvent.getPoint();
            if (mouseEvent.getSource() != this) {
                Component component = (Component)mouseEvent.getSource();
                point = SwingUtilities.convertPoint(component, point, this);
            }
            if ((n = this.getUI().tabForCoordinate(point)) != -1) {
                return this.getModel().getTab((int)n).tip;
            }
        }
        return super.getToolTipText(mouseEvent);
    }

    public final void makeTabVisible(int n) {
        this.getUI().makeTabVisible(n);
    }

    public final Rectangle getTabRect(int n, Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        this.getUI().getTabRect(n, rectangle);
        return rectangle;
    }

    public final Image getDragImage(int n) {
        return this.getUI().createImageOfTab(n);
    }

    public final synchronized void addActionListener(ActionListener actionListener) {
        if (this.actionListenerList == null) {
            this.actionListenerList = new ArrayList();
        }
        this.actionListenerList.add(actionListener);
    }

    public final synchronized void removeActionListener(ActionListener actionListener) {
        if (this.actionListenerList != null) {
            this.actionListenerList.remove(actionListener);
        }
    }

    public String getCommandAtPoint(Point point) {
        return this.getUI().getCommandAtPoint(point);
    }

    public void registerShortcuts(JComponent jComponent) {
        this.getUI().registerShortcuts(jComponent);
    }

    public void unregisterShortcuts(JComponent jComponent) {
        this.getUI().unregisterShortcuts(jComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void postActionEvent(TabActionEvent tabActionEvent) {
        List list;
        TabDisplayer tabDisplayer = this;
        synchronized (tabDisplayer) {
            if (this.actionListenerList == null) {
                return;
            }
            list = Collections.unmodifiableList(this.actionListenerList);
        }
        for (int i = 0; i < list.size(); ++i) {
            ((ActionListener)list.get(i)).actionPerformed(tabActionEvent);
        }
    }

    public int tabForCoordinate(Point point) {
        return this.getUI().tabForCoordinate(point);
    }

    public LocationInformer getLocationInformer() {
        return this.locationInformer;
    }

    public void addNotify() {
        super.addNotify();
        this.addMouseMotionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeMouseMotionListener(this);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.tabForCoordinate(mouseEvent.getPoint());
        if (n != -1) {
            TabData tabData = this.model.getTab(n);
            this.setToolTipText(tabData.tip);
        } else {
            this.setToolTipText(null);
        }
    }
}

