/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.aqua;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;
import org.netbeans.swing.plaf.aqua.AquaToolBarButtonUI;
import org.netbeans.swing.plaf.util.UIUtils;

public class PlainAquaToolbarUI
extends BasicToolBarUI
implements ContainerListener {
    private static final AquaTbBorder aquaborder = new AquaTbBorder();
    private static final Color UPPER_GRADIENT_TOP = new Color(255, 255, 255);
    private static final Color UPPER_GRADIENT_BOTTOM = new Color(228, 230, 232);
    private static final Color LOWER_GRADIENT_TOP = new Color(228, 227, 215);
    private static final Color LOWER_GRADIENT_BOTTOM = new Color(249, 249, 249);
    private static final ButtonUI buttonui = new AquaToolBarButtonUI();

    public static ComponentUI createUI(JComponent jComponent) {
        return new PlainAquaToolbarUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        UIManager.put("Nb.Editor.Toolbar.border", aquaborder);
        jComponent.setBorder(aquaborder);
        jComponent.setOpaque(true);
        jComponent.addContainerListener(this);
        this.installButtonUIs(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        jComponent.setBorder(null);
        jComponent.removeContainerListener(this);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Object object;
        UIUtils.configureRenderingHints(graphics);
        Color color = graphics.getColor();
        Dimension dimension = jComponent.getSize();
        Shape shape = aquaborder.getInteriorShape(dimension.width, dimension.height);
        Shape shape2 = graphics.getClip();
        if (shape2 != null) {
            object = new Area(shape2);
            ((Area)object).intersect(new Area(shape));
            graphics.setClip((Shape)object);
        } else {
            graphics.setClip(shape);
        }
        object = (Graphics2D)graphics;
        ((Graphics2D)object).setPaint(aquaborder.getUpperPaint(dimension.width, dimension.height));
        ((Graphics2D)object).fill(aquaborder.getUpperBevelShape(dimension.width, dimension.height));
        ((Graphics2D)object).setPaint(aquaborder.getLowerPaint(dimension.width, dimension.height));
        ((Graphics2D)object).fill(aquaborder.getLowerBevelShape(dimension.width, dimension.height));
        graphics.setClip(shape2);
        graphics.setColor(color);
    }

    protected Border createRolloverBorder() {
        return BorderFactory.createEmptyBorder(2, 2, 2, 2);
    }

    protected Border createNonRolloverBorder() {
        return this.createRolloverBorder();
    }

    private Border createNonRolloverToggleBorder() {
        return this.createRolloverBorder();
    }

    protected void setBorderToRollover(Component component) {
        if (component instanceof AbstractButton) {
            ((AbstractButton)component).setBorderPainted(false);
            ((AbstractButton)component).setBorder(BorderFactory.createEmptyBorder());
            ((AbstractButton)component).setContentAreaFilled(false);
            ((AbstractButton)component).setOpaque(false);
        }
        if (component instanceof JComponent) {
            ((JComponent)component).setOpaque(false);
        }
    }

    protected void setBorderToNormal(Component component) {
        if (component instanceof AbstractButton) {
            ((AbstractButton)component).setBorderPainted(false);
            ((AbstractButton)component).setContentAreaFilled(false);
            ((AbstractButton)component).setOpaque(false);
        }
        if (component instanceof JComponent) {
            ((JComponent)component).setOpaque(false);
        }
    }

    public void setFloating(boolean bl, Point point) {
    }

    private void installButtonUI(Component component) {
        if (component instanceof AbstractButton) {
            ((AbstractButton)component).setUI(buttonui);
        }
        if (component instanceof JComponent) {
            ((JComponent)component).setOpaque(false);
        }
    }

    private void installButtonUIs(Container container) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            this.installButtonUI(componentArray[i]);
        }
    }

    public void componentAdded(ContainerEvent containerEvent) {
        this.installButtonUI(containerEvent.getChild());
        Container container = (Container)containerEvent.getSource();
        if ("editorToolbar".equals(container.getName())) {
            Dimension dimension = new Dimension(32, 34);
            ((JComponent)containerEvent.getContainer()).setPreferredSize(dimension);
        }
    }

    public void componentRemoved(ContainerEvent containerEvent) {
    }

    private static boolean isFinderLook(Component component) {
        if (component instanceof JComponent) {
            return Boolean.TRUE.equals(((JComponent)component).getClientProperty("finderLook"));
        }
        return false;
    }

    private static Color mezi(Color color, Color color2) {
        return new Color((color.getRed() + color2.getRed()) / 2, (color.getGreen() + color2.getGreen()) / 2, (color.getBlue() + color2.getBlue()) / 2);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        JToolBar jToolBar = new JToolBar();
        jToolBar.setUI(new PlainAquaToolbarUI());
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)jToolBar, "North");
        JButton jButton = new JButton("Some button");
        jToolBar.add(jButton);
        JButton jButton2 = new JButton("Another button");
        jToolBar.add(jButton2);
        jFrame.setBounds(20, 20, 400, 300);
        JTextArea jTextArea = new JTextArea("Foodbar");
        jFrame.getContentPane().add((Component)jTextArea, "South");
        jFrame.show();
    }

    private static class AquaTbBorder
    implements Border {
        int arcsize = 13;

        private AquaTbBorder() {
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(2, 4, 0, 0);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            UIUtils.configureRenderingHints(graphics);
            boolean bl = PlainAquaToolbarUI.isFinderLook(component);
            Color color = bl ? PlainAquaToolbarUI.mezi(UIManager.getColor("controlShadow"), UIManager.getColor("control")) : UIManager.getColor("controlShadow");
            graphics.setColor(color);
            int n5 = n2 += 2;
            this.drawUpper(graphics, n, n2, n5, n3, n4 -= 2);
            graphics.setColor(PlainAquaToolbarUI.mezi(color, UIManager.getColor("control")));
            if (bl) {
                this.drawUpper(graphics, n + 1, n2, n5 + 1, n3 - 2, n4 - 1);
            }
            if (bl) {
                color = PlainAquaToolbarUI.mezi(UIManager.getColor("controlShadow"), UIManager.getColor("control"));
            }
            if (bl) {
                this.drawLower(graphics, n, n2, n3, n4, color, bl);
            } else {
                this.drawLower(graphics, n, n2 - 1, n3, n4, color, bl);
                graphics.setColor(new Color(200, 200, 200));
                graphics.drawLine(n + this.arcsize / 2 - 3, n2 + n4 - 1, n + n3 - this.arcsize / 2, n2 + n4 - 1);
            }
        }

        private void drawLower(Graphics graphics, int n, int n2, int n3, int n4, Color color, boolean bl) {
            graphics.setColor(color);
            graphics.drawLine(n, n2 + this.arcsize / 2, n, n2 + n4 - this.arcsize / 2);
            graphics.drawLine(n + n3 - 1, n2 + this.arcsize / 2, n + n3 - 1, n2 + n4 - this.arcsize / 2);
            if (!bl) {
                graphics.setColor(new Color(220, 220, 220));
                graphics.drawArc(n - 1, n2 + 1 + n4 - this.arcsize, this.arcsize, this.arcsize, 180, 90);
                graphics.drawArc(n + 1 + n3 - (this.arcsize + 1), n2 + 1 + n4 - (this.arcsize + 1), this.arcsize, this.arcsize, 270, 90);
                graphics.setColor(color);
            }
            graphics.drawArc(n, n2 + n4 - this.arcsize, this.arcsize, this.arcsize, 180, 90);
            graphics.drawArc(n + n3 - (this.arcsize + 1), n2 + n4 - (this.arcsize + 1), this.arcsize, this.arcsize, 270, 90);
            if (!bl) {
                graphics.setColor(new Color(80, 80, 80));
            }
            graphics.drawLine(n + this.arcsize / 2 - 3, n2 + n4 - 1, n + n3 - this.arcsize / 2, n2 + n4 - 1);
        }

        private void drawUpper(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            graphics.drawArc(n, n3, this.arcsize, this.arcsize, 90, 90);
            graphics.drawArc(n + n4 - (this.arcsize + 1), n3, this.arcsize, this.arcsize, 90, -90);
            graphics.drawLine(n + this.arcsize / 2, n3, n + n4 - this.arcsize / 2, n3);
        }

        Paint getUpperPaint(Color color, Color color2, int n, int n2) {
            GradientPaint gradientPaint = UIUtils.getGradientPaint(0.0f, n2 / 4, color, 0.0f, n2 / 2 + n2 / 4, color2, false);
            return gradientPaint;
        }

        Paint getLowerPaint(Color color, Color color2, int n, int n2) {
            GradientPaint gradientPaint = UIUtils.getGradientPaint(0.0f, n2 / 2, color, 0.0f, n2 / 2 + n2 / 4, color2, false);
            return gradientPaint;
        }

        Paint getUpperPaint(int n, int n2) {
            return this.getUpperPaint(UPPER_GRADIENT_TOP, UPPER_GRADIENT_BOTTOM, n, n2);
        }

        Paint getLowerPaint(int n, int n2) {
            return this.getLowerPaint(LOWER_GRADIENT_TOP, LOWER_GRADIENT_BOTTOM, n, n2);
        }

        Shape getInteriorShape(int n, int n2) {
            RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, n, n2, this.arcsize, this.arcsize);
            return double_;
        }

        Shape getUpperBevelShape(int n, int n2) {
            int[] nArray = new int[]{0, 0, n2 / 2, n - n2 / 4, n, n, 0};
            int[] nArray2 = new int[]{0, n2 - n2 / 4, n2 / 2, n2 / 2, n2 / 4, 0, 0};
            Polygon polygon = new Polygon(nArray, nArray2, nArray2.length);
            return polygon;
        }

        Shape getLowerBevelShape(int n, int n2) {
            int[] nArray = new int[]{0, 0, n2 / 4, n - n2 / 4, n, n, 0};
            int[] nArray2 = new int[]{n2, n2 - n2 / 4, n2 / 2, n2 / 2, n2 / 4, n2, n2};
            Polygon polygon = new Polygon(nArray, nArray2, nArray2.length);
            return polygon;
        }
    }
}

