/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.http;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemConfigBuilder;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.UserAuthenticationData;
import org.apache.commons.vfs.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.provider.http.HttpClientFactory;
import org.apache.commons.vfs.provider.http.HttpFileNameParser;
import org.apache.commons.vfs.provider.http.HttpFileSystem;
import org.apache.commons.vfs.provider.http.HttpFileSystemConfigBuilder;
import org.apache.commons.vfs.util.UserAuthenticatorUtils;

public class HttpFileProvider
extends AbstractOriginatingFileProvider {
    static final Collection capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.GET_TYPE, Capability.READ_CONTENT, Capability.URI, Capability.GET_LAST_MODIFIED, Capability.ATTRIBUTES, Capability.RANDOM_ACCESS_READ));
    public static final UserAuthenticationData.Type[] AUTHENTICATOR_TYPES = new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD};

    public HttpFileProvider() {
        this.setFileNameParser(HttpFileNameParser.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileSystem doCreateFileSystem(FileName fileName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        HttpClient httpClient;
        GenericFileName genericFileName = (GenericFileName)fileName;
        UserAuthenticationData userAuthenticationData = null;
        try {
            userAuthenticationData = UserAuthenticatorUtils.authenticate(fileSystemOptions, AUTHENTICATOR_TYPES);
            httpClient = HttpClientFactory.createConnection(genericFileName.getScheme(), genericFileName.getHostName(), genericFileName.getPort(), UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData(userAuthenticationData, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(genericFileName.getUserName()))), UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData(userAuthenticationData, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(genericFileName.getPassword()))), fileSystemOptions);
        }
        finally {
            UserAuthenticatorUtils.cleanup(userAuthenticationData);
        }
        return new HttpFileSystem(genericFileName, httpClient, fileSystemOptions);
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return HttpFileSystemConfigBuilder.getInstance();
    }

    public Collection getCapabilities() {
        return capabilities;
    }
}

