/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.vfs.FileChangeEvent;
import org.apache.commons.vfs.FileListener;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.AbstractFileSystem;

public class DelegateFileObject
extends AbstractFileObject
implements FileListener {
    private FileObject file;
    private final Set children = new HashSet();
    private boolean ignoreEvent;

    public DelegateFileObject(FileName fileName, AbstractFileSystem abstractFileSystem, FileObject fileObject) throws FileSystemException {
        super(fileName, abstractFileSystem);
        this.file = fileObject;
        if (fileObject != null) {
            fileObject.getFileSystem().addListener(fileObject, this);
        }
    }

    public void attachChild(FileName fileName, FileType fileType) throws Exception {
        FileType fileType2 = this.doGetType();
        if (this.children.add(fileName.getBaseName())) {
            this.childrenChanged(fileName, fileType);
        }
        this.maybeTypeChanged(fileType2);
    }

    public void setFile(FileObject fileObject) throws Exception {
        FileType fileType = this.doGetType();
        if (fileObject != null) {
            fileObject.getFileSystem().addListener(fileObject, this);
        }
        this.file = fileObject;
        this.maybeTypeChanged(fileType);
    }

    private void maybeTypeChanged(FileType fileType) throws Exception {
        FileType fileType2 = this.doGetType();
        if (fileType == FileType.IMAGINARY && fileType2 != FileType.IMAGINARY) {
            this.handleCreate(fileType2);
        } else if (fileType != FileType.IMAGINARY && fileType2 == FileType.IMAGINARY) {
            this.handleDelete();
        }
    }

    protected FileType doGetType() throws FileSystemException {
        if (this.file != null) {
            return this.file.getType();
        }
        if (this.children.size() > 0) {
            return FileType.FOLDER;
        }
        return FileType.IMAGINARY;
    }

    protected boolean doIsReadable() throws FileSystemException {
        if (this.file != null) {
            return this.file.isReadable();
        }
        return true;
    }

    protected boolean doIsWriteable() throws FileSystemException {
        if (this.file != null) {
            return this.file.isWriteable();
        }
        return false;
    }

    protected boolean doIsHidden() throws FileSystemException {
        if (this.file != null) {
            return this.file.isHidden();
        }
        return false;
    }

    protected String[] doListChildren() throws Exception {
        if (this.file != null) {
            FileObject[] fileObjectArray = this.file.getChildren();
            String[] stringArray = new String[fileObjectArray.length];
            for (int i = 0; i < fileObjectArray.length; ++i) {
                stringArray[i] = fileObjectArray[i].getName().getBaseName();
            }
            return stringArray;
        }
        return this.children.toArray(new String[this.children.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCreateFolder() throws Exception {
        this.ignoreEvent = true;
        try {
            this.file.createFolder();
        }
        finally {
            this.ignoreEvent = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete() throws Exception {
        this.ignoreEvent = true;
        try {
            this.file.delete();
        }
        finally {
            this.ignoreEvent = false;
        }
    }

    protected long doGetContentSize() throws Exception {
        return this.file.getContent().getSize();
    }

    protected Map doGetAttributes() throws Exception {
        return this.file.getContent().getAttributes();
    }

    protected void doSetAttribute(String string, Object object) throws Exception {
        this.file.getContent().setAttribute(string, object);
    }

    protected Certificate[] doGetCertificates() throws Exception {
        return this.file.getContent().getCertificates();
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.file.getContent().getLastModifiedTime();
    }

    protected void doSetLastModifiedTime(long l) throws Exception {
        this.file.getContent().setLastModifiedTime(l);
    }

    protected InputStream doGetInputStream() throws Exception {
        return this.file.getContent().getInputStream();
    }

    protected OutputStream doGetOutputStream(boolean bl) throws Exception {
        return this.file.getContent().getOutputStream(bl);
    }

    public void fileCreated(FileChangeEvent fileChangeEvent) throws Exception {
        if (!this.ignoreEvent) {
            this.handleCreate(this.file.getType());
        }
    }

    public void fileDeleted(FileChangeEvent fileChangeEvent) throws Exception {
        if (!this.ignoreEvent) {
            this.handleDelete();
        }
    }

    public void fileChanged(FileChangeEvent fileChangeEvent) throws Exception {
        if (!this.ignoreEvent) {
            this.handleChanged();
        }
    }

    public void close() throws FileSystemException {
        super.close();
        if (this.file != null) {
            this.file.close();
        }
    }
}

