/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileListener;
import org.apache.commons.vfs.FileMonitor;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.AbstractFileSystem;

public class DefaultFileMonitor
implements Runnable,
FileMonitor {
    private static final Log log = LogFactory.getLog(DefaultFileMonitor.class);
    private final Map monitorMap = new HashMap();
    private Thread monitorThread;
    private Stack deleteStack = new Stack();
    private Stack addStack = new Stack();
    private boolean shouldRun = true;
    private boolean recursive = false;
    private long delay = 1000L;
    private int checksPerRun = 1000;
    private final FileListener listener;

    public DefaultFileMonitor(FileListener fileListener) {
        this.listener = fileListener;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    FileListener getFileListener() {
        return this.listener;
    }

    public void addFile(FileObject fileObject) {
        this._addFile(fileObject);
        try {
            if (fileObject.getType().hasChildren()) {
                FileObject[] fileObjectArray = fileObject.getChildren();
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    this._addFile(fileObjectArray[i]);
                }
            }
        }
        catch (FileSystemException fileSystemException) {
            log.error((Object)fileSystemException.getLocalizedMessage(), (Throwable)fileSystemException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addFile(FileObject fileObject) {
        Map map = this.monitorMap;
        synchronized (map) {
            if (this.monitorMap.get(fileObject.getName()) == null) {
                this.monitorMap.put(fileObject.getName(), new FileMonitorAgent(this, fileObject));
                try {
                    if (this.listener != null) {
                        fileObject.getFileSystem().addListener(fileObject, this.listener);
                    }
                    if (fileObject.getType().hasChildren() && this.recursive) {
                        FileObject[] fileObjectArray = fileObject.getChildren();
                        for (int i = 0; i < fileObjectArray.length; ++i) {
                            this.addFile(fileObjectArray[i]);
                        }
                    }
                }
                catch (FileSystemException fileSystemException) {
                    log.error((Object)fileSystemException.getLocalizedMessage(), (Throwable)fileSystemException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFile(FileObject fileObject) {
        Map map = this.monitorMap;
        synchronized (map) {
            FileName fileName = fileObject.getName();
            if (this.monitorMap.get(fileName) != null) {
                FileMonitorAgent fileMonitorAgent;
                FileObject fileObject2;
                try {
                    fileObject2 = fileObject.getParent();
                }
                catch (FileSystemException fileSystemException) {
                    fileObject2 = null;
                }
                this.monitorMap.remove(fileName);
                if (fileObject2 != null && (fileMonitorAgent = (FileMonitorAgent)this.monitorMap.get(fileObject2.getName())) != null) {
                    fileMonitorAgent.resetChildrenList();
                }
            }
        }
    }

    protected void queueRemoveFile(FileObject fileObject) {
        this.deleteStack.push(fileObject);
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long l) {
        this.delay = l > 0L ? l : 1000L;
    }

    public int getChecksPerRun() {
        return this.checksPerRun;
    }

    public void setChecksPerRun(int n) {
        this.checksPerRun = n;
    }

    protected void queueAddFile(FileObject fileObject) {
        this.addStack.push(fileObject);
    }

    public void start() {
        if (this.monitorThread == null) {
            this.monitorThread = new Thread(this);
            this.monitorThread.setDaemon(true);
            this.monitorThread.setPriority(1);
        }
        this.monitorThread.start();
    }

    public void stop() {
        this.shouldRun = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block10: while (!Thread.currentThread().isInterrupted() && this.shouldRun) {
            Object[] objectArray;
            while (!this.deleteStack.empty()) {
                this.removeFile((FileObject)this.deleteStack.pop());
            }
            Map map = this.monitorMap;
            synchronized (map) {
                objectArray = this.monitorMap.keySet().toArray();
            }
            for (int i = 0; i < objectArray.length; ++i) {
                FileMonitorAgent fileMonitorAgent;
                FileName fileName = (FileName)objectArray[i];
                Map map2 = this.monitorMap;
                synchronized (map2) {
                    fileMonitorAgent = (FileMonitorAgent)this.monitorMap.get(fileName);
                }
                if (fileMonitorAgent != null) {
                    fileMonitorAgent.check();
                }
                if (this.getChecksPerRun() > 0 && i % this.getChecksPerRun() == 0) {
                    try {
                        Thread.sleep(this.getDelay());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (Thread.currentThread().isInterrupted() || !this.shouldRun) continue block10;
            }
            while (!this.addStack.empty()) {
                this.addFile((FileObject)this.addStack.pop());
            }
            try {
                Thread.sleep(this.getDelay());
            }
            catch (InterruptedException interruptedException) {}
        }
        this.shouldRun = true;
    }

    private static class FileMonitorAgent {
        private final FileObject file;
        private final DefaultFileMonitor fm;
        private boolean exists;
        private long timestamp;
        private Map children = null;

        private FileMonitorAgent(DefaultFileMonitor defaultFileMonitor, FileObject fileObject) {
            this.fm = defaultFileMonitor;
            this.file = fileObject;
            this.refresh();
            this.resetChildrenList();
            try {
                this.exists = this.file.exists();
            }
            catch (FileSystemException fileSystemException) {
                this.exists = false;
            }
            try {
                this.timestamp = this.file.getContent().getLastModifiedTime();
            }
            catch (FileSystemException fileSystemException) {
                this.timestamp = -1L;
            }
        }

        private void resetChildrenList() {
            try {
                if (this.file.getType().hasChildren()) {
                    this.children = new HashMap();
                    FileObject[] fileObjectArray = this.file.getChildren();
                    for (int i = 0; i < fileObjectArray.length; ++i) {
                        this.children.put(fileObjectArray[i].getName(), new Object());
                    }
                }
            }
            catch (FileSystemException fileSystemException) {
                this.children = null;
            }
        }

        private void refresh() {
            try {
                this.file.refresh();
            }
            catch (FileSystemException fileSystemException) {
                log.error((Object)fileSystemException.getLocalizedMessage(), (Throwable)fileSystemException);
            }
        }

        private void fireAllCreate(FileObject fileObject) {
            if (this.fm.getFileListener() != null) {
                fileObject.getFileSystem().addListener(fileObject, this.fm.getFileListener());
            }
            ((AbstractFileSystem)fileObject.getFileSystem()).fireFileCreated(fileObject);
            if (this.fm.getFileListener() != null) {
                fileObject.getFileSystem().removeListener(fileObject, this.fm.getFileListener());
            }
            this.fm.queueAddFile(fileObject);
            try {
                if (this.fm.isRecursive() && fileObject.getType().hasChildren()) {
                    FileObject[] fileObjectArray = fileObject.getChildren();
                    for (int i = 0; i < fileObjectArray.length; ++i) {
                        this.fireAllCreate(fileObjectArray[i]);
                    }
                }
            }
            catch (FileSystemException fileSystemException) {
                log.error((Object)fileSystemException.getLocalizedMessage(), (Throwable)fileSystemException);
            }
        }

        private void checkForNewChildren() {
            try {
                if (this.file.getType().hasChildren()) {
                    FileObject[] fileObjectArray = this.file.getChildren();
                    if (this.children != null) {
                        HashMap<FileName, Object> hashMap = new HashMap<FileName, Object>();
                        Stack<FileObject> stack = new Stack<FileObject>();
                        for (int i = 0; i < fileObjectArray.length; ++i) {
                            hashMap.put(fileObjectArray[i].getName(), new Object());
                            if (this.children.containsKey(fileObjectArray[i].getName())) continue;
                            stack.push(fileObjectArray[i]);
                        }
                        this.children = hashMap;
                        if (!stack.empty()) {
                            while (!stack.empty()) {
                                FileObject fileObject = (FileObject)stack.pop();
                                this.fireAllCreate(fileObject);
                            }
                        }
                    } else {
                        if (fileObjectArray.length > 0) {
                            this.children = new HashMap();
                        }
                        for (int i = 0; i < fileObjectArray.length; ++i) {
                            this.children.put(fileObjectArray[i].getName(), new Object());
                            this.fireAllCreate(fileObjectArray[i]);
                        }
                    }
                }
            }
            catch (FileSystemException fileSystemException) {
                log.error((Object)fileSystemException.getLocalizedMessage(), (Throwable)fileSystemException);
            }
        }

        private void check() {
            this.refresh();
            try {
                if (this.exists && !this.file.exists()) {
                    this.exists = this.file.exists();
                    this.timestamp = -1L;
                    ((AbstractFileSystem)this.file.getFileSystem()).fireFileDeleted(this.file);
                    if (this.fm.getFileListener() != null) {
                        this.file.getFileSystem().removeListener(this.file, this.fm.getFileListener());
                    }
                    this.fm.queueRemoveFile(this.file);
                } else if (this.exists && this.file.exists() && this.timestamp != this.file.getContent().getLastModifiedTime()) {
                    this.timestamp = this.file.getContent().getLastModifiedTime();
                    if (!this.file.getType().hasChildren()) {
                        ((AbstractFileSystem)this.file.getFileSystem()).fireFileChanged(this.file);
                    }
                }
                this.checkForNewChildren();
            }
            catch (FileSystemException fileSystemException) {
                log.error((Object)fileSystemException.getLocalizedMessage(), (Throwable)fileSystemException);
            }
        }
    }
}

