/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xquery.kit;

import com.japisoft.framework.preferences.Preferences;
import com.japisoft.xquery.helper.Keywords;
import com.japisoft.xquery.kit.Token;
import java.awt.Color;
import java.util.HashMap;

public class SyntaxLexer {
    private static final Token EMPTY_TOKEN = new Token("", null);
    Color defaultColor = Color.BLACK;
    Color string1Color = Color.RED;
    Color string2Color = Color.ORANGE.darker();
    Color variableColor = Color.PINK.darker();
    Color commentColor = Color.DARK_GRAY;
    Color tagColor = new Color(0, 0, 178);
    Color axisColor = Color.MAGENTA.darker();
    Color attributeColor = new Color(100, 50, 200);
    private int tokenCount;
    private Token[] maxTokens = new Token[100];
    private HashMap mapOfLastTokens = new HashMap();
    private HashMap mapOfColor = new HashMap();
    private StringBuffer sb = new StringBuffer();

    SyntaxLexer() {
        int n;
        Color color = new Color(0, 0, 200);
        this.defaultColor = Preferences.getPreference("xqueryEditor", "defaultColor", this.defaultColor);
        this.string1Color = Preferences.getPreference("xqueryEditor", "string1Color", this.string1Color);
        this.string2Color = Preferences.getPreference("xqueryEditor", "string2Color", this.string2Color);
        this.variableColor = Preferences.getPreference("xqueryEditor", "variableColor", this.variableColor);
        this.commentColor = Preferences.getPreference("xqueryEditor", "commentColor", this.commentColor);
        this.tagColor = Preferences.getPreference("xqueryEditor", "tagColor", this.tagColor);
        this.axisColor = Preferences.getPreference("xqueryEditor", "axisColor", this.axisColor);
        this.attributeColor = Preferences.getPreference("xqueryEditor", "attributeColor", this.attributeColor);
        color = Preferences.getPreference("xqueryEditor", "keywords", color);
        for (n = 0; n < Keywords.main.length; ++n) {
            this.mapOfColor.put(Keywords.main[n], color);
        }
        for (n = 0; n < Keywords.axes.length; ++n) {
            this.mapOfColor.put(Keywords.axes[n], this.axisColor);
        }
        color = new Color(0, 150, 150);
        for (n = 0; n < Keywords.functions.length; ++n) {
            this.mapOfColor.put(Keywords.functions[n], color);
        }
        this.mapOfColor.put("(:", this.commentColor);
    }

    public int getTokenCount() {
        return this.tokenCount;
    }

    private void resetBuffer() {
        this.sb.delete(0, this.sb.length() + 1);
    }

    public Token[] getTokenForLine(String string, int n) {
        this.tokenCount = 0;
        Token token = (Token)this.mapOfLastTokens.get(new Integer(n - 1));
        Token token2 = (Token)this.mapOfLastTokens.get(new Integer(n));
        this.resetBuffer();
        Token token3 = null;
        Token token4 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        char c = '\u0000';
        boolean bl5 = false;
        if (token != null) {
            if (token.color == this.commentColor) {
                bl2 = true;
            } else if (token.color == this.string1Color || token.color == this.string2Color) {
                bl4 = true;
                c = token.color == this.string1Color ? (char)'\"' : '\'';
            } else if (token.color == this.tagColor) {
                bl5 = true;
            }
        }
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (!bl2 && i > 0 && c2 == ':' && string.charAt(i - 1) == '(') {
                this.sb.deleteCharAt(this.sb.length() - 1);
                this.addToken(this.sb.toString());
                this.resetBuffer();
                this.addToken("(:");
                bl2 = true;
                continue;
            }
            if (bl2) {
                if (c2 == ')' && i > 0 && string.charAt(i - 1) == ':') {
                    this.sb.append(c2);
                    this.addToken(this.sb.toString(), this.commentColor);
                    token4 = EMPTY_TOKEN;
                    this.resetBuffer();
                    bl2 = false;
                    continue;
                }
                this.sb.append(c2);
                continue;
            }
            if (!bl5) {
                if (c2 == '<') {
                    this.addToken(this.sb.toString());
                    this.resetBuffer();
                    this.addToken("<", this.tagColor);
                    bl5 = true;
                    continue;
                }
            } else {
                if (c2 == '>') {
                    this.sb.append(">");
                    this.addToken(this.sb.toString(), this.tagColor);
                    token4 = EMPTY_TOKEN;
                    this.resetBuffer();
                    bl5 = false;
                    continue;
                }
                this.sb.append(c2);
                continue;
            }
            if (!bl4) {
                if (c2 == '\"' || c2 == '\'') {
                    c = c2;
                    this.addToken(this.sb.toString());
                    this.resetBuffer();
                    this.addToken("\"", c2 == '\"' ? this.string1Color : this.string2Color);
                    bl4 = true;
                    continue;
                }
            } else {
                if (c2 == c) {
                    this.sb.append(c2);
                    this.addToken(this.sb.toString(), c2 == '\"' ? this.string1Color : this.string2Color);
                    token4 = EMPTY_TOKEN;
                    this.resetBuffer();
                    bl4 = false;
                    continue;
                }
                this.sb.append(c2);
                continue;
            }
            if (!bl3) {
                if (c2 == '$') {
                    this.addToken(this.sb.toString());
                    this.resetBuffer();
                    this.addToken("$", this.variableColor);
                    this.resetBuffer();
                    bl3 = true;
                    continue;
                }
            } else if (c2 == ' ' || c2 == '\t' || c2 == '\n' || c2 == '\r' || c2 == '=' || c2 == ')' || c2 == '}' || c2 == ',' || c2 == '/' || c2 == ']') {
                this.addToken(this.sb.toString(), this.variableColor);
                this.resetBuffer();
                bl3 = false;
            }
            if (!bl) {
                if (c2 != ' ' && c2 != '\t' && c2 != '\n' && c2 != '\r' && c2 != '(' && c2 != '{' && c2 != ',' && c2 != '=' && c2 != ':' && c2 != '[' && c2 != '/') {
                    this.addToken(this.sb.toString());
                    this.resetBuffer();
                    this.sb.append(c2);
                    bl = true;
                } else {
                    this.sb.append(c2);
                }
            } else if (c2 == ' ' || c2 == '\t' || c2 == '\n' || c2 == '\t' || c2 == '(' || c2 == ':' || c2 == '=' || c2 == '/' || c2 == '[' || c2 == ']' || c2 == ')' || c2 == ',') {
                token3 = this.addToken(this.sb.toString());
                this.resetBuffer();
                this.sb.append(c2);
                bl = false;
            } else {
                this.sb.append(c2);
            }
            if (token3 == null) continue;
            token4 = token3;
        }
        Color color = null;
        if (bl2) {
            color = this.commentColor;
        } else if (bl4) {
            color = c == '\"' ? this.string1Color : this.string2Color;
        } else if (bl3) {
            color = this.variableColor;
        }
        token3 = this.addToken(this.sb.toString(), color);
        if (token3 != null) {
            token4 = token3;
        }
        if (bl3) {
            token4 = null;
        }
        if (token2 != null && token2.color == this.commentColor && !bl2) {
            token4 = EMPTY_TOKEN;
        }
        if (!(token2 == null || token2.color != this.string1Color && token2.color != this.string2Color || bl4)) {
            token4 = EMPTY_TOKEN;
        }
        if (token2 != null && token2.color == this.tagColor && !bl5) {
            token4 = EMPTY_TOKEN;
        }
        if (token4 != null) {
            this.mapOfLastTokens.put(new Integer(n), token4);
        }
        return this.maxTokens;
    }

    Token addToken(String string) {
        return this.addToken(string, null);
    }

    Token addToken(String string, Color color) {
        Object object;
        Color color2 = color;
        if (color2 == null && (color2 = (Color)this.mapOfColor.get(string.toLowerCase())) == null && string.startsWith("@")) {
            color2 = this.attributeColor;
        }
        if (this.tokenCount == this.maxTokens.length) {
            object = new Token[this.maxTokens.length * 2];
            System.arraycopy(this.maxTokens, 0, object, 0, this.maxTokens.length);
            this.maxTokens = object;
        }
        object = null;
        if (color2 == null) {
            color2 = this.defaultColor;
            object = new Token(string, color2);
            this.maxTokens[this.tokenCount++] = object;
            return null;
        }
        object = new Token(string, color2);
        this.maxTokens[this.tokenCount++] = object;
        return object;
    }

    void dump() {
        System.out.println();
        for (int i = 0; i < this.tokenCount; ++i) {
            System.out.print("[" + this.maxTokens[i] + "]");
        }
    }

    public static void main(String[] stringArray) {
        String string = "a color : flsfksldfkjsdlkj;dddd";
        SyntaxLexer syntaxLexer = new SyntaxLexer();
        syntaxLexer.getTokenForLine(string, 0);
        syntaxLexer.dump();
    }
}

