/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xquery;

import com.japisoft.editix.ui.xslt.Factory;
import com.japisoft.editix.ui.xslt.LineSelectionListener;
import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.app.toolkit.Toolkit;
import com.japisoft.framework.xml.XMLFileData;
import com.japisoft.framework.xml.XMLToolkit;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.text.html.HTMLEditorKit;

public class ResultPanel
extends JPanel
implements ActionListener {
    private JComboBox comboSource;
    private CardLayout resultLayout;
    private JTextArea textAreaResult;
    private JEditorPane htmlResult;
    private JPanel panel5;
    private Factory factory;
    JTabbedPane tpResultDebug;
    private String lastResult = null;
    private String lastEncoding = null;

    public ResultPanel(Factory factory, boolean bl, LineSelectionListener lineSelectionListener) {
        this.factory = factory;
        JPanel jPanel = null;
        if (!bl) {
            jPanel = this;
        } else {
            jPanel = new JPanel();
            this.tpResultDebug = new JTabbedPane(3);
            this.tpResultDebug.addTab("Result", jPanel);
            this.setLayout(new BorderLayout());
        }
        jPanel.setLayout(new BorderLayout());
        this.comboSource = new JComboBox<String>(new String[]{"Source", "HTML 3.2"});
        jPanel.add("North", this.comboSource);
        this.panel5 = new JPanel();
        this.resultLayout = new CardLayout();
        this.panel5.setLayout(this.resultLayout);
        this.textAreaResult = new JTextArea();
        this.panel5.add((Component)new JScrollPane(this.textAreaResult), "source");
        this.htmlResult = new JEditorPane();
        this.panel5.add((Component)new JScrollPane(this.htmlResult), "html");
        jPanel.add((Component)this.panel5, "Center");
        this.resultLayout.show(this.panel5, "source");
        if (bl) {
            this.add("Center", this.tpResultDebug);
        }
        this.textAreaResult.setEditable(false);
        this.htmlResult.setEditable(false);
        this.htmlResult.setEditorKit(new HTMLEditorKit());
    }

    public void addNotify() {
        super.addNotify();
        this.comboSource.addActionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.comboSource.removeActionListener(this);
    }

    public void loadResultFile(String string, String string2) {
        this.lastResult = string;
        this.lastEncoding = string2;
        if (this.comboSource.getSelectedIndex() == 1) {
            this.htmlResult.setText("");
        } else if (this.comboSource.getSelectedIndex() == 0) {
            this.textAreaResult.setText("");
        }
        try {
            if (string != null) {
                if (this.comboSource.getSelectedIndex() == 0) {
                    XMLFileData xMLFileData = XMLToolkit.getContentFromURI(string, Toolkit.getCurrentFileEncoding());
                    this.textAreaResult.setText(xMLFileData.getContent());
                    this.resultLayout.show(this.panel5, "source");
                    this.textAreaResult.setCaretPosition(0);
                } else if (this.comboSource.getSelectedIndex() == 1) {
                    this.htmlResult.setContentType("text/html");
                    XMLFileData xMLFileData = XMLToolkit.getContentFromURI(string, Toolkit.getCurrentFileEncoding());
                    this.htmlResult.setText(xMLFileData.getContent());
                    this.resultLayout.show(this.panel5, "html");
                    this.htmlResult.setCaretPosition(0);
                }
            }
        }
        catch (Throwable throwable) {
            ApplicationModel.debug(throwable);
            this.factory.buildAndShowErrorDialog("Can't show the result file " + string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.loadResultFile(this.lastResult, this.lastEncoding);
    }

    public void dispose() {
        this.factory = null;
        this.panel5 = null;
    }
}

