/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xpath;

import com.japisoft.fastparser.Parser;
import com.japisoft.xpath.DebugXPathResolver;
import com.japisoft.xpath.NodeSet;
import com.japisoft.xpath.TreeXPathResolver;
import com.japisoft.xpath.XPathContext;
import com.japisoft.xpath.XPathException;
import com.japisoft.xpath.XPathKit;
import com.japisoft.xpath.XPathParser;
import com.japisoft.xpath.XPathResolver;
import com.japisoft.xpath.kit.FastParserKit;
import com.japisoft.xpath.node.AbstractNode;
import java.io.FileInputStream;
import java.io.StringReader;
import java.util.Hashtable;

public class XPath {
    private XPathKit kit;
    private Object refNode;
    private boolean navCache = true;
    private String expr;
    private AbstractNode exprNode;
    private Hashtable htNamespace;
    private Hashtable htVariable;
    private Hashtable innerCache = null;

    public XPath(XPathKit xPathKit) {
        this.kit = xPathKit;
        if (xPathKit == null) {
            throw new RuntimeException("An XPathKit is required");
        }
    }

    public XPath() {
        String string = System.getProperty("com.japisoft.jxp.kit");
        if (string == null) {
            throw new RuntimeException("Can't find the property value com.japisoft.jxp.kit");
        }
        try {
            this.kit = (XPathKit)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Can't load the class " + string, exception);
        }
    }

    public void setNavigatorCache(boolean bl) {
        this.navCache = bl;
    }

    public boolean hasNavigatorCache() {
        return this.navCache;
    }

    public void setReferenceNode(Object object) {
        if (object != this.refNode) {
            this.refNode = this.kit.getBetterReferenceNode(object);
            if (this.navCache) {
                this.innerCache = new Hashtable();
            }
        }
    }

    public void setXPathExpression(String string) throws XPathException {
        if (this.expr != null && this.expr.equals(string)) {
            return;
        }
        this.expr = string;
        XPathParser xPathParser = new XPathParser(new StringReader(string));
        XPathResolver xPathResolver = null;
        xPathResolver = "true".equals(System.getProperty("jxp.tree.debug")) ? new DebugXPathResolver() : new TreeXPathResolver();
        xPathParser.setXPathResolver(xPathResolver);
        try {
            xPathParser.yyparse();
        }
        catch (Throwable throwable) {
            if ("true".equals(System.getProperty("jxp.debug"))) {
                throwable.printStackTrace();
            }
            throw new XPathException("Error with " + string + " :" + throwable.getMessage(), xPathParser.getCurrentPos());
        }
        this.exprNode = xPathResolver.getRootParsedNode();
        if (this.exprNode == null) {
            throw new XPathException("Inner error null exprNode", 0);
        }
    }

    public NodeSet resolve() throws XPathException {
        if (this.exprNode == null) {
            throw new RuntimeException("No expression found");
        }
        Object object = this.resolveAny();
        if (object instanceof NodeSet) {
            return (NodeSet)object;
        }
        return new NodeSet();
    }

    public Object resolveAny() throws XPathException {
        if (this.exprNode == null) {
            throw new XPathException("No expression found", 0);
        }
        try {
            XPathContext xPathContext = new XPathContext(this.refNode, this.kit);
            xPathContext.setCache(this.navCache);
            xPathContext.setNavigatorCacheContent(this.innerCache);
            xPathContext.setNamespaceDeclarationModel(this.htNamespace);
            xPathContext.setVariableModel(this.htVariable);
            return this.exprNode.eval(xPathContext);
        }
        catch (Throwable throwable) {
            if ("true".equals(System.getProperty("jxp.debug"))) {
                throwable.printStackTrace();
            }
            throw new XPathException(throwable.getMessage(), 0);
        }
    }

    public void addNamespaceDeclaration(String string, String string2) {
        if (this.htNamespace == null) {
            this.htNamespace = new Hashtable();
        }
        this.htNamespace.put(string, string2);
    }

    public void removeNamespaceDeclaration(String string) {
        if (this.htNamespace != null) {
            this.htNamespace.remove(string);
        }
    }

    private void storeVariable(String string, Object object) {
        if (this.htVariable == null) {
            this.htVariable = new Hashtable();
        }
        this.htVariable.put(string, object);
    }

    public void addVariable(String string, int n) {
        this.storeVariable(string, new Double(n));
    }

    public void addVariable(String string, boolean bl) {
        this.storeVariable(string, new Boolean(bl));
    }

    public void addVariable(String string, double d) {
        this.storeVariable(string, new Double(d));
    }

    public void addVariable(String string, String string2) {
        this.storeVariable(string, string2);
    }

    public void addVariable(String string, NodeSet nodeSet) {
        this.storeVariable(string, nodeSet);
    }

    public void removeVariable(String string) {
        if (this.htVariable != null) {
            this.htVariable.remove(string);
        }
    }

    public void setFeature(String string, boolean bl) {
        if (this.kit == null) {
            throw new RuntimeException("No kit found");
        }
        this.kit.setFeature(string, bl);
    }

    public boolean isFeatureSupported(String string) {
        if (this.kit == null) {
            throw new RuntimeException("No kit found");
        }
        return this.kit.isFeatureSupported(string);
    }

    public String[] getSupportedFeatures() {
        if (this.kit == null) {
            throw new RuntimeException("No kit found");
        }
        return this.kit.getSupportedFeatures();
    }

    public static void main(String[] stringArray) throws Throwable {
        XPath xPath = new XPath(new FastParserKit());
        Parser parser = new Parser();
        parser.setInputStream(new FileInputStream("/home/japisoft/japisoft/japisoft/japisoft/soft/jxp/samples/shone/test.xml"));
        parser.parse();
        xPath.setReferenceNode(parser.getDocument().getRoot());
        xPath.setXPathExpression("count(/form_data/users/user)");
        Object object = xPath.resolveAny();
        System.out.println("RESULT = " + object);
    }
}

