/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlform.component.editable;

import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.spellchecker.Dictionnary;
import com.japisoft.framework.spellchecker.DictionnaryFactory;
import com.japisoft.framework.spellchecker.ErrorWordHighlight;
import com.japisoft.xmlform.component.ComponentContext;
import com.japisoft.xmlform.component.container.GridComponent;
import com.japisoft.xmlform.component.editable.XMLEditableComponent;
import com.japisoft.xmlform.designer.properties.PropertyDescriptor;
import com.japisoft.xmlform.designer.properties.PropertyDescriptorImpl;
import com.japisoft.xmlform.editor.EditorModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLFormTextComponent
extends XMLEditableComponent {
    private JComponent tf = null;
    private boolean multiLine = false;
    private boolean scrollable = false;
    private ErrorWordHighlight ewh = null;
    private Font customFont = null;
    private Color customBackground = null;
    private Color customForeground = null;

    public XMLFormTextComponent(boolean bl, ComponentContext componentContext) {
        this(bl, componentContext, false);
    }

    public XMLFormTextComponent(boolean bl, ComponentContext componentContext, boolean bl2) {
        super(bl, componentContext);
        this.setMultiLine(bl2);
        if (bl) {
            this.prepareDesignUI();
        }
    }

    private void prepareDesignUI() {
        if (this.tf == null) {
            this.tf = new JLabel();
            this.tf.setBackground(Color.WHITE);
            this.tf.setForeground(Color.BLACK);
            this.tf.setOpaque(true);
            ((JLabel)this.tf).setVerticalAlignment(1);
            this.add((Component)this.tf, "Center");
            this.setPreferredSize(new Dimension(200, 2 * GridComponent.getGridSize()));
        }
    }

    @Override
    protected void updateLabel(String string) {
        if (this.designMode) {
            this.prepareDesignUI();
            ((JLabel)this.tf).setText(string);
        }
    }

    public boolean getMultiLine() {
        return this.multiLine;
    }

    public void setMultiLine(boolean bl) {
        this.firePropertyChange("multiLine", this.multiLine, bl);
        this.multiLine = bl;
    }

    public boolean getScrollable() {
        return this.scrollable;
    }

    public void setScrollable(boolean bl) {
        this.firePropertyChange("scrollable", this.scrollable, bl);
        this.scrollable = bl;
    }

    private void addEditableComponent() {
        if (!this.multiLine && !this.scrollable) {
            this.tf = new JTextField();
        } else {
            this.tf = new JTextArea();
            ((JTextArea)this.tf).setLineWrap(true);
            ((JTextArea)this.tf).setWrapStyleWord(true);
            if (!this.scrollable) {
                this.tf.setBorder(new LineBorder(Color.GRAY));
            }
        }
        ((JTextComponent)this.tf).setDocument(new CustomPlainDocument());
        if (this.customBackground != null) {
            this.tf.setBackground(this.customBackground);
        }
        if (this.customForeground != null) {
            this.tf.setForeground(this.customForeground);
        }
        if (this.customFont != null) {
            this.tf.setFont(this.customFont);
        }
        this.setRequired(this.getRequired());
        if (this.scrollable) {
            this.add((Component)new JScrollPane(this.tf), "Center");
        } else {
            this.add((Component)this.tf, "Center");
        }
        this.tf.setToolTipText(this.tooltip);
        if (EditorModel.SPELL_CHECK != null) {
            try {
                Dictionnary dictionnary = DictionnaryFactory.getDictionnary(EditorModel.SPELL_CHECK);
                this.ewh = new ErrorWordHighlight((JTextComponent)this.tf, dictionnary);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                EditorModel.SPELL_CHECK = null;
            }
        }
    }

    @Override
    protected boolean canBeResizedVertically() {
        if (this.tf instanceof JTextField) {
            return false;
        }
        return super.canBeResizedVertically();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.designMode) {
            this.tf.addMouseListener(this);
            this.tf.addMouseMotionListener(this);
        } else {
            this.addEditableComponent();
            this.invalidate();
            this.validate();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.designMode) {
            this.tf.removeMouseListener(this);
            this.tf.removeMouseMotionListener(this);
        }
        if (this.ewh != null) {
            this.ewh.dispose();
            this.ewh = null;
        }
    }

    @Override
    protected void setDOM(Node node) {
        if (node instanceof Text) {
            node = node.getParentNode();
        }
        super.setDOM(node);
        this.domText = null;
        Node node2 = this.getDOMText();
        if ("".equals(((JTextComponent)this.tf).getText())) {
            ((JTextComponent)this.tf).setText(node2.getNodeValue());
        }
    }

    @Override
    public void setFont(Font font) {
        this.firePropertyChange("font", this.customFont, font);
        this.customFont = font;
    }

    @Override
    public Font getFont() {
        return this.customFont;
    }

    @Override
    public void setRequired(boolean bl) {
        super.setRequired(bl);
        if (this.tf != null) {
            if (bl) {
                this.tf.setBackground(this.getColorForRequiredField());
            } else if (this.customBackground != null) {
                this.tf.setBackground(this.customBackground);
            } else {
                this.tf.setBackground(Color.WHITE);
            }
        }
    }

    @Override
    public void setBackground(Color color) {
        this.firePropertyChange("background", this.customBackground, color);
        this.customBackground = color;
        if (!this.getRequired() && this.designMode) {
            this.tf.setBackground(color);
        }
    }

    @Override
    public Color getBackground() {
        return this.customBackground;
    }

    @Override
    public void setForeground(Color color) {
        this.firePropertyChange("foreground", this.customForeground, color);
        this.customForeground = color;
    }

    @Override
    public Color getForeground() {
        return this.customForeground;
    }

    @Override
    public void requestFocus() {
        if (this.tf != null) {
            this.tf.requestFocus();
        }
    }

    public void cut() {
        if (this.tf != null) {
            ((JTextComponent)this.tf).cut();
        }
    }

    public void copy() {
        if (this.tf != null) {
            ((JTextComponent)this.tf).copy();
        }
    }

    public void paste() {
        if (this.tf != null) {
            ((JTextComponent)this.tf).paste();
        }
    }

    public void selectAll() {
        if (this.tf != null) {
            ((JTextComponent)this.tf).selectAll();
        }
    }

    @Override
    protected void prepareProperties(ArrayList<PropertyDescriptor> arrayList) throws Exception {
        super.prepareProperties(arrayList);
        arrayList.add(new PropertyDescriptorImpl("multiLine", Boolean.class, this));
        arrayList.add(new PropertyDescriptorImpl("scrollable", Boolean.class, this));
    }

    private void deleteCurrentNode() {
        Node node = this.getDOMText();
        if (node instanceof Attr) {
            Element element = ((Attr)node).getOwnerElement();
            element.removeAttributeNode((Attr)node);
            this.domText = null;
        } else if (node instanceof Text) {
            Element element = (Element)node.getParentNode();
            if (!element.hasAttributes() && element.getParentNode() instanceof Element) {
                Element element2 = (Element)element.getParentNode();
                element2.removeChild(element);
                this.dom = null;
            }
            element.removeChild(node);
            this.domText = null;
        }
    }

    class CustomPlainDocument
    extends PlainDocument {
        CustomPlainDocument() {
        }

        private void updateDomText() {
            Node node = XMLFormTextComponent.this.getDOMText();
            try {
                boolean bl;
                String string = this.getText(0, this.getLength());
                boolean bl2 = bl = string == null || "".equals(string);
                if (XMLFormTextComponent.this.getRequired()) {
                    if (bl) {
                        XMLFormTextComponent.this.tf.setBackground(XMLFormTextComponent.this.getColorForRequiredField());
                    } else if (XMLFormTextComponent.this.customBackground != null) {
                        XMLFormTextComponent.this.tf.setBackground(XMLFormTextComponent.this.customBackground);
                    } else {
                        XMLFormTextComponent.this.tf.setBackground(Color.WHITE);
                    }
                }
                if (!bl) {
                    node.setNodeValue(this.getText(0, this.getLength()));
                } else {
                    XMLFormTextComponent.this.deleteCurrentNode();
                }
            }
            catch (DOMException dOMException) {
                ApplicationModel.debug(dOMException);
            }
            catch (BadLocationException badLocationException) {
                ApplicationModel.debug(badLocationException);
            }
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            super.insertString(n, string, attributeSet);
            this.updateDomText();
        }

        public void remove(int n, int n2) throws BadLocationException {
            super.remove(n, n2);
            this.updateDomText();
        }
    }
}

