/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.multipanes;

import com.japisoft.multipanes.DefaultTitledPaneModel;
import com.japisoft.multipanes.MultiPanesLayout;
import com.japisoft.multipanes.TitledPane;
import com.japisoft.multipanes.TitledPaneEvent;
import com.japisoft.multipanes.TitledPaneListener;
import com.japisoft.multipanes.TitledPaneModel;
import com.japisoft.multipanes.TitledPaneView;
import com.japisoft.multipanes.view.ArrowTitledPaneView;
import com.japisoft.multipanes.view.DefaultTitledPaneView;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.EventListener;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class MultiPanes
extends JComponent {
    private TitledPaneModel model;
    private TitledPaneView view;
    private TitledPane openTitledPane;
    private boolean disabledCloseLayout = false;
    HashMap mapTitledPaneHeaderView = null;
    private boolean init = false;
    private boolean enabledKeyMapping = true;
    private Color defaultTitledPaneForeground = null;
    private Color defaultTitledPaneBackground = null;
    private Color defaultSelectedTitledPaneForeground = null;
    private Color defaultSelectedTitledPaneBackground = null;
    private Font defaultTitledPaneFont = null;
    private Font defaultSelectedTitledPaneFont = null;

    public MultiPanes() {
        this.setLayout(new MultiPanesLayout(this));
    }

    public void setModel(TitledPaneModel titledPaneModel) {
        this.model = titledPaneModel;
    }

    public TitledPaneModel getModel() {
        if (this.model == null) {
            this.model = new DefaultTitledPaneModel(this);
        }
        return this.model;
    }

    public void setView(TitledPaneView titledPaneView) {
        if (titledPaneView == null) {
            throw new RuntimeException("Illegal null view");
        }
        this.view = titledPaneView;
        titledPaneView.init(this);
    }

    public TitledPaneView getView() {
        if (this.view == null) {
            this.view = new DefaultTitledPaneView();
            this.view.init(this);
        }
        return this.view;
    }

    public void setArrowMode(boolean bl) {
        if (bl) {
            this.setView(new ArrowTitledPaneView());
        }
    }

    public void setVerticalInset(int n) {
        ((MultiPanesLayout)this.getLayout()).setVerticalInset(n);
    }

    public int getVerticalInset() {
        return ((MultiPanesLayout)this.getLayout()).getVerticalInset();
    }

    public void open(String string) {
        TitledPane titledPane = this.getModel().getTitledPaneByName(string);
        if (titledPane != null) {
            this.open(titledPane);
        }
    }

    public void close(String string) {
        TitledPane titledPane = this.getModel().getTitledPaneByName(string);
        if (titledPane != null) {
            this.close(titledPane);
        }
    }

    public void open(TitledPane titledPane) {
        if (titledPane == null) {
            throw new RuntimeException("Illegal null titledPane");
        }
        if (this.openTitledPane != null) {
            this.disabledCloseLayout = true;
            this.close(this.openTitledPane);
            this.disabledCloseLayout = false;
        }
        this.openTitledPane = titledPane;
        this.openTitledPane.open();
        JComponent jComponent = null;
        jComponent = this.openTitledPane.getView();
        this.add(jComponent);
        if (this.init) {
            this.doLayout();
            this.repaint();
            this.notifyTitledPaneListener((JComponent)this.mapTitledPaneHeaderView.get(titledPane), true, new TitledPaneEvent(this, this.openTitledPane));
        }
        if (this.init) {
            this.openTitledPane.getView().invalidate();
            this.openTitledPane.getView().validate();
            this.openTitledPane.getView().requestFocus();
        }
    }

    public void close(TitledPane titledPane) {
        if (titledPane == null) {
            throw new RuntimeException("Illegal null titledPane");
        }
        JComponent jComponent = (JComponent)this.mapTitledPaneHeaderView.get(titledPane);
        titledPane.close();
        this.remove(titledPane.getView());
        this.openTitledPane = null;
        if (!this.disabledCloseLayout) {
            this.doLayout();
            this.repaint();
        }
        this.notifyTitledPaneListener(jComponent, false, new TitledPaneEvent(this, titledPane));
    }

    public TitledPane getOpenedTitledPane() {
        return this.openTitledPane;
    }

    public void updateView() {
        if (!this.init) {
            return;
        }
        this.removeAll();
        TitledPaneModel titledPaneModel = this.getModel();
        TitledPaneView titledPaneView = this.getView();
        Container container = null;
        JComponent jComponent = null;
        this.mapTitledPaneHeaderView = new HashMap();
        for (int i = 0; i < titledPaneModel.getTitledPaneCount(); ++i) {
            TitledPane titledPane = titledPaneModel.getTitledPaneAt(i);
            JComponent jComponent2 = null;
            if (titledPane == this.getOpenedTitledPane()) {
                jComponent = jComponent2 = titledPaneView.buildPanelHeader(titledPane);
                container = titledPane.getView();
            } else {
                jComponent2 = titledPaneView.buildPanelHeader(titledPane);
            }
            this.mapTitledPaneHeaderView.put(titledPane, jComponent2);
            this.add(jComponent2);
            if (container == null) continue;
            this.add(container);
        }
        this.doLayout();
        this.repaint();
        if (container != null) {
            container.invalidate();
            container.validate();
        }
        if (this.getOpenedTitledPane() != null && this.getComponentCount() > 0) {
            this.getView().updateView(jComponent, this.getOpenedTitledPane(), true);
        }
    }

    public void addNotify() {
        super.addNotify();
        if (!this.init) {
            this.init = true;
            this.updateView();
            if (this.enabledKeyMapping) {
                this.prepareTitledPaneKeyMapping();
            }
        }
    }

    public void requestFocus() {
        if (this.getComponentCount() > 0) {
            this.getComponent(0).requestFocus();
        }
    }

    public void addTitledPaneListener(TitledPaneListener titledPaneListener) {
        this.listenerList.add(TitledPaneListener.class, titledPaneListener);
    }

    public void removeTitledPaneListener(TitledPaneListener titledPaneListener) {
        this.listenerList.remove(TitledPaneListener.class, titledPaneListener);
    }

    public void setEnabledKeyAccelerator(boolean bl) {
        this.enabledKeyMapping = bl;
    }

    public boolean isEnabledKeyAccelerator() {
        return this.enabledKeyMapping;
    }

    protected void prepareTitledPaneKeyMapping() {
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        n |= 1;
        for (int i = 1; i <= 9; ++i) {
            String string = "tp.key." + i;
            this.getActionMap().put(string, new ActivateTitledPaneKey(i - 1));
            this.getInputMap(2).put(KeyStroke.getKeyStroke(48 + i, n), string);
        }
    }

    private boolean hasTitledPaneListener() {
        return this.listenerList.getListenerCount(TitledPaneListener.class) > 0;
    }

    private void notifyTitledPaneListener(JComponent jComponent, boolean bl, TitledPaneEvent titledPaneEvent) {
        this.getView().updateView(jComponent, titledPaneEvent.getSelectedTitledPane(), bl);
        if (this.hasTitledPaneListener()) {
            EventListener[] eventListenerArray = this.listenerList.getListeners(TitledPaneListener.class);
            for (int i = 0; i < eventListenerArray.length; ++i) {
                if (bl) {
                    ((TitledPaneListener)eventListenerArray[i]).opened(titledPaneEvent);
                    continue;
                }
                ((TitledPaneListener)eventListenerArray[i]).closed(titledPaneEvent);
            }
        }
    }

    public void setDefaultSelectedTitledPaneFont(Font font) {
        this.defaultSelectedTitledPaneFont = font;
    }

    public Font getDefaultSelectedTitledPaneFont() {
        if (this.defaultSelectedTitledPaneFont == null) {
            this.defaultSelectedTitledPaneFont = UIManager.getFont("multipanes.selection.font");
        }
        return this.defaultSelectedTitledPaneFont;
    }

    public void setDefaultTitledPaneFont(Font font) {
        this.defaultTitledPaneFont = font;
    }

    public Font getDefaultTitledPaneFont() {
        if (this.defaultTitledPaneFont == null) {
            this.defaultTitledPaneFont = UIManager.getFont("multipanes.font");
        }
        return this.defaultTitledPaneFont;
    }

    public void setDefaultTitledPaneForeground(Color color) {
        this.defaultTitledPaneForeground = color;
    }

    public Color getDefaultTitledPaneForeground() {
        if (this.defaultTitledPaneForeground == null) {
            this.defaultTitledPaneForeground = UIManager.getColor("multipanes.fgColor");
        }
        return this.defaultTitledPaneForeground;
    }

    public void setDefaultTitledPaneBackground(Color color) {
        this.defaultTitledPaneBackground = color;
    }

    public Color getDefaultTitledPaneBackground() {
        if (this.defaultTitledPaneBackground == null) {
            this.defaultTitledPaneBackground = UIManager.getColor("multipanes.bgColor");
        }
        return this.defaultTitledPaneBackground;
    }

    public void setDefaultSelectedTitledPaneForeground(Color color) {
        this.defaultSelectedTitledPaneForeground = color;
    }

    public Color getDefaultSelectedTitledPaneForeground() {
        if (this.defaultSelectedTitledPaneForeground == null) {
            this.defaultSelectedTitledPaneForeground = UIManager.getColor("multipanes.selection.fgColor");
        }
        return this.defaultSelectedTitledPaneForeground;
    }

    public void setDefaultSelectedTitledPaneBackground(Color color) {
        this.defaultSelectedTitledPaneBackground = color;
    }

    public Color getDefaultSelectedTitledPaneBackground() {
        if (this.defaultSelectedTitledPaneBackground == null) {
            this.defaultSelectedTitledPaneBackground = UIManager.getColor("multipanes.selection.bgColor");
        }
        return this.defaultSelectedTitledPaneBackground;
    }

    class ActivateTitledPaneKey
    extends AbstractAction {
        private int number;

        ActivateTitledPaneKey(int n) {
            this.number = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TitledPane titledPane = MultiPanes.this.getModel().getTitledPaneAt(this.number);
            if (titledPane != null) {
                MultiPanes.this.open(titledPane);
            }
        }
    }
}

