/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.dialog.report;

import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.dialog.DialogManager;
import com.japisoft.framework.dialog.actions.AbstractDialogAction;
import com.japisoft.framework.dialog.actions.CancelAction;
import com.japisoft.framework.dialog.actions.ClosableAction;
import com.japisoft.framework.dialog.actions.DialogActionModel;
import com.japisoft.framework.dialog.report.DataReportingPanel;
import com.japisoft.framework.ui.Toolkit;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class BugReportingAction
extends AbstractAction {
    protected String type = "BUG";
    private DataReportingPanel panel;
    protected String userInformation = "Insert a bug in the field below, this interface will include automatically your release and operating system. The Title and Description are required. If you wish to receive a reply, please insert your email. Note that you MUST have an active internet connection for using this form.";
    protected String image = "images/bug_red.png";
    protected String dialogTitle = "Bug reporting";
    private String url = null;

    public BugReportingAction(String string) {
        this.setURLReport(string);
    }

    public BugReportingAction() {
        this.setURLReport(ApplicationModel.REPORTING_URL);
    }

    public void setURLReport(String string) {
        this.url = string;
    }

    public String getURLReport() {
        return this.url;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        DialogActionModel dialogActionModel = new DialogActionModel();
        dialogActionModel.addDialogAction(new CancelAction());
        dialogActionModel.addDialogAction(new SendAction());
        this.panel = new DataReportingPanel();
        this.showDialog(dialogActionModel, this.panel);
    }

    protected void showDialog(DialogActionModel dialogActionModel, JPanel jPanel) {
        DialogManager.showDialog(ApplicationModel.MAIN_FRAME, this.dialogTitle, this.dialogTitle, this.userInformation, Toolkit.getIconFromClasspath(this.image), jPanel, dialogActionModel, new Dimension(500, 400));
    }

    public String getUserInformation() {
        return this.userInformation;
    }

    public void setUserInformation(String string) {
        this.userInformation = string;
    }

    class SendAction
    extends AbstractDialogAction
    implements ClosableAction {
        public SendAction() {
            super(10);
            this.putValue("Name", "Send");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = BugReportingAction.this.panel.getTitle();
            String string2 = BugReportingAction.this.panel.getDescription();
            if (string.length() < 10 || string2.length() < 10) {
                JOptionPane.showMessageDialog(ApplicationModel.MAIN_FRAME, "Invalid title or description (at least 10 chars)");
                this.vetoClosingDialog(true);
                return;
            }
            if (JOptionPane.showConfirmDialog(ApplicationModel.MAIN_FRAME, "Do you confirm ?") == 0) {
                String string3 = BugReportingAction.this.panel.getEMail();
                try {
                    String string4;
                    if (BugReportingAction.this.url == null) {
                        BugReportingAction.this.url = ApplicationModel.REPORTING_URL;
                    }
                    URL uRL = new URL(BugReportingAction.this.url);
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setDoOutput(true);
                    uRLConnection.setDoInput(true);
                    String string5 = URLEncoder.encode("version", "UTF-8") + "=" + URLEncoder.encode(ApplicationModel.getAppVersion(), "UTF-8");
                    string5 = string5 + "&" + URLEncoder.encode("os", "UTF-8") + "=" + URLEncoder.encode(System.getProperty("os.name"), "UTF-8");
                    string5 = string5 + "&" + URLEncoder.encode("type", "UTF-8") + "=" + URLEncoder.encode(BugReportingAction.this.type, "UTF-8");
                    string5 = string5 + "&" + URLEncoder.encode("title", "UTF-8") + "=" + URLEncoder.encode(string, "UTF-8");
                    string5 = string5 + "&" + URLEncoder.encode("content", "UTF-8") + "=" + URLEncoder.encode(string2, "UTF-8");
                    string5 = string5 + "&" + URLEncoder.encode("email", "UTF-8") + "=" + URLEncoder.encode(string3, "UTF-8");
                    ApplicationModel.debug("Send [" + string5 + "] to " + BugReportingAction.this.url);
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(uRLConnection.getOutputStream());
                    outputStreamWriter.write(string5);
                    outputStreamWriter.flush();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                    while ((string4 = bufferedReader.readLine()) != null) {
                    }
                    outputStreamWriter.close();
                    bufferedReader.close();
                }
                catch (Throwable throwable) {
                    JOptionPane.showMessageDialog(ApplicationModel.MAIN_FRAME, "Can't send. Please send us a mail to " + ApplicationModel.MAIN_SUPPORT_EMAIL);
                }
            }
        }
    }
}

