/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.dialog.help;

import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.dialog.BasicOKDialogComponent;
import com.japisoft.framework.job.Job;
import com.japisoft.framework.job.JobManager;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class AutoHelpAction
extends AbstractAction {
    DocumentDialog dialog;

    public void actionPerformed(ActionEvent actionEvent) {
        this.dialog = new DocumentDialog("Please wait while generating documentation...");
        JobManager.addJob(new DocGeneratorJob());
        this.dialog.setVisible(true);
        this.dialog.dispose();
        this.dialog = null;
    }

    class DocumentDialog
    extends BasicOKDialogComponent {
        JEditorPane ep;

        public DocumentDialog(String string) {
            super(ApplicationModel.MAIN_FRAME, "Documentation", "Menu Documentation", ApplicationModel.LONG_APPNAME + " menu content", null);
            this.ep = null;
            this.ep = new JEditorPane("text/html", string);
            this.setUI(new JScrollPane(this.ep));
            this.ep.setEditable(false);
            this.ep.setCaretPosition(0);
            this.pack();
            this.setSize(600, 600);
        }

        public void setContent(String string) {
            this.ep.setText(string);
            this.ep.setCaretPosition(0);
        }
    }

    class DocGeneratorJob
    implements Job {
        DocGeneratorJob() {
        }

        public Object getSource() {
            return AutoHelpAction.this;
        }

        public boolean isAlone() {
            return true;
        }

        public void dispose() {
        }

        public void run() {
            if (ApplicationModel.USERINTERFACE_FILE == null) {
                throw new RuntimeException("No value for the property INTERFACE_BUILDER of the ApplicationModel");
            }
            if (ApplicationModel.AUTODOC_FILE == null) {
                throw new RuntimeException("No stylesheet, set the AUTODOC_FILE property");
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            try {
                Transformer transformer = transformerFactory.newTransformer(new StreamSource(ClassLoader.getSystemResourceAsStream(ApplicationModel.AUTODOC_FILE)));
                transformer.setParameter("appname", ApplicationModel.LONG_APPNAME);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                transformer.transform(new StreamSource(ClassLoader.getSystemResourceAsStream(ApplicationModel.USERINTERFACE_FILE)), new StreamResult(byteArrayOutputStream));
                AutoHelpAction.this.dialog.setContent(byteArrayOutputStream.toString());
                if (ApplicationModel.DEBUG_AUTODOC_FILE != null && ApplicationModel.DEBUG_MODE) {
                    ApplicationModel.debug("Debugging the auto doc file : " + ApplicationModel.DEBUG_AUTODOC_FILE);
                    try {
                        FileWriter fileWriter = new FileWriter(ApplicationModel.DEBUG_AUTODOC_FILE);
                        fileWriter.write(byteArrayOutputStream.toString());
                        fileWriter.close();
                    }
                    catch (RuntimeException runtimeException) {
                        runtimeException.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                AutoHelpAction.this.dialog.setContent("Error : " + throwable.getMessage());
            }
        }

        public void stopIt() {
        }
    }
}

