/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.xslt.profiler;

import com.icl.saxon.Context;
import com.icl.saxon.NodeHandler;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.trace.TraceListener;
import com.japisoft.editix.ui.xslt.XSLTEditor;
import com.japisoft.editix.ui.xslt.profiler.ProfilerElement;
import com.japisoft.editix.xslt.debug.NodeDebug;
import com.japisoft.editix.xslt.debug.Saxon1NodeDebug;
import com.japisoft.editix.xslt.debug.Saxon2NodeDebug;
import com.japisoft.editix.xslt.debug.SaxonTraceListener;
import com.japisoft.xmlpad.IXMLPanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.trace.InstructionInfo;

public class SaxonProfilerListener
implements TraceListener,
net.sf.saxon.trace.TraceListener {
    private IXMLPanel container;
    private static String NAMESPACE_XSLT = "http://www.w3.org/1999/XSL/Transform";
    private HashMap mapResult = null;

    public SaxonProfilerListener(IXMLPanel iXMLPanel) {
        this.container = iXMLPanel;
    }

    public void open() {
    }

    public void close() {
    }

    public void toplevel(NodeInfo nodeInfo) {
    }

    public void enterSource(NodeHandler nodeHandler, Context context) {
    }

    public void leaveSource(NodeHandler nodeHandler, Context context) {
    }

    public void enter(NodeInfo nodeInfo, Context context) {
        this.enter((Object)nodeInfo, new Saxon1NodeDebug(nodeInfo, context));
    }

    private void enter(Object object, NodeDebug nodeDebug) {
        if (NAMESPACE_XSLT.equals(nodeDebug.getNamespace())) {
            ProfilerElement profilerElement;
            if (this.mapResult == null) {
                this.mapResult = new HashMap();
            }
            if ((profilerElement = (ProfilerElement)this.mapResult.get(object)) == null) {
                profilerElement = new ProfilerElement();
                profilerElement.name = SaxonTraceListener.getPrettyLocalName(nodeDebug);
                profilerElement.iteration = 1;
                profilerElement.startingTime = System.currentTimeMillis();
                profilerElement.line = nodeDebug.getLineNumber();
                this.mapResult.put(object, profilerElement);
            } else {
                ++profilerElement.iteration;
            }
        }
    }

    public void leave(NodeInfo nodeInfo, Context context) {
        this.leaveSure(nodeInfo);
    }

    public void leaveSure(Object object) {
        ProfilerElement profilerElement = (ProfilerElement)this.mapResult.get(object);
        if (profilerElement != null) {
            profilerElement.totalTime += (double)(System.currentTimeMillis() - profilerElement.startingTime);
        }
    }

    public void enter(InstructionInfo instructionInfo, XPathContext xPathContext) {
        this.enter((Object)instructionInfo, new Saxon2NodeDebug(instructionInfo, xPathContext));
    }

    public void leave(InstructionInfo instructionInfo) {
        this.leaveSure(instructionInfo);
    }

    public void stopResult() {
        if (this.mapResult != null) {
            Collection collection = this.mapResult.values();
            ArrayList arrayList = new ArrayList(collection);
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    ProfilerElement profilerElement = (ProfilerElement)object;
                    ProfilerElement profilerElement2 = (ProfilerElement)object2;
                    return (int)(profilerElement2.totalTime - profilerElement.totalTime);
                }
            });
            this.container.setProperty(XSLTEditor.PROFILER_PROPERTY, arrayList);
        }
        this.container = null;
    }

    public void startCurrentItem(Item item) {
    }

    public void endCurrentItem(Item item) {
    }
}

