/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.xsd.view;

import com.japisoft.editix.ui.xsd.Factory;
import com.japisoft.editix.ui.xsd.toolkit.SchemaHelper;
import com.japisoft.editix.ui.xsd.view.CommonSelectionListener;
import com.japisoft.editix.ui.xsd.view.View;
import com.japisoft.editix.ui.xsd.view.designer.XSDAbstractComponentImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.TransferHandler;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MainTableViewImpl
extends JTable
implements View,
MouseListener,
MouseMotionListener {
    private Element schemaNode = null;
    private Factory factory = null;
    private CommonSelectionListener designerListener = null;
    ImageIcon deleteIcon = new ImageIcon(this.getClass().getResource("element_delete.png"));
    ImageIcon editIcon = new ImageIcon(this.getClass().getResource("element_view.png"));
    private int currentDragSelection = -1;

    public MainTableViewImpl(Factory factory) {
        this.factory = factory;
        this.setTransferHandler(new CustomTransferHandler());
    }

    public void init(Element element) {
        this.schemaNode = element;
        this.setModel(new CustomTableModel());
        CustomIconRenderer customIconRenderer = new CustomIconRenderer();
        this.getColumnModel().getColumn(0).setCellRenderer(customIconRenderer);
        this.getColumnModel().getColumn(0).setMaxWidth(20);
        this.getColumnModel().getColumn(3).setCellRenderer(customIconRenderer);
        this.getColumnModel().getColumn(3).setMaxWidth(20);
        CustomLabelRenderer customLabelRenderer = new CustomLabelRenderer();
        this.getColumnModel().getColumn(1).setCellRenderer(customLabelRenderer);
        this.getSelectionModel().setSelectionMode(0);
        this.getSelectionModel().setSelectionInterval(0, 0);
        this.setBackground(Color.WHITE);
        this.getColumnModel().getColumn(1).setCellEditor(new CustomTypeEditor());
        this.getSelectionModel().setSelectionInterval(0, 0);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        if (this.getParent() instanceof JViewport) {
            try {
                JViewport jViewport = (JViewport)this.getParent();
                Rectangle rectangle = this.getCellRect(this.getSelectedRow(), 0, true);
                Point point = jViewport.getViewPosition();
                rectangle.translate(-point.x, -point.y);
                jViewport.scrollRectToVisible(rectangle);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void stopEditing() {
        if (this.getCellEditor() != null) {
            this.getCellEditor().stopCellEditing();
        }
    }

    public JComponent getView() {
        return this;
    }

    public void dispose() {
        ((CustomTypeEditor)this.getColumnModel().getColumn(1).getCellEditor()).dispose();
        this.schemaNode = null;
        this.designerListener = null;
    }

    public void addNotify() {
        super.addNotify();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    public void select(Element element) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Element element2 = ((CustomTableModel)this.getModel()).searchElementAt(i);
            if (element2 != element) continue;
            this.getSelectionModel().setSelectionInterval(i, i);
            break;
        }
    }

    public void setCommonSelectionListener(CommonSelectionListener commonSelectionListener) {
        this.designerListener = commonSelectionListener;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        String string;
        int n = this.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        if (n > -1 && n2 == 3) {
            Element element;
            String string2 = (String)this.getValueAt(n, 1);
            String string3 = (String)this.getValueAt(n, 2);
            if (this.factory.confirmDialog("Delete " + string2 + " with name '" + string3 + "' ?") && (element = SchemaHelper.getElementAtRow(this.schemaNode, n)) != null) {
                this.schemaNode.removeChild(element);
                this.refreshModel();
                if (n > 0) {
                    this.getSelectionModel().setSelectionInterval(n - 1, n - 1);
                } else {
                    this.getSelectionModel().setSelectionInterval(0, 0);
                }
            }
        } else if ((n > -1 && n2 == 0 || n > -1 && mouseEvent.getClickCount() > 1) && this.canOpenDesigner(string = (String)this.getModel().getValueAt(n, 1))) {
            this.designerListener.openDesigner(SchemaHelper.getElementAtRow(this.schemaNode, n));
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        this.setToolTipText(null);
        if (n2 == 0) {
            this.setToolTipText("Click here for the visual mode");
        } else if (n2 == 3) {
            this.setToolTipText("Click here for deleting this element");
        } else {
            CustomTableModel customTableModel = (CustomTableModel)this.getModel();
            Element element = customTableModel.searchElementAt(n);
            if (element != null) {
                this.setToolTipText(XSDAbstractComponentImpl.getToolTip(element, "Double click for the visual mode"));
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.getTransferHandler().exportAsDrag(this, mouseEvent, 2);
    }

    public void refreshModel() {
        int n = this.getSelectedRow();
        ((CustomTableModel)this.getModel()).fireChange(new TableModelEvent(this.getModel()));
        this.getSelectionModel().setSelectionInterval(n, n);
    }

    private boolean canOpenDesigner(String string) {
        if (string == null) {
            return false;
        }
        return string.endsWith("element") || string.endsWith("complexType") || string.endsWith("group") || string.endsWith("attributeGroup");
    }

    class CustomTransferHandler
    extends TransferHandler {
        CustomTransferHandler() {
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            MainTableViewImpl.this.currentDragSelection = MainTableViewImpl.this.getSelectedRow();
            return jComponent == MainTableViewImpl.this && MainTableViewImpl.this.currentDragSelection > -1;
        }

        protected Transferable createTransferable(JComponent jComponent) {
            CustomTableModel customTableModel = (CustomTableModel)MainTableViewImpl.this.getModel();
            Element element = customTableModel.searchElementAt(MainTableViewImpl.this.getSelectedRow());
            if (element == null) {
                return new StringSelection("No node");
            }
            return new StringSelection(element.getNodeName());
        }

        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            CustomTableModel customTableModel = (CustomTableModel)MainTableViewImpl.this.getModel();
            int n2 = MainTableViewImpl.this.getSelectedRow();
            if (n2 > -1 && n2 != MainTableViewImpl.this.currentDragSelection) {
                Element element = customTableModel.searchElementAt(MainTableViewImpl.this.currentDragSelection);
                Element element2 = customTableModel.searchElementAt(n2);
                Element element3 = (Element)element.getParentNode();
                element3.removeChild(element);
                if (element2 != null) {
                    ((Element)element2.getParentNode()).insertBefore(element, element2);
                } else {
                    element3.appendChild(element);
                }
                MainTableViewImpl.this.refreshModel();
            }
        }

        public int getSourceActions(JComponent jComponent) {
            return 2;
        }
    }

    class CustomTableModel
    implements TableModel {
        private EventListenerList listenerList = new EventListenerList();

        CustomTableModel() {
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return "E";
            }
            if (n == 1) {
                return "Type";
            }
            if (n == 2) {
                return "Name";
            }
            return "x";
        }

        public int getRowCount() {
            NodeList nodeList = MainTableViewImpl.this.schemaNode.getChildNodes();
            int n = 0;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (!(nodeList.item(i) instanceof Element)) continue;
                ++n;
            }
            return n + 1;
        }

        Element searchElementAt(int n) {
            return SchemaHelper.getElementAtRow(MainTableViewImpl.this.schemaNode, n);
        }

        public Object getValueAt(int n, int n2) {
            Element element = this.searchElementAt(n);
            if (element == null) {
                return null;
            }
            if (n2 == 1) {
                return element.getNodeName();
            }
            if (n2 == 2) {
                return element.getAttribute("name");
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 2 || n2 == 1;
        }

        public void removeTableModelListener(TableModelListener tableModelListener) {
            this.listenerList.remove(TableModelListener.class, tableModelListener);
        }

        public void addTableModelListener(TableModelListener tableModelListener) {
            this.listenerList.add(TableModelListener.class, tableModelListener);
        }

        private void fireChange(TableModelEvent tableModelEvent) {
            EventListener[] eventListenerArray = this.listenerList.getListeners(TableModelListener.class);
            if (eventListenerArray != null) {
                for (int i = 0; i < eventListenerArray.length; ++i) {
                    ((TableModelListener)eventListenerArray[i]).tableChanged(tableModelEvent);
                }
            }
        }

        public void setValueAt(Object object, int n, int n2) {
            Element element = this.searchElementAt(n);
            if (n == this.getRowCount() - 1) {
                String string = (String)this.getValueAt(n, 1);
                String string2 = (String)this.getValueAt(n, 2);
                if (n2 == 1) {
                    string = (String)object;
                } else {
                    string2 = (String)object;
                }
                Element element2 = null;
                if (string == null || "".equals(string)) {
                    if (string2 != null && string2.length() > 0) {
                        element2 = SchemaHelper.createElement(MainTableViewImpl.this.schemaNode, "" + string2);
                    }
                } else {
                    element2 = SchemaHelper.createAnyPart(MainTableViewImpl.this.schemaNode, null, string);
                }
                if (element2 != null) {
                    MainTableViewImpl.this.schemaNode.appendChild(element2);
                    MainTableViewImpl.this.refreshModel();
                }
            } else if (element != null) {
                if (n2 == 2) {
                    element.setAttribute("name", "" + object);
                } else if (n2 == 1) {
                    int n3;
                    Element element3 = SchemaHelper.createAnyPart(MainTableViewImpl.this.schemaNode, null, "" + object);
                    NodeList nodeList = element.getChildNodes();
                    ArrayList<Node> arrayList = new ArrayList<Node>();
                    for (n3 = 0; n3 < nodeList.getLength(); ++n3) {
                        arrayList.add(nodeList.item(n3));
                    }
                    for (n3 = 0; n3 < arrayList.size(); ++n3) {
                        element.removeChild((Node)arrayList.get(n3));
                        element3.appendChild((Node)arrayList.get(n3));
                    }
                    MainTableViewImpl.this.schemaNode.replaceChild(element3, element);
                    MainTableViewImpl.this.refreshModel();
                }
            }
        }
    }

    class CustomLabelRenderer
    extends DefaultTableCellRenderer {
        private Color BG = new Color(200, 250, 200);
        private Font FT = this.getFont().deriveFont(1);

        CustomLabelRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                if (n2 == 1) {
                    jLabel.setFont(this.FT);
                }
            }
            return this;
        }
    }

    class CustomIconRenderer
    extends JButton
    implements TableCellRenderer {
        CustomIconRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 == 0) {
                this.setIcon(MainTableViewImpl.this.editIcon);
            } else if (n2 == 3) {
                this.setIcon(MainTableViewImpl.this.deleteIcon);
            }
            this.setEnabled(n != MainTableViewImpl.this.getRowCount() - 1);
            if (n2 == 0) {
                String string = (String)jTable.getModel().getValueAt(n, 1);
                this.setEnabled(MainTableViewImpl.this.canOpenDesigner(string));
            }
            return this;
        }
    }

    class CustomTypeEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ItemListener {
        private JComboBox cb = new JComboBox(){

            public void firePopupMenuWillBecomeInvisible() {
                CustomTypeEditor.this.fireEditingStopped();
            }
        };

        public CustomTypeEditor() {
            this.cb.addItemListener(this);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.cb.setModel(new DefaultComboBoxModel<String>(SchemaHelper.getParts(MainTableViewImpl.this.schemaNode, n)));
            this.cb.setSelectedItem(object);
            return this.cb;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.fireEditingStopped();
        }

        public Object getCellEditorValue() {
            return this.cb.getSelectedItem();
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                int n = MainTableViewImpl.this.rowAtPoint(mouseEvent.getPoint());
                return n == MainTableViewImpl.this.getRowCount() - 1;
            }
            return true;
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            return true;
        }

        public void dispose() {
            this.cb.removeItemListener(this);
        }
    }
}

