/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.panels.xquery;

import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.xmlpad.IXMLPanel;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.xml.validator.DefaultValidator;
import com.japisoft.xquery.XQueryEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.StringWriter;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trans.XPathException;
import org.jdesktop.layout.GroupLayout;

public class XQueryUI
extends JPanel
implements ActionListener {
    private JButton btnCopy;
    private JButton btnRun;
    JCheckBox cbOpenEditor;
    JCheckBox cbXMLOutput;
    private XQueryEditor xqueryEditor;
    private JTabbedPane jTabbedPane1;
    private JPanel pnlResult;
    private JPanel pnlXQuery;
    private JScrollPane spResult;
    private JTextArea xqueryResult;

    public XQueryUI(boolean bl, boolean bl2) {
        this.initComponents();
        this.cbOpenEditor.setSelected(bl2);
        this.cbXMLOutput.setSelected(bl);
        Icon icon = com.japisoft.framework.ui.Toolkit.getIconFromClasspath("images/gear_run.png");
        this.btnRun.setIcon(icon);
        this.getActionMap().put("run", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                XQueryUI.this.btnRun.doClick();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(10, 128), "run");
    }

    public void addNotify() {
        super.addNotify();
        this.btnRun.addActionListener(this);
        this.btnCopy.addActionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.btnRun.removeActionListener(this);
        this.btnCopy.removeActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block11: {
            block12: {
                if (actionEvent.getSource() != this.btnRun) break block12;
                if (EditixFrame.ACCESSOR.getSelectedContainer() == null) {
                    EditixFactory.buildAndShowErrorDialog("No selected document. Open a document");
                }
                this.xqueryEditor.getEditor().setCaretColor(Color.black);
                try {
                    DefaultValidator defaultValidator = new DefaultValidator(true, true);
                    if (!defaultValidator.notifyAction(EditixFrame.ACCESSOR.getSelectedContainer(), false)) {
                        EditixFactory.buildAndShowErrorDialog("Can't parse the current document, please fix it before evaluating");
                        return;
                    }
                    Configuration configuration = new Configuration();
                    StaticQueryContext staticQueryContext = new StaticQueryContext(configuration);
                    XQueryExpression xQueryExpression = staticQueryContext.compileQuery(this.xqueryEditor.getText());
                    DynamicQueryContext dynamicQueryContext = new DynamicQueryContext(configuration);
                    dynamicQueryContext.setContextNode((NodeInfo)staticQueryContext.buildDocument((Source)new DOMSource(defaultValidator.getDocument())));
                    StringWriter stringWriter = new StringWriter();
                    StreamResult streamResult = new StreamResult(stringWriter);
                    Properties properties = new Properties();
                    if (this.cbXMLOutput.isSelected()) {
                        properties.setProperty("method", "xml");
                        properties.setProperty("indent", "yes");
                    } else {
                        properties.setProperty("method", "text");
                    }
                    xQueryExpression.run(dynamicQueryContext, (Result)streamResult, properties);
                    this.xqueryResult.setText(stringWriter.toString());
                    this.jTabbedPane1.setSelectedIndex(1);
                    if (this.cbOpenEditor.isSelected()) {
                        IXMLPanel iXMLPanel = null;
                        String string = "XML";
                        iXMLPanel = EditixFactory.buildNewContainer(string, (String)null);
                        XMLContainer xMLContainer = iXMLPanel.getMainContainer();
                        xMLContainer.setText(stringWriter.toString());
                        EditixFrame.ACCESSOR.addContainer(iXMLPanel);
                    }
                    break block11;
                }
                catch (XPathException xPathException) {
                    SourceLocator sourceLocator = xPathException.getLocator();
                    EditixFactory.buildAndShowErrorDialog("Wrong expression : " + xPathException.getMessageAndLocation());
                    if (sourceLocator == null || sourceLocator.getLineNumber() == -1) break block11;
                    int n = sourceLocator.getLineNumber();
                    try {
                        int n2 = this.xqueryEditor.getDocument().getDefaultRootElement().getElement(n - 1).getStartOffset();
                        this.xqueryEditor.getEditor().setCaretPosition(n2 += sourceLocator.getColumnNumber() - 1);
                        this.xqueryEditor.getEditor().setCaretColor(Color.red);
                        this.xqueryEditor.requestFocus();
                        break block11;
                    }
                    catch (Exception exception) {}
                }
                {
                    break block11;
                }
            }
            if (actionEvent.getSource() == this.btnCopy) {
                String string = null;
                string = this.jTabbedPane1.getSelectedIndex() == 0 ? this.xqueryEditor.getText() : this.xqueryResult.getText();
                if (string != null) {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
                }
            }
        }
    }

    private void initComponents() {
        this.btnRun = new JButton();
        this.btnCopy = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.pnlXQuery = new JPanel();
        this.xqueryEditor = new XQueryEditor();
        this.pnlResult = new JPanel();
        this.spResult = new JScrollPane();
        this.xqueryResult = new JTextArea();
        this.cbXMLOutput = new JCheckBox();
        this.cbOpenEditor = new JCheckBox("Open a new editor");
        this.btnRun.setText("Run");
        this.btnCopy.setText("Copy");
        GroupLayout groupLayout = new GroupLayout((Container)this.pnlXQuery);
        this.pnlXQuery.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.xqueryEditor.getView(), -1, 363, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.xqueryEditor.getView(), -1, 309, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("XQuery", this.pnlXQuery);
        this.xqueryResult.setColumns(20);
        this.xqueryResult.setRows(5);
        this.spResult.setViewportView(this.xqueryResult);
        GroupLayout groupLayout2 = new GroupLayout((Container)this.pnlResult);
        this.pnlResult.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.spResult, -1, 363, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.spResult, -1, 309, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Result", this.pnlResult);
        this.cbXMLOutput.setText("XML output");
        this.cbXMLOutput.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbXMLOutput.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout3 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.jTabbedPane1, -1, 188, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.btnRun).addPreferredGap(0).add((Component)this.btnCopy)).add((Component)this.cbXMLOutput).add((Component)this.cbOpenEditor)).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.btnRun).add((Component)this.btnCopy, -2, 23, -2)).addPreferredGap(0).add((Component)this.jTabbedPane1, -1, 159, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.cbXMLOutput).addContainerGap().add((Component)this.cbOpenEditor)));
    }
}

