/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.panels.project;

import com.japisoft.editix.document.DocumentModel;
import com.japisoft.editix.project.ProjectManager;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.fastparser.swing.SwingNode;
import com.japisoft.framework.application.descriptor.ActionModel;
import com.japisoft.framework.preferences.Preferences;
import com.japisoft.framework.ui.FastLabel;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.XMLDocumentInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ProjectUI
extends JPanel
implements MouseListener,
MouseMotionListener,
ActionListener,
TreeSelectionListener {
    static final String[] TOOLBAR_ACTIONS = new String[]{"addf", "addd", "ren", "del", "lock"};
    static final String[] POPUP_ACTIONS = new String[]{"open", "addf", "addfs", "addd", "ren", "del", "check", "lock", null, "zip"};
    private JTree t;
    private JToolBar tb;
    private NodeTransfertHandler th;
    boolean dragAndDropInUse = false;
    private Point initLocation = null;
    DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor};

    public ProjectUI() {
        int n;
        this.setLayout(new BorderLayout());
        this.tb = new JToolBar();
        for (n = 0; n < TOOLBAR_ACTIONS.length; ++n) {
            this.tb.add(EditixFrame.ACCESSOR.getBuilder().getActionById("prj." + TOOLBAR_ACTIONS[n]));
        }
        this.add((Component)this.tb, "North");
        n = Preferences.getPreference(Preferences.SYSTEM_GP, "project.lock", true) ? 1 : 0;
        this.t = new JTree();
        this.add((Component)new JScrollPane(this.t), "Center");
        this.clean();
        this.t.setCellRenderer(new ProjectRenderer());
        this.th = new NodeTransfertHandler();
        this.t.setTransferHandler(this.th);
        this.setEnabledAction("del", false);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.getActionMap().put("delete", EditixFrame.ACCESSOR.getBuilder().getActionById("prj.del"));
    }

    private JPopupMenu buildPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (int i = 0; i < POPUP_ACTIONS.length; ++i) {
            if (POPUP_ACTIONS[i] == null) {
                jPopupMenu.addSeparator();
                continue;
            }
            jPopupMenu.add(EditixFrame.ACCESSOR.getBuilder().getActionById("prj." + POPUP_ACTIONS[i]));
        }
        JMenu jMenu = new JMenu("Filter");
        jMenu.add(new FilterActivatorAction(null));
        jMenu.addSeparator();
        for (int i = 0; i < DocumentModel.getDocumentCount(); ++i) {
            jMenu.add(new FilterActivatorAction(DocumentModel.getDocumentAt(i)));
        }
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenu);
        return jPopupMenu;
    }

    public void init() {
        this.t.setSelectionPath(new TreePath(this.t.getModel().getRoot()));
        this.valueChanged(null);
    }

    public void addNotify() {
        super.addNotify();
        this.t.addMouseListener(this);
        this.t.addMouseMotionListener(this);
        this.t.addTreeSelectionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.t.removeMouseListener(this);
        this.t.removeMouseMotionListener(this);
        this.t.removeTreeSelectionListener(this);
    }

    void setEnabledAction(String string, boolean bl) {
        ActionModel.setEnabled("prj." + string, bl);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = this.t.getSelectionPath();
        if (treePath != null) {
            SimpleNode simpleNode = (SimpleNode)treePath.getLastPathComponent();
            this.setEnabledAction("del", !simpleNode.isRoot());
            this.setEnabledAction("addf", simpleNode.isRoot() || simpleNode.matchContent("group"));
            this.setEnabledAction("addfs", simpleNode.isRoot() || simpleNode.matchContent("group"));
            this.setEnabledAction("addd", simpleNode.isRoot() || simpleNode.matchContent("group"));
            this.setEnabledAction("ren", simpleNode.isRoot() || simpleNode.matchContent("group"));
            this.setEnabledAction("open", simpleNode.matchContent("item"));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("lock".equals(string)) {
            this.lock();
        } else {
            if (this.t.getSelectionPath() == null) {
                return;
            }
            if ("addf".equals(string)) {
                this.addFile();
            } else if ("addd".equals(string)) {
                this.addGroup();
            } else if ("del".equals(string)) {
                this.delete();
            } else if ("ren".equals(string)) {
                this.rename((SimpleNode)this.t.getSelectionPath().getLastPathComponent());
            } else if ("check".equals(string)) {
                ProjectManager.checkFilesPath();
            } else if ("open".equals(string)) {
                this.openSelectedItem();
            } else if ("addf2".equals(string)) {
                this.addFile(true);
            } else if ("addfs".equals(string)) {
                this.addFiles(false);
            }
            this.refresh();
        }
    }

    void refresh() {
        TreePath treePath = this.t.getSelectionPath();
        ((ProjectTreeModel)this.t.getModel()).refresh();
        this.t.repaint();
        if (treePath != null) {
            this.t.setSelectionPath(treePath);
        }
    }

    private void addFile() {
        this.addFile(false);
    }

    private void addFile(boolean bl) {
        SimpleNode simpleNode = null;
        simpleNode = bl ? (SimpleNode)this.t.getModel().getRoot() : (SimpleNode)this.t.getSelectionPath().getLastPathComponent();
        XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        this.addFile(xMLContainer, simpleNode);
    }

    private void addFiles(boolean bl) {
        SimpleNode simpleNode = null;
        simpleNode = bl ? (SimpleNode)this.t.getModel().getRoot() : (SimpleNode)this.t.getSelectionPath().getLastPathComponent();
        boolean bl2 = false;
        for (int i = 0; i < EditixFrame.ACCESSOR.getXMLContainerCount(); ++i) {
            XMLContainer xMLContainer = EditixFrame.ACCESSOR.getXMLContainer(i);
            if (xMLContainer == null || xMLContainer.getCurrentDocumentLocation() == null) continue;
            this.addFile(xMLContainer, simpleNode);
            bl2 = true;
        }
        if (!bl2) {
            EditixFactory.buildAndShowErrorDialog("You need to have at least one opened XML document !");
        }
    }

    private void addFile(XMLContainer xMLContainer, SimpleNode simpleNode) {
        if (xMLContainer == null) {
            EditixFactory.buildAndShowErrorDialog("You need to have an opened XML document !");
        } else if (xMLContainer.hasProperty("save.delegate")) {
            EditixFactory.buildAndShowWarningDialog("Can't add this file");
        } else if (xMLContainer.getCurrentDocumentLocation() == null) {
            EditixFactory.buildAndShowErrorDialog("You must save your file before adding to the project");
        } else {
            SwingNode swingNode = ProjectManager.addItem(xMLContainer, simpleNode);
            if ("select".equals(swingNode.getApplicationObject())) {
                this.selectNode(swingNode);
            } else {
                this.expandNode(simpleNode);
            }
        }
    }

    private void addGroup() {
        String string = EditixFactory.buildAndShowInputDialog("Group name ?");
        if (string != null) {
            SimpleNode simpleNode = (SimpleNode)this.t.getSelectionPath().getLastPathComponent();
            this.selectNode(ProjectManager.addGroup(string, simpleNode));
        }
    }

    private void delete() {
        TreePath[] treePathArray = this.t.getSelectionPaths();
        if (treePathArray != null) {
            for (int i = 0; i < treePathArray.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)treePathArray[i].getLastPathComponent();
                SimpleNode simpleNode2 = simpleNode.getSimpleParent();
                if (simpleNode.matchContent("group") && !EditixFactory.buildAndShowConfirmDialog("Please confirm you wish to delete " + simpleNode.getAttribute("path"))) continue;
                ProjectManager.delete(simpleNode);
                this.selectNode(simpleNode2);
            }
        }
    }

    private TreePath convertToTreePath(SimpleNode simpleNode) {
        ArrayList<SimpleNode> arrayList = new ArrayList<SimpleNode>();
        while (simpleNode != null) {
            arrayList.add(0, simpleNode);
            simpleNode = simpleNode.getSimpleParent();
        }
        return new TreePath(arrayList.toArray());
    }

    private void selectNode(SimpleNode simpleNode) {
        final SimpleNode simpleNode2 = simpleNode;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreePath treePath = ProjectUI.this.convertToTreePath(simpleNode2);
                ProjectUI.this.t.setSelectionPath(treePath);
            }
        });
    }

    private void expandNode(SimpleNode simpleNode) {
        final SimpleNode simpleNode2 = simpleNode;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreePath treePath = ProjectUI.this.convertToTreePath(simpleNode2);
                ProjectUI.this.t.expandPath(treePath);
            }
        });
    }

    static boolean isLocked() {
        return Preferences.getPreference(Preferences.SYSTEM_GP, "project.lock", true);
    }

    private void lock() {
        boolean bl = ProjectUI.isLocked();
        bl = !bl;
        Preferences.setPreference(Preferences.SYSTEM_GP, "project.lock", bl);
        Action action = ActionModel.restoreAction("lock");
        action.putValue("SmallIcon", new ImageIcon(ClassLoader.getSystemResource("images/" + (bl ? "lock.png" : "lock_open.png"))));
    }

    public void clean() {
        this.t.setModel(new ProjectTreeModel(ProjectManager.getProjectRoot()));
        this.t.setSelectionPath(new TreePath(ProjectManager.getProjectRoot()));
    }

    public void loadProject(String string) {
        this.t.setModel(new ProjectTreeModel(ProjectManager.getProjectRoot()));
        this.t.setSelectionPath(new TreePath(ProjectManager.getProjectRoot()));
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.dragAndDropInUse && mouseEvent.getPoint().distance(this.initLocation) > 10.0) {
            this.th.exportAsDrag(this.t, mouseEvent, 2);
            TreePath treePath = this.t.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null) {
                this.t.setSelectionPath(treePath);
            }
            this.dragAndDropInUse = true;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.dragAndDropInUse = false;
        this.initLocation = null;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        TreePath treePath = this.t.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null) {
            SimpleNode simpleNode = (SimpleNode)treePath.getLastPathComponent();
            String string = simpleNode.getAttribute("path");
            ((ProjectRenderer)this.t.getCellRenderer()).fastlabel.setToolTipText(string);
            this.t.setToolTipText(string);
            ((JComponent)this.t.getParent()).setToolTipText(string);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || mouseEvent.getButton() >= 2) {
            JPopupMenu jPopupMenu = this.buildPopupMenu();
            jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            return;
        }
        if (mouseEvent.getClickCount() >= 2) {
            this.openSelectedItem();
        }
    }

    private void openSelectedItem() {
        if (this.t.getSelectionPath() == null) {
            return;
        }
        SimpleNode simpleNode = (SimpleNode)this.t.getSelectionPath().getLastPathComponent();
        if (simpleNode.matchContent("item")) {
            ProjectManager.openItem(simpleNode);
        }
    }

    private void rename(SimpleNode simpleNode) {
        String string = ProjectManager.getGroupName(simpleNode);
        String string2 = EditixFactory.buildAndShowInputDialog("New name", string);
        if (string2 != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < string2.length(); ++i) {
                if (!Character.isLetterOrDigit(string2.charAt(i))) continue;
                stringBuffer.append(string2.charAt(i));
            }
            if (stringBuffer.length() == 0) {
                stringBuffer.append("MyProject");
            }
            if (!(string2 = stringBuffer.toString()).equals(string)) {
                ProjectManager.updateGroupName(string2, simpleNode);
                this.refresh();
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.initLocation = mouseEvent.getPoint();
    }

    static /* synthetic */ void access$200(ProjectUI projectUI, SimpleNode simpleNode) {
        projectUI.selectNode(simpleNode);
    }

    class FilterActivatorAction
    extends AbstractAction {
        private String type = null;

        public FilterActivatorAction(XMLDocumentInfo xMLDocumentInfo) {
            if (xMLDocumentInfo != null) {
                this.putValue("SmallIcon", xMLDocumentInfo.getDocumentIcon());
                this.putValue("Name", xMLDocumentInfo.getDocumentDescription());
                this.type = xMLDocumentInfo.getType();
            } else {
                this.putValue("Name", "No filter");
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((ProjectTreeModel)ProjectUI.this.t.getModel()).setFilter(this.type);
        }
    }

    class NodeTransfertHandler
    extends TransferHandler {
        TreePath transferedPath = null;

        NodeTransfertHandler() {
        }

        public int getSourceActions(JComponent jComponent) {
            return 2;
        }

        public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
            super.exportAsDrag(jComponent, inputEvent, n);
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            if (this.transferedPath != null) {
                return jComponent instanceof JTree;
            }
            return dataFlavorArray[0].isFlavorJavaFileListType();
        }

        protected Transferable createTransferable(JComponent jComponent) {
            this.transferedPath = ProjectUI.this.t.getSelectionPath();
            Transferable transferable = new Transferable(){

                public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                    if (this.isDataFlavorSupported(dataFlavor)) {
                        String string = ((SimpleNode)NodeTransfertHandler.this.transferedPath.getLastPathComponent()).getAttribute("path");
                        if (string != null) {
                            string = string.replace('\\', '/');
                        }
                        return string;
                    }
                    return null;
                }

                public DataFlavor[] getTransferDataFlavors() {
                    return ProjectUI.this.flavors;
                }

                public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                    return dataFlavor.equals(DataFlavor.stringFlavor) || dataFlavor.isFlavorJavaFileListType();
                }
            };
            return transferable;
        }

        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            super.exportDone(jComponent, transferable, n);
            ProjectUI.this.dragAndDropInUse = false;
        }

        private SimpleNode addDirectory(File file, SimpleNode simpleNode) {
            SwingNode swingNode = new SwingNode(1, "group");
            swingNode.setAttribute("path", file.getName());
            String[] stringArray = file.list();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    File file2 = new File(file, stringArray[i]);
                    if (file2.isDirectory()) {
                        this.addDirectory(file2, swingNode);
                        continue;
                    }
                    if (!file2.isFile()) continue;
                    SwingNode swingNode2 = new SwingNode(1, "item");
                    String string = file2.toString();
                    swingNode2.setAttribute("path", string);
                    XMLDocumentInfo xMLDocumentInfo = DocumentModel.getDocumentByFileName(string);
                    swingNode2.setAttribute("type", xMLDocumentInfo.getType());
                    swingNode.addChildNode(swingNode2);
                }
            }
            simpleNode.addChildNode(swingNode);
            return swingNode;
        }

        /*
         * Exception decompiling
         */
        public boolean importData(JComponent var1_1, Transferable var2_2) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    class ProjectRenderer
    implements TreeCellRenderer {
        FastLabel fastlabel = new FastLabel(false);
        Icon drive = null;
        Icon document = null;
        Icon folder = null;
        Icon folder_closed = null;

        public ProjectRenderer() {
            try {
                this.drive = new ImageIcon(ClassLoader.getSystemResource("images/diskdrive.png"));
                this.document = new ImageIcon(ClassLoader.getSystemResource("images/document.png"));
                this.folder = new ImageIcon(ClassLoader.getSystemResource("images/folder.png"));
                this.folder_closed = new ImageIcon(ClassLoader.getSystemResource("images/folder_closed.png"));
            }
            catch (Throwable throwable) {
                System.err.println("Can't init icons ? : " + throwable.getMessage());
            }
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            String string;
            Object object2;
            Object object3;
            Icon icon = null;
            if (!(object instanceof SimpleNode)) {
                this.fastlabel.setText("?");
                this.fastlabel.setIcon(null);
                return this.fastlabel;
            }
            SimpleNode simpleNode = (SimpleNode)object;
            if (simpleNode.matchContent("item")) {
                object3 = simpleNode.getAttribute("type");
                object2 = DocumentModel.getDocumentForType((String)object3);
                icon = ((XMLDocumentInfo)object2).getDocumentIcon();
                String string2 = simpleNode.getAttribute("path");
                int n2 = string2.lastIndexOf(47);
                if (n2 == -1) {
                    n2 = string2.lastIndexOf(92);
                }
                string = n2 == -1 ? string2 : string2.substring(n2 + 1);
            } else {
                string = simpleNode.matchContent("group") ? simpleNode.getAttribute("path") : simpleNode.getContent();
                icon = !bl2 ? this.folder_closed : this.folder;
            }
            this.fastlabel.setIcon(icon);
            this.fastlabel.setText(string);
            if (bl) {
                this.fastlabel.setForeground(UIManager.getColor("List.selectionForeground"));
                this.fastlabel.setBackground(UIManager.getColor("List.selectionBackground"));
            } else {
                object3 = jTree.getForeground();
                object2 = jTree.getBackground();
                this.fastlabel.setForeground((Color)object3);
                this.fastlabel.setBackground((Color)object2);
            }
            if ("false".equals(simpleNode.getAttribute("test", "true"))) {
                this.fastlabel.setForeground(Color.RED);
            }
            return this.fastlabel;
        }
    }

    class ProjectTreeModel
    implements TreeModel {
        private SimpleNode root;
        private String type = null;
        private ArrayList listeners;

        ProjectTreeModel(SimpleNode simpleNode) {
            this.root = simpleNode;
        }

        public void setFilter(String string) {
            this.type = string;
            this.refresh();
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(treeModelListener);
        }

        public void refresh() {
            if (this.listeners != null) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    TreeModelListener treeModelListener = (TreeModelListener)this.listeners.get(i);
                    treeModelListener.treeStructureChanged(new TreeModelEvent((Object)ProjectUI.this.t, new TreePath(this.root)));
                }
            }
        }

        public Object getChild(Object object, int n) {
            SwingNode swingNode = (SwingNode)object;
            if (swingNode.isRoot() || swingNode.matchContent("group")) {
                if (this.type == null) {
                    return swingNode.childAt(n);
                }
                int n2 = -1;
                for (int i = 0; i < swingNode.childCount(); ++i) {
                    SimpleNode simpleNode = swingNode.childAt(i);
                    if (simpleNode.matchContent("group")) {
                        ++n2;
                    } else if (simpleNode.matchContent("item") && this.type.equals(simpleNode.getAttribute("type"))) {
                        ++n2;
                    }
                    if (n2 != n) continue;
                    return simpleNode;
                }
            }
            return null;
        }

        public int getChildCount(Object object) {
            SwingNode swingNode = (SwingNode)object;
            if (swingNode.isRoot() || swingNode.matchContent("group")) {
                if (this.type == null) {
                    return swingNode.childCount();
                }
                int n = 0;
                for (int i = 0; i < swingNode.childCount(); ++i) {
                    SimpleNode simpleNode = swingNode.childAt(i);
                    if (simpleNode.matchContent("group")) {
                        ++n;
                        continue;
                    }
                    if (!simpleNode.matchContent("item") || !this.type.equals(simpleNode.getAttribute("type"))) continue;
                    ++n;
                }
                return n;
            }
            return 0;
        }

        public int getIndexOfChild(Object object, Object object2) {
            SwingNode swingNode = (SwingNode)object;
            if (swingNode.isRoot() || swingNode.matchContent("group")) {
                return swingNode.childNodeIndex((SimpleNode)object2);
            }
            return -1;
        }

        public Object getRoot() {
            return this.root;
        }

        public boolean isLeaf(Object object) {
            SwingNode swingNode = (SwingNode)object;
            return swingNode.matchContent("item") || swingNode.getChildCount() == 0;
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            if (this.listeners != null) {
                this.listeners.remove(treeModelListener);
            }
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
        }
    }
}

