/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.panels;

import com.japisoft.editix.ui.panels.PanelManager;
import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.dockable.InnerWindowProperties;
import com.japisoft.framework.dockable.JDock;
import com.japisoft.framework.dockable.JDockEvent;
import com.japisoft.framework.dockable.JDockListener;
import com.japisoft.framework.dockable.action.BasicActionModel;
import com.japisoft.framework.dockable.action.common.CloseAction;
import com.japisoft.multipanes.BasicTitledPane;
import com.japisoft.multipanes.MultiPanes;
import com.japisoft.multipanes.TitledPane;
import com.japisoft.multipanes.TitledPaneEvent;
import com.japisoft.multipanes.TitledPaneListener;
import com.japisoft.multipanes.view.ActionTitledPaneView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class EditixDocking
extends JDock
implements JDockListener,
TitledPaneListener {
    private MultiPanes mp = null;
    private boolean restoringState = false;
    private HashMap hiddenPane;

    public void setPane(String string, String string2, Icon icon, JComponent jComponent) {
        if (this.mp == null) {
            UIManager.put("multipanes.arrowTitledPaneView.rightArrowColor", Color.LIGHT_GRAY);
            UIManager.put("multipanes.arrowTitledPaneView.downArrowColor", Color.BLACK);
            this.mp = new MultiPanes();
            try {
                this.mp.setDefaultSelectedTitledPaneFont(UIManager.getFont("Label.font").deriveFont(1));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            AbstractAction abstractAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PanelManager.hideByAction(actionEvent.getActionCommand());
                }
            };
            abstractAction.putValue("SmallIcon", new ImageIcon(ClassLoader.getSystemResource("images/window_delete.png")));
            this.mp.addTitledPaneListener(this);
            this.mp.setView(new ActionTitledPaneView(abstractAction));
            this.mp.setPreferredSize(new Dimension(200, 100));
            this.addInnerWindow(new InnerWindowProperties("mp", "Panels", null, BasicActionModel.getInstance(new CloseAction()), this.mp), (Object)"West");
        }
        this.mp.getModel().addTitledPane(new BasicTitledPane(string, string2, icon, string2, jComponent));
    }

    public boolean hasPane(String string) {
        return this.mp != null && this.mp.getModel().getTitledPaneByName(string) != null || this.hiddenPane != null && this.hiddenPane.containsKey(string);
    }

    public void showPane(String string) {
        try {
            if (this.isInnerWindowHidden("mp")) {
                this.showInnerWindow("mp");
            }
            if (this.isHiddenPane(string)) {
                TitledPane titledPane = (TitledPane)this.hiddenPane.get(string);
                this.mp.getModel().addTitledPane(titledPane);
                this.hiddenPane.remove(string);
            }
            if (this.mp != null) {
                this.mp.open(string);
                int n = this.mp.getWidth();
                if (this.mp.getModel().getTitledPaneByName(string) != null) {
                    Dimension dimension = this.mp.getModel().getTitledPaneByName(string).getView().getPreferredSize();
                    if (n < dimension.width) {
                        this.resize("mp", dimension.width - n, 0);
                    }
                }
            }
            PanelManager.saveShownState(string);
        }
        catch (RuntimeException runtimeException) {
            ApplicationModel.debug(runtimeException);
        }
    }

    protected void setUIReady(boolean bl) {
        if (bl) {
            this.restoringState = true;
            PanelManager.restoreState();
            this.addJDockListener(this);
            this.restoringState = false;
        }
    }

    public boolean isHiddenPanes() {
        return this.isInnerWindowHidden("mp");
    }

    public void hidePane(String string) {
        if (this.hiddenPane == null) {
            this.hiddenPane = new HashMap();
        }
        TitledPane titledPane = this.mp.getModel().getTitledPaneByName(string);
        this.hiddenPane.put(string, titledPane);
        this.mp.getModel().removeTitledPane(titledPane);
        if (this.mp.getModel().getTitledPaneCount() == 0) {
            this.hidePanes();
        } else {
            this.mp.open(this.mp.getModel().getTitledPaneAt(0).getName());
        }
    }

    public boolean isHiddenPane(String string) {
        return this.hiddenPane != null && this.hiddenPane.containsKey(string);
    }

    public void hidePanes() {
        this.hideInnerWindow("mp");
    }

    public void jdockAction(JDockEvent jDockEvent) {
        if (jDockEvent.getType() == 4 && "mp".equals(jDockEvent.getId())) {
            PanelManager.saveState(true);
            PanelManager.saveShownState(null);
        }
    }

    public void closed(TitledPaneEvent titledPaneEvent) {
    }

    public void opened(TitledPaneEvent titledPaneEvent) {
        PanelManager.saveShownState(titledPaneEvent.getSelectedTitledPane().getName());
    }
}

